//============================================================================================
/**
 * @file		strinput_ui.cpp
 * @brief		UI֘A
 * @author	Hiroyuki Nakamura
 * @date		11.07.04
 *
 * namespace	app::strinput::
 */
//============================================================================================
#include "strinput_ui.h"


namespace app {
namespace strinput {


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
UI::UI( const Heap * heap )
{
	CreateUI( heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
UI::~UI(void)
{
	DeleteUI();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fobOpI{^擾
 *
 * @param		none
 *
 * @retval	"true = ꂽ"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool UI::DEBUG_GetEndButton(void)
{
	return pButton->IsTrigger( gfl::ui::BUTTON_B );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		UI֘A쐬
 *
 * @param		haap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void UI::CreateUI( const Heap * heap )
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	pUiDeviceManager = pgm->GetUiDeviceManager();
	pButton     = pUiDeviceManager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
	pKey        = pUiDeviceManager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
	pStick      = pUiDeviceManager->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
	pTouchPanel = pUiDeviceManager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );

#ifdef	USE_UI_GYROSCOPE
	// WC
	pUiDeviceManager->BootGyroscope( heap->Get(), gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	pGyroscope  = pUiDeviceManager->GetGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
	pGyroscope->SetZeroDriftMode( gfl::ui::Gyroscope::ZERO_DRIFT_MODE_TIGHT );
	pGyroscope->DisableRevisionByAcceleration();
	pGyroscope->DisableZeroDrift();
#endif	// USE_UI_GYROSCOPE

#ifdef	USE_UI_ACCELEROMETER
	// xZT[
	pUiDeviceManager->BootAccelerometer( heap->Get(), gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
	pAccelerometer = pUiDeviceManager->GetAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
#endif	// USE_UI_ACCELEROMETER
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		UI֘A폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void UI::DeleteUI(void)
{
#ifdef	USE_UI_ACCELEROMETER
	pUiDeviceManager->StopAccelerometer( gfl::ui::CTR_DeviceManager::ACCELEROMETER_STANDARD );
#endif	// USE_UI_ACCELEROMETER
#ifdef	USE_UI_GYROSCOPE
	pUiDeviceManager->StopGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
#endif	// USE_UI_GYROSCOPE
}






}		// strinput
}		// app
