//============================================================================================
/**
 * @file		strinput_main.h
 * @brief		C
 * @author	Hiroyuki Nakamura
 * @date		11.07.04
 *
 * namespace	app::strinput::
 */
//============================================================================================
#pragma	once

#include "app/strinput/strinput.h"
#include "strinput_heap.h"
#include "strinput_2d.h"
#include "strinput_3d.h"


namespace app {
namespace strinput {

class UI;		// UI֘A


// Tu[NiʑJڎɉj
typedef struct {
	gfl::grp::GraphicsSystem * pGraSystem;
	G2DSystem * pG2d;
	G3DSystem * pG3d;
	UI * ui;
}SUB_WORK;

// C[N
typedef struct {
	APP_PARAM * prm;

	int	mainSeq;
	int	nextSeq;
}MAIN_WORK;


class MainSystem {
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	MainSystem( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~MainSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @retval	"true = "
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`揈
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateSubWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Tu[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteSubWork(void);

	// OtBbNXVXe
	void CreateGraphicsSystem(void);
	void DeleteGraphicsSystem(void);


// CV[PX
public:
	int MainSeq_Init(void);
	int MainSeq_Release(void);
	int MainSeq_Main(void);

private:
	MAIN_WORK	mainWork;		// C[N
	SUB_WORK * subWork;
	Heap	heap;
};

}		// strinput
}		// app
