//============================================================================================
/**
 * @file		strinput_2d.h
 * @brief		2D֘A
 * @author	Hiroyuki Nakamura
 * @date		11.07.11
 *
 * namespace	app::strinput::
 */
//============================================================================================
#pragma	once

#include <gflib.h>
#include <gfl_Device.h>

#include "strinput_heap.h"


namespace app {
namespace strinput {

// \fBXvC`
enum {
	SETUP_UPPER = 0,		// 
	SETUP_LOWER,				// 
};

// CAEg[Nݒf[^
typedef struct {
	gfl::grp::g2d::LytArcIndex	lytDataID;						// resID̃CAEgf[^ID
	const gfl::grp::g2d::LytArcIndex * anmDataIDTbl;	// Aj[Vf[^IDe[u	AĵȂꍇNULL
	u32 anmTblNum;																		// Aj[Vf[^IDe[u AĵȂꍇ0
	u32 anmMax;																				// o^Aj[Vő吔
	u32	setupDisp;																		// fBXvC
}LYTWK_DATA;


class G2DSystem {
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		gra			OtBbNVXe
	 * @param		lytMax	CAEg[Nő吔
	 * @param		heap		q[v
	 */
	//--------------------------------------------------------------------------------------------
	G2DSystem( gfl::grp::GraphicsSystem * gra, u32 lytMax, Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~G2DSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg`
	 *
	 * @param		id		`悷郌CAEgID
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw( u32 id );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEgݒ
	 *
	 * @param		dat		CAEgf[^
	 * @param		id		ݒ肷郌CAEgID
	 * @param		num		ݒ肷f[^iftHg = 1 j
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetLayoutWork( const LYTWK_DATA * dat, u32 id, u32 num = 1 );

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEgVXe쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutSystem( Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEgVXe폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutEnv( Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutEnv(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N쐬
	 *
	 * @param		lytMax		쐬
	 * @param		heap			q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutWork( u32 lytMax, Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		bZ[W֘A쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateMessageData( Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		bZ[W֘A폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteMessageData(void);

private:
	gfl::grp::GraphicsSystem * pGraSystem;		// OtBbNVXe

	// CAEg[NǗ
	typedef struct {
		gfl::grp::g2d::LytWk * pLytWk;	// CAEg[N
		u32	setupDisp;									// `
	}LAYOUT_WORK;

	gfl::grp::g2d::LytSys * pLayoutSystem;		// CAEgVXe
	gfl::grp::g2d::LytResID	layoutResID;			// \[XID
	gfl::grp::g2d::Env * pUpperLayoutEnv;			// ʂ̃CAEg
	gfl::grp::g2d::Env * pLowerLayoutEnv;			// ʂ̃CAEg
//	gfl::grp::g2d::LytWk * pUpperLayoutWork;
//	gfl::grp::g2d::LytWk * pLowerLayoutWork;
//	gfl::grp::g2d::LytWk ** pLayoutWork;
	LAYOUT_WORK * pLayoutWork;								// CAEg[NǗf[^
	u32	lwkMax;																// CAEg[NǗf[^

	gfl::str::MsgData * pMsgData;		// bZ[Wf[^
	WordSet * pWordSet;							// PZbg
};


}	// strinput
}	// app
