//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		AreaData.cpp
 *	@brief  GAf[^
 *	@author	tomoya takahashi
 *	@date		2011.07.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "field/AreaData.h"

#include "arc/arc_def.h"
#include "arc/field_area_bin.gaix"


namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------


  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   *	
   *	@param	p_heap  q[v
   */
  //-----------------------------------------------------------------------------
  AreaData::AreaData( gfl::heap::HeapBase* p_heap ) : 
    m_pHeap(p_heap),
    m_pArcFile(NULL),
    m_AreaID(AREA_ID_FIELD),
    m_Season(gamesystem::PMSeason::SPRING)
  {
    // A[JCut@C̓ǂݍ
    m_pArcFile = GFL_NEW( m_pHeap ) gfl::fs::ArcFile( ARCID_FIELD_AREADATA );
    m_pArcFile->StartSetupForFastMode( m_pHeap );
  }

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  AreaData::~AreaData()
  {
    GFL_DELETE m_pArcFile;
    m_pArcFile = NULL;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  GAf[^ǂݍ݃NGXg
   *
   *	@param	areaID  GAID
   *	@param  season  V[YID
   *
   *	@retval true  ǂݍ݂JnłB
   *	@retval false ǂݍ݂JnłԂł͂ȂB
   */
  //-----------------------------------------------------------------------------
  bool AreaData::LoadReq( AreaID areaID, gamesystem::PMSeason::Season season )
  {
    if( m_pArcFile->IsSetupForFastModeFinished() == false )
    {
      return false;
    }
    
    m_pArcFile->StartAsyncRead( m_pHeap, GARC_field_area_bin_area_data_BIN, (areaID + season) * sizeof( Data ), sizeof( Data ),
        &m_AreaData, MAIN_THREAD_PRIORITY+1 );

    m_AreaID = areaID;
    m_Season = season;
    
    return true;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ̏ŁAGAf[^ǂݍ
   *
   *	@param	areaID  GAID
   *	@param  season  V[YID
   */
  //-----------------------------------------------------------------------------
  bool AreaData::LoadAtOnce( AreaID areaID, gamesystem::PMSeason::Season season )
  {
    if( m_pArcFile->IsSetupForFastModeFinished() == false )
    {
      return false;
    }
    u32 dataID;

    if( IsHasSeason(areaID) ){
      dataID = (areaID + season);
    }else{
      dataID = areaID;
    }
    
    m_pArcFile->LoadDataPiece( GARC_field_area_bin_area_data_BIN, dataID * sizeof( Data ), sizeof( Data ), &m_AreaData );

    m_AreaID = static_cast<AreaID>(dataID);
    m_Season = season;
    
    return true;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ǂݍ݊`FbN
   *
   *	@retval true  ǂݍ݊
   *	@retval false ǂݍݓr
   */
  //-----------------------------------------------------------------------------
  bool AreaData::IsLoaded( void ) const
  {
    if( m_pArcFile->IsSetupForFastModeFinished() )
    {
      if( !m_pArcFile->CheckAsyncRead() )
      {
        return true; 
      }
    }

    return false;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  G߂̂GA`FbN
   *
   *	@param	areaID  GAID
   *
   *	@retval true    G߂
   *	@retval false   G߂Ȃ
   */
  //-----------------------------------------------------------------------------
  bool AreaData::IsHasSeason( AreaID areaID )
  {
    return false;
  }



} // field

