//======================================================================
/**
 * @file  battle_movie.cpp
 * @brief LeXgFog
 * @author  ariizumi
 * @data  11/05/16
 */
//======================================================================

#include <gflib.h>

#include "battle_ar_test.h"


namespace test
{
namespace ariizumi
{

#define USE_EDGE_MAP 0
  
//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result BattleArTest::InitFunc(gfl::proc::Manager* pManager)
{

  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
  
  mHeapMem = gfl::heap::Manager::CreateHeap( heap_memory, HEAPID_TEST_ARIIZUMI    , 0x500000  , gfl::heap::HEAP_TYPE_EXP );
  mDevMem = gfl::heap::Manager::CreateHeap( device_memory,HEAPID_TEST_ARIIZUMI_DEV, 0x1480000 , gfl::heap::HEAP_TYPE_EXP );

  mBattleProc = GFL_NEW(mHeapMem) btl::BattleMainProc();
  
  mBattleProc->SetGameProcManager( mpGameProcManager );
  
  //og̃ZbgAbv
  {
    gamesystem::GameData* gameData = mpGameProcManager->GetGameManager()->GetGameData();

    pml::bridge::CtrAllocator allocator( mHeapMem );
    m_btlEnemyParty = GFL_NEW(mHeapMem) pml::PokeParty( mHeapMem );

    // vC[莝
    for( int i=0;i<6;i++ )
    {
      m_btlSelfPoke[i] = NULL;
      m_btlEnemyPoke[i] = NULL;
    }
    pml::PokeParty* playerParty = gameData->GetPlayerParty();
    playerParty->Clear();
    m_btlEnemyParty->Clear();
    for( int i=0;i<5;i++ )
    {

      m_btlSelfPoke[i] = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, (MonsNo)(MONSNO_PIKATYUU+i), 20+i, 0 );
      playerParty->AddMember( *m_btlSelfPoke[i] );
      
    }
    for( int i=0;i<1;i++ )
    {
      m_btlEnemyPoke[i] = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, (MonsNo)(MONSNO_SIKIZIKA+i), 10+i, 0 );
      m_btlEnemyParty->AddMember( *m_btlEnemyPoke[i] );
    }

    BATTLE_SETUP_FIELD_SITUATION_Init( &m_btlFieldSit );
    //BATTLE_SETUP_Wild( &m_btlSetupParam, gameData, m_btlEnemyParty, &m_btlFieldSit, BTL_RULE_BAND, mHeapMem );
    BATTLE_SETUP_Wild( &m_btlSetupParam, gameData, m_btlEnemyParty, &m_btlFieldSit, BTL_RULE_SINGLE, mHeapMem );

    mBattleProc->SetupParam( &m_btlSetupParam, mHeapMem, mDevMem );
  }
  
  //og̃ZbgAbv܂


  //ARpZbgAbv
  mArData = &m_btlSetupParam.arData;
  
  mArData->is_enable = true;
  mArData->poke_pos[0].Set( 89.0f,0.0f, 220.0f);
  mArData->poke_pos[1].Set( 80.0f,0.0f,-66.0f);
  mArData->camera_pos.Set( 153.0f,  44.0f, 257.0f);
  mArData->camera_trg.Set( -38.0f,  11.0f, -74.0f);
  //ARpZbgAbv܂
  
  mBattleProc->InitFunc(pManager);
  
  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result BattleArTest::EndFunc(gfl::proc::Manager* pManager)
{
  GFL_UNUSED( pManager );

  mBattleProc->EndFunc(pManager);

  //oǧ㏈
  {
    gamesystem::GameData* gameData = mpGameProcManager->GetGameManager()->GetGameData();
    pml::PokeParty* playerParty = gameData->GetPlayerParty();
    
    playerParty->Clear();
    m_btlEnemyParty->Clear();
    GFL_DELETE( m_btlEnemyParty );
    m_btlEnemyParty = NULL;

    for( int i=0;i<6;i++ )
    {
      if( m_btlSelfPoke[i] )
      {
        pml::System::PokeParaFactory()->DeletePokemonParam( m_btlSelfPoke[i] );         
        m_btlSelfPoke[i] = NULL;
      }
      if( m_btlEnemyPoke[i] )
      {
        pml::System::PokeParaFactory()->DeletePokemonParam( m_btlEnemyPoke[i] );          
        m_btlEnemyPoke[i] = NULL;

      }
    }

    BATTLE_SETUP_Clear( &m_btlSetupParam );
  }
  //oǧ㏈܂

  gfl::heap::Manager::DeleteHeap( mHeapMem );
  gfl::heap::Manager::DeleteHeap( mDevMem );

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result BattleArTest::UpdateFunc(gfl::proc::Manager* pManager)
{

  mBattleProc->UpdateFunc(pManager);

 return gfl::proc::RES_CONTINUE;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result BattleArTest::NextFrameMainFunc(gfl::proc::Manager* pManager)
{

  mBattleProc->NextFrameMainFunc(pManager);
  return gfl::proc::RES_CONTINUE;
}

void BattleArTest::DrawFunc(gfl::proc::Manager* pManager)
{

  mBattleProc->DrawFunc(pManager);

}
  
  
}//namespace test
}//namespace ariizumi
