//================================================================================
/**
 * @file   test_ohno_cec.cpp
 * @brief  Ⴂ̃f[^eXg
 * @author k.ohno
 * @date   2010.12.15
 */ 
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "test_ohno_cec.h"


GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)



    //-----------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------
TestOhnoCec::TestOhnoCec( 
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{ 



  {
    gfl::heap::HeapBase* sysHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
    gfl::heap::Manager::CreateHeap( sysHeap, HEAPID_NETAPP_CEC,
                                    xy_system::Heapsize::NETAPP_CEC, gfl::heap::HEAP_TYPE_EXP );

    mpCec = GFL_NEW(sysHeap) netapp::cec::CecSystem;
    mpCec->Initialize(gfl::heap::Manager::GetHeapByHeapId( HEAPID_NETAPP_CEC ));

    mpCec->CreateBox();
    mpCec->CreateMessage();
  }

  
}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
TestOhnoCec::~TestOhnoCec()
{
  {
    gfl::heap::Manager::DeleteHeap( mpCec->Finalize() );
    GFL_DELETE(mpCec);
  }
}


//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------
void TestOhnoCec::UpdateTest( void )
{
  if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ) {

  }
  
  // START {^ŏI
  if( m_button->IsTrigger( gfl::ui::BUTTON_START ) ) {
    this->End();
  }
} 



//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void TestOhnoCec::DrawTest( void )
{
}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
