#ifndef __TEST_OHNO_MENU_H__
#define __TEST_OHNO_MENU_H__
//======================================================================
/**
 * @file	  ohno_debug.h
 * @brief	  fobOC
 * @author	k.ohno
 * @data	  2010/10/22
 */
//======================================================================
#include <gfl_Base.h>
#include <gfl_UI.h>
#include "test_ohno_Base.h"

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)


class Menu : public Base
{
  GFL_FORBID_COPY_AND_ASSIGN( Menu );

public:

  // j[
  struct MenuItemData {
    u32 itemID;           // ID (IɎ擾łl)
    u32 paneID;           // yC
    const wchar_t* label; // \镶
  };

  // j[S
  struct MenuData {
    const wchar_t* lytResFileName;          // CAEgf[^̃t@C
    gfl::grp::g2d::LytArcIndex arcIndex; // CAEg[ÑA[JCuCfbNX
    u32 itemNum;                         // ڐ
    const MenuItemData* items;           // eڂ̃f[^
  };


  // ZbgAbvp[^
  struct SetupParam {
    gfl::heap::HeapBase* pHeap;       // q[v
    gfl::heap::HeapBase* pDeviceHeap; // foCXq[v
    const MenuData* pMenuData;        // j[f[^
  };

  //------------------------------------------------------------------------------
  /**
   * @brief RXgN^
   * @param heap              eXgŎgpq[v
   * @param device_heap       eXgŎgpfoCXq[v
   * @param heap_allocator    eXgŎgpAP[^
   * @param device_allocator  eXgŎgpfoCXAP[^
   * @param graphics_system   fXgŎgpOtBbNXVXe
   * @param ui_device_manager eXgŎgpUIfoCX
   */
  //------------------------------------------------------------------------------
  Menu(
    gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
    gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
    gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager,
    const MenuData* pMenuData );

  //------------------------------------------------------------------------------
  /**
   * @brief fXgN^
   */
  //------------------------------------------------------------------------------
  virtual ~Menu();


  //------------------------------------------------------------------------------
  /**
   * @brief Iǂ𒲂ׂ
   */
  //------------------------------------------------------------------------------
  bool IsSelected( void ) const;

  //------------------------------------------------------------------------------
  /**
   * @brief LZǂ𒲂ׂ
   */
  //------------------------------------------------------------------------------
  bool IsCanceled( void ) const;

  //------------------------------------------------------------------------------
  /**
   * @brief Ij[̍ID擾
   */
  //------------------------------------------------------------------------------
  int GetSelectedItemID( void ) const;



protected:

  const MenuData* m_pMenuData; // j[f[^
  int m_curIdx;                // ݑI𒆂̃j[ڂ̃CfbNX
  int m_selectedIdx;           // Iڂ̃CfbNX
  bool m_selectFlag;           // Iǂ
  bool m_cancelFlag;           // LZǂ

  gfl::grp::g2d::LytSys* m_LytSys;
  gfl::grp::g2d::LytResID m_ResID;
  gfl::grp::g2d::LytWk* m_LytWk;
  gfl::grp::g2d::Env* m_UpperEnv;
  gfl::grp::g2d::Env* m_LowerEnv;


private:

  // eXg̃C
  virtual void UpdateTest( void );
  virtual void DrawTest( void );

  // CAEgVXe
  void InitializeLayoutSystem( const MenuData* menuData );

  // CAEgVXej
  void FinalizeLayoutSystem( void );

  // j[ڂȈԂɂ
  void SetMenuItemValid( u8 menuItemIdx );

  // j[ڂȈԂɂ
  void SetMenuItemInvalid( u8 menuItemIdx );
};


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
#endif //__TEST_OHNO_MENU_H__
