///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ohno_Menu.cpp
 * @brief  j[
 * @author ̂삪gp
 * @date   2011.07.16
 */
///////////////////////////////////////////////////////////////////////////////////////
#include <nn.h>
#include <gflib.h>
#include "test_ohno_Menu.h"
#include "test_menu_lyt_res.h"
#include "test_menu_lyt_res_pane.h"

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)



namespace menu {

  // ZbgAbv
  static const gfl::grp::g2d::LytWkSetUp s_LytWkSetUp[] = {
    {
      gfl::math::VEC3(0,0,0),   // pos
      gfl::math::VEC2(1,1),     // scale
      gfl::math::VEC3(0,0,0),   // rotate
      1,                        // priority
    },
  };

  static const gfl::grp::ProjectionParam sc_ProjectionParam[ 2 ] = {
    // p
    {
      gfl::grp::PROJECTION_ORTHO,
      { -200.0f, 200.0f, -120.0f, 120.0f },
      0.10f,
      800.0f,
      gfl::math::PIVOT_UPSIDE_TO_TOP
      },
    // p
    {
      gfl::grp::PROJECTION_ORTHO,
      { -160.0f, 160.0f, -120.0f, 120.0f },
      0.10f,
      800.0f,
      gfl::math::PIVOT_UPSIDE_TO_TOP
      },
  };

  static gfl::grp::ViewParam sc_ViewParam[] = {
    // p
    {
      gfl::math::VEC3(0,0,1),
      gfl::math::VEC3(0,1,0),
      gfl::math::VEC3(0,0,0)
      },
    // p
    {
      gfl::math::VEC3(0,-290,1),
      gfl::math::VEC3(0,1,0),
      gfl::math::VEC3(0,-290,0)
      },
    // p
    {
      gfl::math::VEC3(1,0,1),
      gfl::math::VEC3(0,1,0),
      gfl::math::VEC3(1,0,0)
      },
  };

} // namespace menu




//-----------------------------------------------------------------------------
// RXgN^
//-----------------------------------------------------------------------------
Menu::Menu(
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager,
  const MenuData* pMenuData ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager ),
m_pMenuData( pMenuData ),
m_curIdx( 0 ),
m_selectedIdx( 0 ),
m_selectFlag( false ),
m_cancelFlag( false ),
m_LytSys( NULL ),
m_ResID( 0 ),
m_LytWk( NULL ),
m_UpperEnv( NULL ),
m_LowerEnv( NULL )
{
  this->InitializeLayoutSystem( pMenuData );
}


// CAEgVXe
void Menu::InitializeLayoutSystem( const MenuData* menuData )
{
  // CAEgVXe
  {
    static const gfl::grp::g2d::LytSysSetUp SetUp = {
      10, // lyt_resource_max
      10  // lyt_wk_max
      };

    m_LytSys = GFL_NEW(m_heap) gfl::grp::g2d::LytSys(&SetUp, m_heap_allocator, m_device_allocator);

    // \[Xǂݍ
    gfl::fs::ArcFile* arc = GFL_NEW(m_heap) gfl::fs::ArcFile( menuData->lytResFileName, m_heap );
    m_ResID = m_LytSys->LoadLytRes( m_device_allocator, arc, 0 );
    GFL_DELETE arc;

    // VRAMɃeNX`]B
    m_LytSys->TransferAllTexture( m_ResID, gfl::grp::MEMORY_AREA_FCRAM );

    // CAEg[N
    m_LytWk  = m_LytSys->CreateLytWk( m_ResID, menuData->arcIndex, NULL, 0, 0, &menu::s_LytWkSetUp[0] );
  }

  // [U[EnvgpB
  {
    m_UpperEnv = GFL_NEW(m_heap) gfl::grp::g2d::Env();
    m_LowerEnv = GFL_NEW(m_heap) gfl::grp::g2d::Env();

    m_UpperEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, menu::sc_ProjectionParam[0], menu::sc_ViewParam[0] );
    m_UpperEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, menu::sc_ProjectionParam[0], menu::sc_ViewParam[2] );

    m_LowerEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, menu::sc_ProjectionParam[1], menu::sc_ViewParam[1] );
    m_LowerEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, menu::sc_ProjectionParam[1], menu::sc_ViewParam[1] );

    m_LytWk->SetUserEnv( m_UpperEnv, m_LowerEnv );
  }

  // eLXg{bNXyCɕݒ
  for( int i=0; i<menuData->itemNum; i++ )
    {
      gfl::grp::g2d::LytTextBox* textBox = m_LytWk->GetTextBoxPane( menuData->items[i].paneID );
      GFL_ASSERT( textBox );
      textBox->SetString( menuData->items[i].label );
    }
}



//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
Menu::~Menu()
{
  this->FinalizeLayoutSystem();
}

// CAEgVXej
void Menu::FinalizeLayoutSystem( void )
{
  GFL_DELETE m_UpperEnv;
  GFL_DELETE m_LowerEnv;
  GFL_DELETE m_LytSys;
}





//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------
void Menu::UpdateTest( void )
{
  if( m_selectFlag || m_cancelFlag ) {
    return;
  }

  // I
  if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
    m_selectedIdx = m_curIdx;
    m_selectFlag = true;
    this->End();
    return;
  }

  // LZ
  if( m_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
    m_cancelFlag = true;
    this->End();
    return;
  }

  // J[\ړ
  if( m_crosskey->IsRepeat( gfl::ui::DIR_DOWN ) ) {
    this->SetMenuItemInvalid( m_curIdx );
    m_curIdx = ( m_curIdx + 1 ) % m_pMenuData->itemNum;
    this->SetMenuItemValid( m_curIdx );
  }

  // J[\ړ
  if( m_crosskey->IsRepeat( gfl::ui::DIR_UP ) ) {
    this->SetMenuItemInvalid( m_curIdx );
    m_curIdx = ( m_curIdx + m_pMenuData->itemNum - 1 ) % m_pMenuData->itemNum;
    this->SetMenuItemValid( m_curIdx );
  }

  // J[\ړ
  if( m_crosskey->IsRepeat( gfl::ui::DIR_RIGHT ) ) {
    this->SetMenuItemInvalid( m_curIdx );
    m_curIdx = ( m_curIdx + 14 ) % m_pMenuData->itemNum;
    this->SetMenuItemValid( m_curIdx );
  }

  // J[\ړ
  if( m_crosskey->IsRepeat( gfl::ui::DIR_LEFT ) ) {
    this->SetMenuItemInvalid( m_curIdx );
    m_curIdx = ( m_curIdx + m_pMenuData->itemNum - 14 ) % m_pMenuData->itemNum;
    this->SetMenuItemValid( m_curIdx );
  }
}


// j[ڂȈԂɂ
void Menu::SetMenuItemValid( u8 menuItemIdx )
{
  u32 pane_id = m_pMenuData->items[ menuItemIdx ].paneID;
  gfl::grp::g2d::LytTextBox* textBox = m_LytWk->GetTextBoxPane( pane_id );
  textBox->SetScale( gfl::math::VEC2( 1.2f, 1.2f ) );
}


// j[ڂȈԂɂ
void Menu::SetMenuItemInvalid( u8 menuItemIdx )
{
  u32 pane_id = m_pMenuData->items[ menuItemIdx ].paneID;
  gfl::grp::g2d::LytTextBox* textBox = m_LytWk->GetTextBoxPane( pane_id );
  textBox->SetScale( gfl::math::VEC2( 1.0f, 1.0f ) );
}



//-----------------------------------------------------------------------------
// `
//-----------------------------------------------------------------------------
void Menu::DrawTest( void )
{
  m_LytSys->UpdateAll();


  //m_graphics_system->StartRendering();

  gfl::grp::RenderTarget* upperFrameBuffer = m_graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
  gfl::grp::RenderTarget* rightFrameBuffer = m_graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
  gfl::grp::RenderTarget* lowerFrameBuffer = m_graphics_system->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

  m_LytSys->DrawAll( m_graphics_system, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
  m_LytSys->DrawAll( m_graphics_system, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

  //m_graphics_system->EndRendering();


  // `XV
  //m_graphics_system->SwapBuffer();
  //nngxWaitVSync(NN_GX_DISPLAY_BOTH);

  // obt@Xbv
  //m_graphics_system->VSyncAfter();
}



//-----------------------------------------------------------------------------
// Ij[ڂID擾
//-----------------------------------------------------------------------------
int Menu::GetSelectedItemID( void ) const
{
  GFL_ASSERT( m_selectFlag ); // Iς݂łȂƃ_

  return m_pMenuData->items[ m_selectedIdx ].itemID;
}


//------------------------------------------------------------------------------
// Iǂ𒲂ׂ
//------------------------------------------------------------------------------
bool Menu::IsSelected( void ) const
{
  return m_selectFlag;
}


//------------------------------------------------------------------------------
// LZǂ𒲂ׂ
//------------------------------------------------------------------------------
bool Menu::IsCanceled( void ) const
{
  return m_cancelFlag;
}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
