#ifndef __TEST_OHNO_BASE_H__
#define __TEST_OHNO_BASE_H__
//========================================================================================
/**
 * @file   test_obata_Base.h
 * @brief  eXg̃x[X
 * @author obata_toshihiro
 * @date   2010.12.08
 */
//========================================================================================
#include <gflib.h>


GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)


class Base
{
public:
  //--------------------------------------------------------------------------------
  /**
   * @brief RXgN^
   * @param heap              eXgŎgpq[v
   * @param device_heap       eXgŎgpfoCXq[v
   * @param heap_allocator    eXgŎgpAP[^
   * @param device_allocator  eXgŎgpfoCXAP[^
   * @param graphics_system   fXgŎgpOtBbNXVXe
   * @param ui_device_manager eXgŎgpUIfoCX
   */
  //--------------------------------------------------------------------------------
  Base(
    gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
    gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
    gfl::grp::GraphicsSystem* graphics_system = NULL,
    gfl::ui::DeviceManager* ui_device_manager = NULL );

  //--------------------------------------------------------------------------------
  /**
   * @brief fXgN^
   */
  //--------------------------------------------------------------------------------
  virtual ~Base( void );

  //--------------------------------------------------------------------------------
  /**
   * @brief XV
   */
  //--------------------------------------------------------------------------------
  void Main( void );

  //--------------------------------------------------------------------------------
  /**
   * @brief `揈
   */
  //--------------------------------------------------------------------------------
  void Draw( void );

  //--------------------------------------------------------------------------------
  /**
   * @breif Iǂ𒲂ׂ
   */
  //--------------------------------------------------------------------------------
  bool IsEnd( void ) const;



protected:

  bool m_end_flag; // Iǂ

  gfl::heap::HeapBase* m_heap;
  gfl::heap::HeapBase* m_device_heap;
  gfl::heap::NwAllocator* m_heap_allocator;
  gfl::heap::NwAllocator* m_device_allocator;
  gfl::ui::DeviceManager* m_ui_device_manager;
  gfl::ui::VectorDevice* m_crosskey;
  gfl::ui::VectorDevice* m_stick;
  gfl::ui::Button* m_button;
  gfl::ui::TouchPanel* m_touchpanel;
  gfl::grp::GraphicsSystem* m_graphics_system;


  // eXgI
  void End( void );



private:

  // eXg̃C
  virtual void UpdateTest( void ) = 0;

  // eXg̕`揈
  virtual void DrawTest( void ){}
};


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)

#endif // __TEST_OHNO_BASE_H__
