//========================================================================================
/**
 * @file   test_ohno_Base.cpp
 * @brief  eXg̃x[X
 * @author k.ohno
 * @date   2010.12.08
 */
//========================================================================================
#include <gflib.h>
#include <system/main.h>
#include "test_ohno_Base.h"


GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)


//------------------------------------------------------------------------------------
// RXgN^
//------------------------------------------------------------------------------------
Base::Base(
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system,
  gfl::ui::DeviceManager* ui_device_manager ) :
m_end_flag( false ),
m_heap( heap ),
m_device_heap( device_heap ),
m_heap_allocator( heap_allocator ),
m_device_allocator( device_allcator ),
m_ui_device_manager( ui_device_manager ),
m_crosskey( NULL ),
m_stick( NULL ),
m_button( NULL ),
m_touchpanel( NULL ),
m_graphics_system( graphics_system )
{
  m_button = m_ui_device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
  m_crosskey = m_ui_device_manager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
  m_stick = m_ui_device_manager->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
  m_touchpanel = m_ui_device_manager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );
}



//------------------------------------------------------------------------------------
// fXgN^
//------------------------------------------------------------------------------------
Base::~Base( void )
{
}



//------------------------------------------------------------------------------------
// XV
//------------------------------------------------------------------------------------
void Base::Main( void )
{
  this->UpdateTest();
}

//------------------------------------------------------------------------------------
// `揈
//------------------------------------------------------------------------------------
void Base::Draw( void )
{
  this->DrawTest();
}



//------------------------------------------------------------------------------------
// eXgIǂ𒲂ׂ
//------------------------------------------------------------------------------------
bool Base::IsEnd( void ) const
{
  return m_end_flag;
}

//------------------------------------------------------------------------------------
// eXgI
//------------------------------------------------------------------------------------
void Base::End( void )
{
  m_end_flag = true;
}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
