//======================================================================
/**
 * @file	  CecSystem.cpp
 * @brief	  ႢʐM
 * @author	k.ohno
 * @data	  2011/07/16
 */
//======================================================================

#include <gflib.h>
#include "CecAllocator.h"
#include "netapp/cec/CecSystem.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(cec)


//MessageBox̐ݒl
static u32     TITLEID = nn::cec::MakeCecTitleId(0x00126);     // ꂿʐMID(Œl)
static u32     PRIVATEID = 0x123;   // Card ŗLID (CardƁAZ[uf[^ƂɈႤl)
static char    HMACKEY[] = "12345678901234567890123456789012";
#define INBOX_MAXNUM            25
#define OUTBOX_MAXNUM            1


#define BODYDATA L"DUMMYDATA"
#define TITLEDATA L"DUMMYTITLE"



nn::Result CecSystem::SaveSendMessage(nn::cec::MessageBox* pCecMessBox)
{
    // BoxJĂ݂
    nn::Result result = pCecMessBox->OpenMessageBox(TITLEID, PRIVATEID);
    if(result.IsFailure()) return result;

    // MbZ[Wobt@ɕۑ
    mBoxBuffer.outMessNum= pCecMessBox->GetBoxMessageNum(nn::cec::CEC_BOXTYPE_OUTBOX);
    for(int i=0; i<mBoxBuffer.outMessNum; i++)
    {
        u8 *buf;
        nn::cec::MessageId messId;
        nn::cec::Message cecMess;

        // bZ[WID̎擾
        pCecMessBox->GetMessageId(&messId, nn::cec::CEC_BOXTYPE_OUTBOX, i);

        // TCY擾
        size_t messSize = pCecMessBox->GetMessageSize(nn::cec::CEC_BOXTYPE_OUTBOX, i);

        // ǂݏöׂ̃obt@m
        buf = reinterpret_cast<u8*>(mpCecAllocator->Allocate(messSize));
        if(buf==NULL) NN_LOG("Malloc Error\n");

        // Message ̓ǂݏo
        result = pCecMessBox->ReadMessage(cecMess, buf, messSize, nn::cec::CEC_BOXTYPE_OUTBOX, messId);
        if(result.IsFailure())
        {
            NN_LOG("### [Message %d]ReadMessage Error\n", i-1);
            mpCecAllocator->Free(buf);
            continue;
        }

        //InfoText
        const wchar_t*    pInfoText;
        size_t      infoTextLen;
        if(cecMess.GetInfoText(&pInfoText, &infoTextLen).IsSuccess())
        {
            std::memset(mBoxBuffer.outMessData[i].title,0,TITLE_LENGTH*sizeof(wchar_t));
            std::memcpy(&mBoxBuffer.outMessData[i].title, pInfoText, infoTextLen);
        }

        //body
        void*       pBody;
        size_t      bodyLen;
        cecMess.GetMessageBodyPointer(&pBody,&bodyLen);
        std::memcpy(&mBoxBuffer.outMessData[i].body, pBody, bodyLen);

        //CreateDate
        mBoxBuffer.outMessData[i].date = cecMess.GetCreateDate();

        mpCecAllocator->Free(buf);
    }
    pCecMessBox->CloseMessageBox();
    return result;
}


nn::Result CecSystem::CreateBox(nn::cec::MessageBox* pCecMessBox)
{
    nn::Result  result;
    /* --------------------------------------------------------
      Box
      --------------------------------------------------------*/
    // BoxJĂ݂
    result = pCecMessBox->OpenMessageBox(TITLEID, PRIVATEID);
    if(result.IsFailure())
    {
        if(result != nn::cec::MakeResultNoData())return result;

        // BoxNameZbg
        wchar_t boxName[64] = L"CEC_DEMO_BOX"; //Box Name

        // iconZbg
        u8 boxIcon[48*48*2];
        std::memset(boxIcon, 0x55, sizeof(boxIcon));//Kɖ߂

        //Box
        result = pCecMessBox->CreateMessageBox(
                                    TITLEID,\
                                    PRIVATEID,\
                                    HMACKEY,\
                                    boxIcon,\
                                    sizeof(boxIcon),\
                                    boxName,\
                                    sizeof(boxName),\
                                    CEC_INBOX_SIZE_DEFAULT,\
                                    CEC_OUTBOX_SIZE_DEFAULT,\
                                    INBOX_MAXNUM,\
                                    OUTBOX_MAXNUM,\
                                    CEC_MESSSIZEMAX_DEFAULT);
    }
    pCecMessBox->CloseMessageBox();
    return result;
}

void CecSystem::DeleteBox(nn::cec::MessageBox* pCecMessBox)
{
  // BoxJĂ݂
  if(pCecMessBox->OpenMessageBox(TITLEID, PRIVATEID).IsSuccess()) {
    pCecMessBox->DeleteMessageBox();
  }
  else{
    pCecMessBox->DeleteMessageBox(TITLEID);
  }
}

nn::Result CecSystem::SetSendMessage(nn::cec::MessageBox* pCecMessBox)
{
    nn::Result         result;
    nn::cec::Message   newMess;
    u8                 icon[40*40*2] = {0};
    nn::cec::MessageId mssid;

    // BoxJĂ݂
    result = pCecMessBox->OpenMessageBox(TITLEID, PRIVATEID);
    if(result.IsFailure()) return result;

    /* --------------------------------------------------------
      Message
      --------------------------------------------------------*/
    newMess.NewMessage( TITLEID,                                 // CecTitleId
                        0,                                       // Group ID 
                        nn::cec::MESSAGE_TYPEFLAG_NON_FRIEND\
                        |nn::cec::MESSAGE_TYPEFLAG_FRIEND,       // Message Type Flag
                        nn::cec::CEC_SENDMODE_SENDRECV,          // Send Mode
                        nn::cec::MESSAGE_SENDCOUNT_ONCE,         // Send Count
                        nn::cec::MESSAGE_PROPAGATIONCOUNT_ONCE   // Propagation Count
                        );

    // f[^{Zbg
    newMess.SetMessageBody(BODYDATA, sizeof(BODYDATA));
    
    // Icon Zbg
    std::memset(icon, 0x55, sizeof(icon));//Kɖ߂
    newMess.SetIcon(icon, sizeof(icon));

    // InfoTextZbg
    newMess.SetInfoText(TITLEDATA, sizeof(TITLEDATA));

    // Message 𑗐MBOXɕۑ
    result = pCecMessBox->WriteMessage(newMess, nn::cec::CEC_BOXTYPE_OUTBOX, mssid);
    if(result.IsFailure())
    {
        //{bNX̃bZ[WőlzĂ
        if(result.GetDescription() == nn::cec::DESCRIPTION_BOXMESSNUM_FULL)
        {
            //MbZ[Wׂč폜
            pCecMessBox->DeleteAllMessages(nn::cec::CEC_BOXTYPE_OUTBOX);
        }
        pCecMessBox->CloseMessageBox();
        return result;
    }
    pCecMessBox->CloseMessageBox();

    //MbZ[Wobt@ɕۑ
    return SaveSendMessage(pCecMessBox);
}



bool CecSystem::Initialize(gfl::heap::HeapBase* pHeapBase)
{
  nn::Result         result;

  mpHeapBase = pHeapBase;
  mpCecAllocator = GFL_NEW(pHeapBase) CecAllocator;
  mpCecAllocator->Initialize(pHeapBase);
  
  NN_LOG("Cec: nn::cec::Initialize()\n");
  result = nn::cec::Initialize(*mpCecAllocator);
  NN_UTIL_PANIC_IF_FAILED(result);

  mpCecMessBox = GFL_NEW(pHeapBase) nn::cec::MessageBox;

  /*
     ꂿʐMŁAxꂿʐMsƍĂтꂿʐMsɂ́A
      4  (ő 8 ԁj܂BZԊԊuōēxʐMɂ́AStartScanning(true)
     LɂKv܂B{fvOɑg܂ꂽStartScanning(true)Lɂɂ́A
     Developmentrhsst@C𗘗pĂB
   */
  nn::cec::CecControl::StartScanning(true);

  //{bNXJĂ݂ā@邩ǂmF
  result = mpCecMessBox->OpenMessageBox(TITLEID, PRIVATEID);
  if(result.IsFailure()){
    return false;
  }
  return true;
}


bool CecSystem::CreateBox(void)
{
  nn::Result  result;

  result = CreateBox(mpCecMessBox);
  
  if(result.IsSuccess()){
    return true;
  }
  return false;
}



//M钆g
bool CecSystem::CreateMessage(void)
{
  nn::Result  result;
  if(mpCecMessBox->GetBoxMessageNum(nn::cec::CEC_BOXTYPE_OUTBOX)==0){
    result = SetSendMessage(mpCecMessBox);
  }
  else{
    //gꍇ
    result = SaveSendMessage(mpCecMessBox);
  }
  if(result.IsSuccess()){
    return true;
  }
  return false;
}


gfl::heap::HeapBase* CecSystem::Finalize(void)
{
  nn::cec::Finalize();
  GFL_DELETE(mpCecAllocator);
  GFL_DELETE(mpCecMessBox);
  return mpHeapBase;
}

GFL_NAMESPACE_END(cec)
GFL_NAMESPACE_END(netapp)

