#ifndef __CECALLOCATOR_H__
#define __CECALLOCATOR_H__
//======================================================================
/**
 * @file	  CecAllocator.h
 * @brief	  ႢʐMpAP[^[
 * @author	k.ohno
 * @data	  2011/07/16
 */
//======================================================================

#include <gflib.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(cec)


//------------------------------------------------------------
// CEC CugpAP[^
class CecAllocator : public nn::fnd::IAllocator
{
private:
  gfl::heap::HeapBase* mpHeapBase;
  
public:
    CecAllocator(){mpHeapBase = NULL;};
    virtual ~CecAllocator(){};

  void Initialize(gfl::heap::HeapBase* pHeapBase)
    {
      GFL_ASSERT_STOP(mpHeapBase==NULL);
      mpHeapBase = pHeapBase;
    }
    
  /**
        @brief eNX̏z֐̎łB֐`͐eNX̒`QƂĂB
   */
  virtual void* Allocate(size_t size, s32 alignment = 4)
    {
      GFL_ASSERT_STOP(mpHeapBase);
      return GflHeapAllocMemoryAlign(mpHeapBase, size, alignment);
    }

    /*!
        @brief eNX̏z֐̎łB֐`͐eNX̒`QƂĂB
    */
    virtual void Free(void* p)
    {
        GflHeapFreeMemory(p);
    }
    
};

GFL_NAMESPACE_END(cec)
GFL_NAMESPACE_END(netapp)
#endif //__CECALLOCATOR_H__
