
#ifndef __CECSYSTEM_H__
#define __CECSYSTEM_H__
//======================================================================
/**
 * @file	  CecSystem.h
 * @brief	  ႢʐMpAP[^[
 * @author	k.ohno
 * @data	  2011/07/16
 */
//======================================================================

#include <gflib.h>
#include <nn/cec.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(cec)

#define INBOX_MAXNUM            25
#define OUTBOX_MAXNUM            1
#define TITLE_LENGTH            26
#define BODY_LENGTH           1024

class CecAllocator;

//------------------------------------------------------------
// CEC CugpAP[^
class CecSystem
{

  struct Data
    {
      nn::fnd::DateTimeParameters date;
      wchar_t   title[TITLE_LENGTH];
      wchar_t   body[BODY_LENGTH];
    };

  struct BoxBuffer
    {
      s32                 inMessNum;
      u32                 outMessNum;
      struct Data         inMessData[INBOX_MAXNUM];
      struct Data         outMessData[OUTBOX_MAXNUM];
      s32                 sentCount;
    };



private:
  gfl::heap::HeapBase* mpHeapBase;
  nn::cec::MessageBox* mpCecMessBox;
  CecAllocator* mpCecAllocator;
  BoxBuffer mBoxBuffer;

  nn::Result SaveSendMessage(nn::cec::MessageBox* pCecMessBox);
  nn::Result CreateBox(nn::cec::MessageBox* pCecMessBox);
  void DeleteBox(nn::cec::MessageBox* pCecMessBox);
  nn::Result SetSendMessage(nn::cec::MessageBox* pCecMessBox);

  
public:
  bool Initialize(gfl::heap::HeapBase* pHeapBase);
  bool CreateBox(void);
  bool CreateMessage(void);
  gfl::heap::HeapBase* Finalize(void);

  


};

GFL_NAMESPACE_END(cec)
GFL_NAMESPACE_END(netapp)
#endif //__CECSYSTEM_H__
