//=============================================================================
/**
 *
 *	@file		ZoneData.cpp
 *	@brief  ][f[^
 *	@author hosaka genya
 *	@data		2011.07.15
 *
 */
//=============================================================================
#include "field/ZoneData.h"

#include "arc/zonedata.gaix"

GFL_NAMESPACE_BEGIN( field )

//-----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
ZoneDataLoader::ZoneDataLoader( gfl::heap::HeapBase* heap )
{
  m_Heap  = heap;
//  m_State = ST_SETUP_FAST_MODE;
  
  m_ArcFile = GFL_NEW( heap ) gfl::fs::ArcFile( ARCID_ZONEDATA );
  m_ArcFile->StartSetupForFastMode( heap );
}

bool ZoneDataLoader::Load( ZoneID zone_id )
{
  if( m_ArcFile->IsSetupForFastModeFinished() == false )
  {
    return false;
  }
  
  gfl::heap::HeapBase* heap = m_Heap;
  const u32 dat = GARC_zonedata_zonetable_BIN;
  u32 size = m_ArcFile->GetDataSize( dat );
  //@todo Ƃ肠ǂݍ
  m_ArcFile->LoadDataPiece( dat, zone_id * sizeof( ZONEDATA ), sizeof( ZONEDATA ), &m_ZoneData );
//  m_ArcBuf = GflHeapAllocMemoryAlign( heap, size, 128 );
//  m_ArcFile->StartAsyncRead( heap, dat, m_ArcBuf, MAIN_THREAD_PRIORITY+1 );

  return true;
}

bool ZoneDataLoader::IsLoaded( void ) const 
{ 
  if( m_ArcFile->IsSetupForFastModeFinished() )
  {
    return ( m_ArcFile->CheckAsyncRead() == false );
  }

  return false;
  
//  return ( m_State == ST_NORMAL );
}


GFL_NAMESPACE_END( field )
