//================================================================================
/**
 * @file   test_obata_DebugPokeMake.cpp
 * @brief  ꎞIȃeXgꏊ
 * @author obata_toshihiro
 * @date   2010.12.15
 */ 
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include <debug/DebugPokeMake.h>
#include "test_obata_DebugPokeMake.h"


namespace test {
  namespace obata {



    //-----------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------
    DebugPokeMakeTest::DebugPokeMakeTest( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
        gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
      Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager ),
      m_pokepara( NULL )
    { 
      pml::bridge::CtrAllocator allocator( heap );
      m_pokepara = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_BATAHURII, 5, 0xff );
    }


    //-----------------------------------------------------------------------------
    // fXgN^
    //-----------------------------------------------------------------------------
    DebugPokeMakeTest::~DebugPokeMakeTest()
    {
      pml::System::PokeParaFactory()->DeletePokemonParam( m_pokepara );
    }


    //-----------------------------------------------------------------------------
    // C
    //-----------------------------------------------------------------------------
    void DebugPokeMakeTest::UpdateTest( void )
    {
      if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
        gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
        gamesystem::GameProcManager* proc_manager = game_manager->GetProcManager(); 
        XY_PROC_CALL( proc_manager, debug::DebugPokeMake );
        pCC->SetMakeTarget( m_pokepara );
      }

      // START {^ŏI
      if( m_button->IsTrigger( gfl::ui::BUTTON_START ) ) {
        this->End();
      }
    } 



    //-----------------------------------------------------------------------------
    // `揈
    //-----------------------------------------------------------------------------
    void DebugPokeMakeTest::DrawTest( void )
    {
    }


  } // namespace obata 
} // namespace test
