//=================================================================================================
/**
 * @file DebugPokeMakePage1.cpp
 * @brief fobO|P쐬
 * @author obata_toshihiro
 * @date 2011.07.11
 */
//=================================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>
#include <print/printsys.h>
#include <item/item.h>
#include <app/tool/app_tool_ButtonManager.h>
#include "DebugPokeMakePage1.h"
#include <arc/arc_def.h>
#include <arc/debug_poke_make.gaix>
#include "debug_poke_make.h"
#include "debug_poke_make_pane.h"


namespace debug {



  // Aj[Vf[^
  const gfl::grp::g2d::LytArcIndex DebugPokeMakePage1::ANIMATION_DATA_TABLE[ DebugPokeMakePage1::ANIMATION_DATA_NUM ] = 
  {
    /* ANIMATION_DATA_ARROW_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_ARROW_HOLD_BCLAN,
    /* ANIMATION_DATA_ARROW_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_ARROW_RELEASE_BCLAN,
    /* ANIMATION_DATA_ARROW_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_ARROW_SELECT_BCLAN,
    /* ANIMATION_DATA_SWITCH_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_BUTTON_HOLD_BCLAN,
    /* ANIMATION_DATA_SWITCH_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_BUTTON_RELEASE_BCLAN,
    /* ANIMATION_DATA_SWITCH_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_BUTTON_SELECT_BCLAN,
    /* ANIMATION_DATA_STRBOX_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_STRING_HOLD_BCLAN,
    /* ANIMATION_DATA_STRBOX_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_STRING_RELEASE_BCLAN,
    /* ANIMATION_DATA_STRBOX_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_STRING_SELECT_BCLAN, 
    /* ANIMATION_DATA_NUMBOX_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUMBER_HOLD_BCLAN,
    /* ANIMATION_DATA_NUMBOX_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUMBER_RELEASE_BCLAN,
    /* ANIMATION_DATA_NUMBOX_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUMBER_SELECT_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_1 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE1_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_2 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE2_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_3 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE3_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_4 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE4_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_5 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE5_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_6 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE6_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_7 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE7_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_FORMNO */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_FORMNO_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_LEVEL */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_LEVEL_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_HP_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_HP_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_HP_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_HP_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_ATK_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_ATK_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_ATK_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_ATK_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_DEF_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_DEF_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_DEF_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_DEF_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_AGI_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_AGI_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_AGI_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_AGI_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPATK_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPATK_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPATK_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPATK_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPDEF_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPDEF_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPDEF_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPDEF_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA1_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA1_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA1_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA1_PP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA2_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA2_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA2_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA2_PP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA3_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA3_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA3_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA3_PP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA4_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA4_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA4_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA4_PP_BCLAN,
  };



  // Z̃yC
  const gfl::grp::g2d::LytPaneIndex DebugPokeMakePage1::PANE_INDEX_OF_WAZA_NAME[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_NAME,
    PANENAME_PAGE1_PANE_WAZA2_NAME,
    PANENAME_PAGE1_PANE_WAZA3_NAME,
    PANENAME_PAGE1_PANE_WAZA4_NAME,
  };

  //u|CgAbvvgp񐔂̃yC
  const gfl::grp::g2d::LytPaneIndex DebugPokeMakePage1::PANE_INDEX_OF_WAZA_UP_VAL[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_UP_VAL,
    PANENAME_PAGE1_PANE_WAZA2_UP_VAL,
    PANENAME_PAGE1_PANE_WAZA3_UP_VAL,
    PANENAME_PAGE1_PANE_WAZA4_UP_VAL,
  };

  // PPݒl̃yC
  const gfl::grp::g2d::LytPaneIndex DebugPokeMakePage1::PANE_INDEX_OF_WAZA_PP_VAL[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_PP_VAL,
    PANENAME_PAGE1_PANE_WAZA2_PP_VAL,
    PANENAME_PAGE1_PANE_WAZA3_PP_VAL,
    PANENAME_PAGE1_PANE_WAZA4_PP_VAL,
  };

  // PPől̃yC
  const gfl::grp::g2d::LytPaneIndex DebugPokeMakePage1::PANE_INDEX_OF_WAZA_PP_MAX[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_PP_MAX,
    PANENAME_PAGE1_PANE_WAZA2_PP_MAX,
    PANENAME_PAGE1_PANE_WAZA3_PP_MAX,
    PANENAME_PAGE1_PANE_WAZA4_PP_MAX,
  };


  // ACRƂ̐ݒ
  const DebugPokeMakePage1::ButtonDesc DebugPokeMakePage1::BUTTON_DESC_FOR_ARROW[ DebugPokeMakePage1::ARROW_NUM ] = 
  {
    /* ARROW_MONSNO_L */ 
    { 
      PANENAME_PAGE1_PANE_MONS_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_MONSNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_MONSNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_MONSNO_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_MONSNO_R */ 
    { 
      PANENAME_PAGE1_PANE_MONS_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_MONSNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_MONSNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_MONSNO_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_FORMNO_L */ 
    { 
      PANENAME_PAGE1_PANE_FORM_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_FORMNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_FORMNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_FORMNO_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_FORMNO_R */ 
    { 
      PANENAME_PAGE1_PANE_FORM_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_FORMNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_FORMNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_FORMNO_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_SEIKAKU_L */ 
    { 
      PANENAME_PAGE1_PANE_SEIKAKU_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_SEIKAKU_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_SEIKAKU_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_SEIKAKU_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_SEIKAKU_R */ 
    { 
      PANENAME_PAGE1_PANE_SEIKAKU_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_SEIKAKU_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_SEIKAKU_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_SEIKAKU_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_ITEM_L */ 
    { 
      PANENAME_PAGE1_PANE_ITEM_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_ITEM_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_ITEM_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_ITEM_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_ITEM_R */ 
    { 
      PANENAME_PAGE1_PANE_ITEM_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_ITEM_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_ITEM_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_ITEM_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_TOKUSEI_L */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_TOKUSEI_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_TOKUSEI_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_TOKUSEI_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_TOKUSEI_R */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_TOKUSEI_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_TOKUSEI_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_TOKUSEI_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA1_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA1_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA1_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA1_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA1_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA1_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA1_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA1_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA2_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA2_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA2_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA2_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA2_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA2_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA2_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA2_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA3_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA3_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA3_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA3_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA3_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA3_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA3_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA3_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA4_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA4_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA4_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA4_L ),
      DebugPokeMakePage1::OnArrowSelected,
    },
    /* ARROW_WAZA4_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA4_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA4_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA4_R ),
      DebugPokeMakePage1::OnArrowSelected,
    },
  };


  // ؂ւXCb`Ƃ̐ݒ
  const DebugPokeMakePage1::ButtonDesc DebugPokeMakePage1::BUTTON_DESC_FOR_SWITCH[ DebugPokeMakePage1::SWITCH_NUM ] = 
  {
    /* SWITCH_SEX */ 
    { 
      PANENAME_PAGE1_PANE_SEX_BACK,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_SEX ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_SEX ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_SEX ),
      DebugPokeMakePage1::OnSwitchSelected,
    },
    /* SWITCH_TOKUSEI1 */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BTN1,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_TOKUSEI1 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_TOKUSEI1 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_TOKUSEI1 ),
      DebugPokeMakePage1::OnSwitchSelected,
    },
    /* SWITCH_TOKUSEI2 */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BTN2,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_TOKUSEI2 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_TOKUSEI2 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_TOKUSEI2 ),
      DebugPokeMakePage1::OnSwitchSelected,
    },
    /* SWITCH_TOKUSEI3 */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BTN3,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_TOKUSEI3 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_TOKUSEI3 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_TOKUSEI3 ),
      DebugPokeMakePage1::OnSwitchSelected,
    },
    /* SWITCH_DEFAULT_WAZA */ 
    { 
      PANENAME_PAGE1_PANE_WAZA_DEF_BTN,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_DEFAULT_WAZA ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_DEFAULT_WAZA ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_DEFAULT_WAZA ),
      DebugPokeMakePage1::OnSwitchSelected,
    },
    /* SWITCH_HATAKU */ 
    { 
      PANENAME_PAGE1_PANE_WAZA_HATAKU_BTN,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_HATAKU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_HATAKU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_HATAKU ),
      DebugPokeMakePage1::OnSwitchSelected,
    },
    /* SWITCH_HANERU */ 
    { 
      PANENAME_PAGE1_PANE_WAZA_HANERU_BTN,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_HANERU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_HANERU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_HANERU ),
      DebugPokeMakePage1::OnSwitchSelected,
    },
  };


  // {bNXƂ̐ݒ
  const DebugPokeMakePage1::ButtonDesc DebugPokeMakePage1::BUTTON_DESC_FOR_STRBOX[ DebugPokeMakePage1::STRBOX_NUM ] = 
  {
    /* STRBOX_MONSNAME */ 
    { 
      PANENAME_PAGE1_PANE_MONS_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_MONSNAME ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_MONSNAME ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_MONSNAME ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
    /* STRBOX_SEIKAKU */ 
    { 
      PANENAME_PAGE1_PANE_SEIKAKU_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_SEIKAKU ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_SEIKAKU ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_SEIKAKU ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
    /* STRBOX_ITEM */ 
    { 
      PANENAME_PAGE1_PANE_ITEM_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_ITEM ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_ITEM ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_ITEM ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
    /* STRBOX_TOKUSEI */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_TOKUSEI ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_TOKUSEI ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_TOKUSEI ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
    /* STRBOX_WAZA1 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA1 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA1 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA1 ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
    /* STRBOX_WAZA2 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA2 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA2 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA2 ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
    /* STRBOX_WAZA3 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA3 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA3 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA3 ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
    /* STRBOX_WAZA4 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA4 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA4 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA4 ),
      DebugPokeMakePage1::OnStrBoxSelected,
    },
  };


  // l{bNXƂ̐ݒ
  const DebugPokeMakePage1::ButtonDesc DebugPokeMakePage1::BUTTON_DESC_FOR_NUMBOX[ DebugPokeMakePage1::NUMBOX_NUM ] = 
  {
    /* NUMBOX_FORMNO */ 
    { 
      PANENAME_PAGE1_PANE_FORM_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_FORMNO ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_FORMNO ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_FORMNO ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_FORMNO,
    },
    /* NUMBOX_LEVEL */ 
    { 
      PANENAME_PAGE1_PANE_LEVEL_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_LEVEL ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_LEVEL ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_LEVEL ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_LEVEL,
    },
    /* NUMBOX_EXP */ 
    { 
      PANENAME_PAGE1_PANE_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_EXP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_EXP,
    },
    /* NUMBOX_HP_RND */ 
    { 
      PANENAME_PAGE1_PANE_HP_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_HP_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_HP_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_HP_RND ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_HP_RND,
    },
    /* NUMBOX_HP_EXP */ 
    { 
      PANENAME_PAGE1_PANE_HP_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_HP_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_HP_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_HP_EXP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_HP_EXP,
    },
    /* NUMBOX_ATK_RND */ 
    { 
      PANENAME_PAGE1_PANE_ATK_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_ATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_ATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_ATK_RND ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_ATK_RND,
    },
    /* NUMBOX_ATK_EXP */ 
    { 
      PANENAME_PAGE1_PANE_ATK_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_ATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_ATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_ATK_EXP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_ATK_EXP,
    },
    /* NUMBOX_DEF_RND */ 
    { 
      PANENAME_PAGE1_PANE_DEF_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_DEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_DEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_DEF_RND ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_DEF_RND,
    },
    /* NUMBOX_DEF_EXP */ 
    { 
      PANENAME_PAGE1_PANE_DEF_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_DEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_DEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_DEF_EXP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_DEF_EXP,
    },
    /* NUMBOX_AGI_RND */ 
    { 
      PANENAME_PAGE1_PANE_AGI_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_AGI_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_AGI_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_AGI_RND ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_AGI_RND,
    },
    /* NUMBOX_AGI_EXP */ 
    { 
      PANENAME_PAGE1_PANE_AGI_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_AGI_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_AGI_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_AGI_EXP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_AGI_EXP,
    },
    /* NUMBOX_SPATK_RND */ 
    { 
      PANENAME_PAGE1_PANE_SPATK_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPATK_RND ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPATK_RND,
    },
    /* NUMBOX_SPATK_EXP */ 
    { 
      PANENAME_PAGE1_PANE_SPATK_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPATK_EXP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPATK_EXP,
    },
    /* NUMBOX_SPDEF_RND */ 
    { 
      PANENAME_PAGE1_PANE_SPDEF_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPDEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPDEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPDEF_RND ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPDEF_RND,
    },
    /* NUMBOX_SPDEF_EXP */ 
    { 
      PANENAME_PAGE1_PANE_SPDEF_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPDEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPDEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPDEF_EXP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPDEF_EXP,
    },
    /* NUMBOX_WAZA1_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA1_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA1_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA1_UP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA1_UP,
    },
    /* NUMBOX_WAZA1_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA1_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA1_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA1_PP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA1_PP,
    },
    /* NUMBOX_WAZA2_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA2_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA2_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA2_UP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA2_UP,
    },
    /* NUMBOX_WAZA2_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA2_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA2_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA2_PP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA2_PP,
    },
    /* NUMBOX_WAZA3_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA3_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA3_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA3_UP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA3_UP,
    },
    /* NUMBOX_WAZA3_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA3_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA3_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA3_PP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA3_PP,
    },
    /* NUMBOX_WAZA4_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA4_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA4_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA4_UP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA4_UP,
    },
    /* NUMBOX_WAZA4_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA4_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA4_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA4_PP ),
      DebugPokeMakePage1::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA4_PP,
    },
  };







  // 󂪑Iꂽۂ̃R[obN֐
  void DebugPokeMakePage1::OnArrowSelected( app::tool::ButtonManager::ButtonId arrow_index, void* work )
  {
    DebugPokeMakePage1* debug_poke_make = reinterpret_cast<DebugPokeMakePage1*>( work );
    pml::pokepara::PokemonParam* clone_param = DebugPokeMake::ClonePokemonParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( arrow_index )
    {
    case ARROW_MONSNO_L:
      {
        MonsNo old_monsno = clone_param->GetMonsNo();
        MonsNo new_monsno = static_cast<MonsNo>( ( old_monsno + MONSNO_END ) % ( MONSNO_END + 1 ) );
        clone_param->ChangeMonsNo( new_monsno, 0 );  // tH0ɂ
        DebugPokeMakePage1::UpdateAllOnDisplay( clone_param );
      }
      break;

    case ARROW_MONSNO_R:
      {
        MonsNo old_monsno = clone_param->GetMonsNo();
        MonsNo new_monsno = static_cast<MonsNo>( ( old_monsno + 1 ) % ( MONSNO_END + 1 ) );
        clone_param->ChangeMonsNo( new_monsno, 0 );  // tH0ɂ
        DebugPokeMakePage1::UpdateAllOnDisplay( clone_param );
      }
      break;

    case ARROW_FORMNO_L:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo old_formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, old_formno );
        u32 form_num = personal_system->GetPersonalParam( pml::personal::PARAM_ID_form_max );
        if( 1 < form_num ) {
          pml::FormNo new_formno = ( old_formno + form_num - 1 ) % form_num;
          clone_param->ChangeFormNo( new_formno );
          DebugPokeMakePage1::UpdateFormNoOnDisplay( clone_param );
        }
      }
      break;

    case ARROW_FORMNO_R:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo old_formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, old_formno );
        u32 form_num = personal_system->GetPersonalParam( pml::personal::PARAM_ID_form_max );
        if( 1 < form_num ) {
          pml::FormNo new_formno = ( old_formno + 1 ) % form_num;
          clone_param->ChangeFormNo( new_formno );
          DebugPokeMakePage1::UpdateFormNoOnDisplay( clone_param );
        }
      }
      break;

    case ARROW_SEIKAKU_L:
      {
        pml::pokepara::Seikaku old_seikaku = clone_param->GetSeikaku();
        u32 new_seikaku_value = ( old_seikaku + pml::pokepara::SEIKAKU_MAX - 1 ) % pml::pokepara::SEIKAKU_MAX;
        pml::pokepara::Seikaku new_seikaku = static_cast<pml::pokepara::Seikaku>( new_seikaku_value );
        clone_param->ChangeSeikaku( new_seikaku );
        DebugPokeMakePage1::UpdateSeikakuOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateHpOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateAtkOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateDefOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateAgiOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateSpatkOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateSpdefOnDisplay( clone_param );
      }
      break;

    case ARROW_SEIKAKU_R:
      {
        pml::pokepara::Seikaku old_seikaku = clone_param->GetSeikaku();
        u32 new_seikaku_value = ( old_seikaku + 1 ) % pml::pokepara::SEIKAKU_MAX;
        pml::pokepara::Seikaku new_seikaku = static_cast<pml::pokepara::Seikaku>( new_seikaku_value );
        clone_param->ChangeSeikaku( new_seikaku );
        DebugPokeMakePage1::UpdateSeikakuOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateHpOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateAtkOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateDefOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateAgiOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateSpatkOnDisplay( clone_param );
        DebugPokeMakePage1::UpdateSpdefOnDisplay( clone_param );
      }
      break;

    case ARROW_ITEM_L:
      {
        u32 old_itemno = clone_param->GetParam( pml::pokepara::PARAM_ID_item );
        u32 new_itemno = ( old_itemno + ITEM_DATA_MAX ) % ( ITEM_DATA_MAX + 1 );
        clone_param->SetParam( pml::pokepara::PARAM_ID_item, new_itemno );
        DebugPokeMakePage1::UpdateItemOnDisplay( clone_param );
      }
      break;

    case ARROW_ITEM_R:
      {
        u32 old_itemno = clone_param->GetParam( pml::pokepara::PARAM_ID_item );
        u32 new_itemno = ( old_itemno + 1 ) % ( ITEM_DATA_MAX + 1 );
        clone_param->SetParam( pml::pokepara::PARAM_ID_item, new_itemno );
        DebugPokeMakePage1::UpdateItemOnDisplay( clone_param );
      }
      break;

    case ARROW_TOKUSEI_L:
      {
        TokuseiNo old_tokusei_no = clone_param->GetTokuseiNo();
        TokuseiNo new_tokusei_no = static_cast<TokuseiNo>( ( old_tokusei_no + TOKUSEI_MAX ) % ( TOKUSEI_MAX + 1 ) );
        clone_param->OverwriteTokuseiNo( new_tokusei_no );
        DebugPokeMakePage1::UpdateTokuseiOnDisplay( clone_param );
      }
      break;

    case ARROW_TOKUSEI_R:
      {
        TokuseiNo old_tokusei_no = clone_param->GetTokuseiNo();
        TokuseiNo new_tokusei_no = static_cast<TokuseiNo>( ( old_tokusei_no + 1 ) % ( TOKUSEI_MAX + 1 ) );
        clone_param->OverwriteTokuseiNo( new_tokusei_no );
        DebugPokeMakePage1::UpdateTokuseiOnDisplay( clone_param );
      }
      break;

    case ARROW_WAZA1_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(0);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 0, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 0 );
      }
      break;

    case ARROW_WAZA1_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(0);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 0, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 0 );
      }
      break;

    case ARROW_WAZA2_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(1);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 1, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 1 );
      }
      break;

    case ARROW_WAZA2_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(1);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 1, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 1 );
      }
      break;

    case ARROW_WAZA3_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(2);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 2, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 2 );
      }
      break;

    case ARROW_WAZA3_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(2);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 2, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 2 );
      }
      break;

    case ARROW_WAZA4_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(3);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 3, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 3 );
      }
      break;

    case ARROW_WAZA4_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(3);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 3, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 3 );
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }






  // ؂ւXCb`Iꂽۂ̃R[obN֐
  void DebugPokeMakePage1::OnSwitchSelected( app::tool::ButtonManager::ButtonId switch_index, void* work )
  {
    DebugPokeMakePage1* debug_poke_make = reinterpret_cast<DebugPokeMakePage1*>( work );
    pml::pokepara::PokemonParam* clone_param = DebugPokeMake::ClonePokemonParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( switch_index )
    {
    case SWITCH_SEX:
      {
        pml::personal::SexType sex_type = clone_param->GetSexType();
        if( sex_type == pml::personal::SEX_TYPE_RANDOM ) {
          pml::Sex old_sex = clone_param->GetSex();
          pml::Sex new_sex = ( old_sex == pml::SEX_MALE ) ? pml::SEX_FEMALE : pml::SEX_MALE;
          clone_param->ChangeSex( new_sex );
          DebugPokeMakePage1::UpdateSexOnDisplay( clone_param );
        }
      }
      break;

    case SWITCH_TOKUSEI1:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, formno );
        TokuseiNo tokusei_no = static_cast<TokuseiNo>( personal_system->GetPersonalParam( pml::personal::PARAM_ID_tokusei1 ) );
        clone_param->OverwriteTokuseiNo( tokusei_no );
        DebugPokeMakePage1::UpdateTokuseiOnDisplay( clone_param );
      }
      break;

    case SWITCH_TOKUSEI2:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, formno );
        TokuseiNo tokusei_no = static_cast<TokuseiNo>( personal_system->GetPersonalParam( pml::personal::PARAM_ID_tokusei2 ) );
        clone_param->OverwriteTokuseiNo( tokusei_no );
        DebugPokeMakePage1::UpdateTokuseiOnDisplay( clone_param );
      }
      break;

    case SWITCH_TOKUSEI3:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, formno );
        TokuseiNo tokusei_no = static_cast<TokuseiNo>( personal_system->GetPersonalParam( pml::personal::PARAM_ID_tokusei3 ) );
        clone_param->OverwriteTokuseiNo( tokusei_no );
        DebugPokeMakePage1::UpdateTokuseiOnDisplay( clone_param );
      }
      break;

    case SWITCH_DEFAULT_WAZA:
      clone_param->SetDefaultWaza();
      DebugPokeMakePage1::UpdateAllWazaOnDisplay( clone_param ); 
      break;

    case SWITCH_HATAKU:
      for( u32 i=0; i<pml::MAX_WAZA_NUM; i++ ) {
        clone_param->RemoveWaza(i);
      }
      clone_param->SetWaza( 0, WAZANO_HATAKU );
      DebugPokeMakePage1::UpdateAllWazaOnDisplay( clone_param ); 
      break;

    case SWITCH_HANERU:
      for( u32 i=0; i<pml::MAX_WAZA_NUM; i++ ) {
        clone_param->RemoveWaza(i);
      }
      clone_param->SetWaza( 0, WAZANO_HANERU );
      DebugPokeMakePage1::UpdateAllWazaOnDisplay( clone_param ); 
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }





  // {bNXIꂽۂ̃R[obN֐
  void DebugPokeMakePage1::OnStrBoxSelected( app::tool::ButtonManager::ButtonId strbox_index, void* work )
  {
    DebugPokeMakePage1* debug_poke_make = reinterpret_cast<DebugPokeMakePage1*>( work );
    pml::pokepara::PokemonParam* clone_param = DebugPokeMake::ClonePokemonParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( strbox_index )
    {
    case STRBOX_MONSNAME:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 6 );
        keyboard.BootKeyboard();
        MonsNo new_monsno = MONSNO_NULL; // @todo ͂ꂽO烂X^[ԍ擾
        clone_param->ChangeMonsNo( new_monsno, 0 );  // tH0ɂ
        DebugPokeMakePage1::UpdateAllOnDisplay( clone_param );
      }
      break;

    case STRBOX_SEIKAKU:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 5 );
        keyboard.BootKeyboard();
        pml::pokepara::Seikaku new_seikaku = pml::pokepara::SEIKAKU_GANBARIYA;  // @todo ͂ꂽ񂩂琫i肷
        clone_param->ChangeSeikaku( new_seikaku );
        DebugPokeMakePage1::UpdateSeikakuOnDisplay( clone_param );
      }
      break;

    case STRBOX_ITEM:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 8 );
        keyboard.BootKeyboard();
        pml::ItemNo new_item = ITEM_MONSUTAABOORU;  // @todo ͂ꂽ񂩂猈肷
        clone_param->SetParam( pml::pokepara::PARAM_ID_item, new_item );
        DebugPokeMakePage1::UpdateItemOnDisplay( clone_param );
      }
      break;

    case STRBOX_TOKUSEI:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 8 );
        keyboard.BootKeyboard();
        TokuseiNo new_tokusei = TOKUSEI_AMEHURASI;  // @todo ͂ꂽ񂩂琫i肷
        clone_param->OverwriteTokuseiNo( new_tokusei );
        DebugPokeMakePage1::UpdateTokuseiOnDisplay( clone_param );
      }
      break;

    case STRBOX_WAZA1:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 8 );
        keyboard.BootKeyboard();
        WazaNo new_wazano = WAZANO_HATAKU;  // @todo ͂ꂽ񂩂琫i肷
        clone_param->SetWaza( 0, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 0 );
      }
      break;

    case STRBOX_WAZA2:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 8 );
        keyboard.BootKeyboard();
        WazaNo new_wazano = WAZANO_HATAKU;  // @todo ͂ꂽ񂩂琫i肷
        clone_param->SetWaza( 1, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 1 );
      }
      break;

    case STRBOX_WAZA3:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 8 );
        keyboard.BootKeyboard();
        WazaNo new_wazano = WAZANO_HATAKU;  // @todo ͂ꂽ񂩂琫i肷
        clone_param->SetWaza( 2, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 2 );
      }
      break;

    case STRBOX_WAZA4:
      {
        gfl::std::SoftwareKeyboard keyboard( DebugPokeMake::Heap(), 8 );
        keyboard.BootKeyboard();
        WazaNo new_wazano = WAZANO_HATAKU;  // @todo ͂ꂽ񂩂琫i肷
        clone_param->SetWaza( 3, new_wazano );
        DebugPokeMakePage1::UpdateWazaOnDisplay( clone_param, 3 );
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }






  // l{bNXIꂽۂ̃R[obN֐
  void DebugPokeMakePage1::OnNumBoxSelected( app::tool::ButtonManager::ButtonId numbox_index, void* work )
  {
    DebugPokeMakePage1* debug_poke_make = reinterpret_cast<DebugPokeMakePage1*>( work );
    pml::pokepara::PokemonParam* clone_param = DebugPokeMake::ClonePokemonParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( numbox_index )
    {
    case NUMBOX_FORMNO:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, formno );
        u32 form_num = personal_system->GetPersonalParam( pml::personal::PARAM_ID_form_max );
        m_number_register->Reset( form_num - 1, formno );
      }
      break;

    case NUMBOX_LEVEL:
      {
        u32 level = clone_param->GetLevel();
        m_number_register->Reset( pml::MAX_POKE_LEVEL, level );
      }
      break;

    case NUMBOX_EXP:
      {
        u32 exp = clone_param->GetExp();
        m_number_register->Reset( 9999999, exp );
      }
      break;

    case NUMBOX_HP_RND:
      {
        u32 hp_rnd = clone_param->GetTalentPower( pml::pokepara::POWER_HP );
        m_number_register->Reset( pml::MAX_TALENT_POWER, hp_rnd );
      }
      break;

    case NUMBOX_ATK_RND:
      {
        u32 atk_rnd = clone_param->GetTalentPower( pml::pokepara::POWER_ATK );
        m_number_register->Reset( pml::MAX_TALENT_POWER, atk_rnd );
      }
      break;

    case NUMBOX_DEF_RND:
      {
        u32 def_rnd = clone_param->GetTalentPower( pml::pokepara::POWER_DEF );
        m_number_register->Reset( pml::MAX_TALENT_POWER, def_rnd );
      }
      break;

    case NUMBOX_AGI_RND:
      {
        u32 agi_rnd = clone_param->GetTalentPower( pml::pokepara::POWER_AGI );
        m_number_register->Reset( pml::MAX_TALENT_POWER, agi_rnd );
      }
      break;

    case NUMBOX_SPATK_RND:
      {
        u32 spatk_rnd = clone_param->GetTalentPower( pml::pokepara::POWER_SPATK );
        m_number_register->Reset( pml::MAX_TALENT_POWER, spatk_rnd );
      }
      break;

    case NUMBOX_SPDEF_RND:
      {
        u32 spdef_rnd = clone_param->GetTalentPower( pml::pokepara::POWER_SPDEF );
        m_number_register->Reset( pml::MAX_TALENT_POWER, spdef_rnd );
      }
      break;

    case NUMBOX_HP_EXP:
      {
        u32 hp_exp = clone_param->GetEffortPower( pml::pokepara::POWER_HP );
        u32 total_exp = clone_param->GetTotalEffortPower();
        u32 total_exp_without_hp = total_exp - hp_exp;
        s32 over_value = ( total_exp_without_hp + pml::MAX_EFFORT_POWER ) - pml::MAX_TOTAL_EFFORT_POWER;
        u32 max_hp_exp = ( 0 < over_value ) ? ( pml::MAX_EFFORT_POWER - over_value ) : pml::MAX_EFFORT_POWER;
        m_number_register->Reset( max_hp_exp, hp_exp );
      }
      break; 

    case NUMBOX_ATK_EXP:
      {
        u32 atk_exp = clone_param->GetEffortPower( pml::pokepara::POWER_ATK );
        u32 total_exp = clone_param->GetTotalEffortPower();
        u32 total_exp_without_atk = total_exp - atk_exp;
        s32 over_value = ( total_exp_without_atk + pml::MAX_EFFORT_POWER ) - pml::MAX_TOTAL_EFFORT_POWER;
        u32 max_atk_exp = ( 0 < over_value ) ? ( pml::MAX_EFFORT_POWER - over_value ) : pml::MAX_EFFORT_POWER;
        m_number_register->Reset( max_atk_exp, atk_exp );
      }
      break;

    case NUMBOX_DEF_EXP:
      {
        u32 def_exp = clone_param->GetEffortPower( pml::pokepara::POWER_DEF );
        u32 total_exp = clone_param->GetTotalEffortPower();
        u32 total_exp_without_def = total_exp - def_exp;
        s32 over_value = ( total_exp_without_def + pml::MAX_EFFORT_POWER ) - pml::MAX_TOTAL_EFFORT_POWER;
        u32 max_def_exp = ( 0 < over_value ) ? ( pml::MAX_EFFORT_POWER - over_value ) : pml::MAX_EFFORT_POWER;
        m_number_register->Reset( max_def_exp, def_exp );
      }
      break;

    case NUMBOX_AGI_EXP: 
      {
        u32 agi_exp = clone_param->GetEffortPower( pml::pokepara::POWER_AGI );
        u32 total_exp = clone_param->GetTotalEffortPower();
        u32 total_exp_without_agi = total_exp - agi_exp;
        s32 over_value = ( total_exp_without_agi + pml::MAX_EFFORT_POWER ) - pml::MAX_TOTAL_EFFORT_POWER;
        u32 max_agi_exp = ( 0 < over_value ) ? ( pml::MAX_EFFORT_POWER - over_value ) : pml::MAX_EFFORT_POWER;
        m_number_register->Reset( max_agi_exp, agi_exp );
      }
      break;


    case NUMBOX_SPATK_EXP:
      {
        u32 spatk_exp = clone_param->GetEffortPower( pml::pokepara::POWER_SPATK );
        u32 total_exp = clone_param->GetTotalEffortPower();
        u32 total_exp_without_spatk = total_exp - spatk_exp;
        s32 over_value = ( total_exp_without_spatk + pml::MAX_EFFORT_POWER ) - pml::MAX_TOTAL_EFFORT_POWER;
        u32 max_spatk_exp = ( 0 < over_value ) ? ( pml::MAX_EFFORT_POWER - over_value ) : pml::MAX_EFFORT_POWER;
        m_number_register->Reset( max_spatk_exp, spatk_exp );
      }
      break;

    case NUMBOX_SPDEF_EXP:
      {
        u32 spdef_exp = clone_param->GetEffortPower( pml::pokepara::POWER_SPDEF );
        u32 total_exp = clone_param->GetTotalEffortPower();
        u32 total_exp_without_spdef = total_exp - spdef_exp;
        s32 over_value = ( total_exp_without_spdef + pml::MAX_EFFORT_POWER ) - pml::MAX_TOTAL_EFFORT_POWER;
        u32 max_spdef_exp = ( 0 < over_value ) ? ( pml::MAX_EFFORT_POWER - over_value ) : pml::MAX_EFFORT_POWER;
        m_number_register->Reset( max_spdef_exp, spdef_exp );
      }
      break;

    case NUMBOX_WAZA1_UP:
      {
        u32 up_count = clone_param->GetWazaPPUpCount(0);
        m_number_register->Reset( pml::MAX_WAZAPP_UPCOUNT, up_count );
      }
      break;

    case NUMBOX_WAZA2_UP:
      {
        u32 up_count = clone_param->GetWazaPPUpCount(1);
        m_number_register->Reset( pml::MAX_WAZAPP_UPCOUNT, up_count );
      }
      break;

    case NUMBOX_WAZA3_UP:
      {
        u32 up_count = clone_param->GetWazaPPUpCount(2);
        m_number_register->Reset( pml::MAX_WAZAPP_UPCOUNT, up_count );
      }
      break;

    case NUMBOX_WAZA4_UP:
      {
        u32 up_count = clone_param->GetWazaPPUpCount(3);
        m_number_register->Reset( pml::MAX_WAZAPP_UPCOUNT, up_count );
      }
      break;

    case NUMBOX_WAZA1_PP:
      {
        WazaNo wazano = clone_param->GetWazaNo(0);
        u32 pp_count = clone_param->GetWazaPPUpCount(0);
        u32 up_count = clone_param->GetWazaPPUpCount(0);
        u32 max_pp_count = pml::System::WazaDataSystem()->GetMaxPP( wazano, up_count );
        m_number_register->Reset( max_pp_count, pp_count );
      }
      break;

    case NUMBOX_WAZA2_PP:
      {
        WazaNo wazano = clone_param->GetWazaNo(1);
        u32 pp_count = clone_param->GetWazaPPUpCount(1);
        u32 up_count = clone_param->GetWazaPPUpCount(1);
        u32 max_pp_count = pml::System::WazaDataSystem()->GetMaxPP( wazano, up_count );
        m_number_register->Reset( max_pp_count, pp_count );
      }
      break;

    case NUMBOX_WAZA3_PP:
      {
        WazaNo wazano = clone_param->GetWazaNo(2);
        u32 pp_count = clone_param->GetWazaPPUpCount(2);
        u32 up_count = clone_param->GetWazaPPUpCount(2);
        u32 max_pp_count = pml::System::WazaDataSystem()->GetMaxPP( wazano, up_count );
        m_number_register->Reset( max_pp_count, pp_count );
      }
      break;

    case NUMBOX_WAZA4_PP:
      {
        WazaNo wazano = clone_param->GetWazaNo(3);
        u32 pp_count = clone_param->GetWazaPPUpCount(3);
        u32 up_count = clone_param->GetWazaPPUpCount(3);
        u32 max_pp_count = pml::System::WazaDataSystem()->GetMaxPP( wazano, up_count );
        m_number_register->Reset( max_pp_count, pp_count );
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }


    DebugPokeMakePage1::StartAnimation( BUTTON_DESC_FOR_NUMBOX[ numbox_index ].animation_index_for_set_on_target_position );
    DebugPokeMakePage1::SetPaneVisibility( PANENAME_PAGE1_PANE_NUM_INPUT, true );  // l͗pyC\
    DebugPokeMakePage1::m_number_input_target = static_cast<NumberBoxIndex>( numbox_index );
    DebugPokeMakePage1::m_seq = SEQ_NUM_INPUT;
  }








  // l͂ۂ̃R[obN֐
  void DebugPokeMakePage1::OnNumberInputFinished( DebugPokeMakePage1::NumberBoxIndex numbox_index, pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( numbox_index )
    {
    case NUMBOX_FORMNO:
      DebugPokeMakePage1::UpdateFormNoOnDisplay( pokemon_param );
      break;

    case NUMBOX_LEVEL:
      {
        MonsNo monsno = pokemon_param->GetMonsNo();
        pml::FormNo formno = pokemon_param->GetFormNo();
        personal_system->LoadGrowTable( monsno, formno );
        u32 level = m_number_register->GetValue();
        u32 min_exp = personal_system->GetMinExp( level );
        pokemon_param->SetExp( min_exp );
        DebugPokeMakePage1::UpdateLevelOnDisplay( pokemon_param );
        DebugPokeMakePage1::UpdateExpOnDisplay( pokemon_param );
        DebugPokeMakePage1::UpdateHpOnDisplay( pokemon_param );
        DebugPokeMakePage1::UpdateAtkOnDisplay( pokemon_param );
        DebugPokeMakePage1::UpdateDefOnDisplay( pokemon_param );
        DebugPokeMakePage1::UpdateAgiOnDisplay( pokemon_param );
        DebugPokeMakePage1::UpdateSpatkOnDisplay( pokemon_param );
        DebugPokeMakePage1::UpdateSpdefOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_EXP:
      {
        u32 exp = m_number_register->GetValue();
        pokemon_param->SetExp( exp );
        DebugPokeMakePage1::UpdateExpOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_HP_RND:
      {
        u32 hp_rnd = m_number_register->GetValue();
        pokemon_param->ChangeTalentPower( pml::pokepara::POWER_HP, hp_rnd );
        DebugPokeMakePage1::UpdateHpOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_ATK_RND:
      {
        u32 atk_rnd = m_number_register->GetValue();
        pokemon_param->ChangeTalentPower( pml::pokepara::POWER_ATK, atk_rnd );
        DebugPokeMakePage1::UpdateAtkOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_DEF_RND:
      {
        u32 def_rnd = m_number_register->GetValue();
        pokemon_param->ChangeTalentPower( pml::pokepara::POWER_DEF, def_rnd );
        DebugPokeMakePage1::UpdateDefOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_AGI_RND:
      {
        u32 agi_rnd = m_number_register->GetValue();
        pokemon_param->ChangeTalentPower( pml::pokepara::POWER_AGI, agi_rnd );
        DebugPokeMakePage1::UpdateAgiOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_SPATK_RND:
      {
        u32 spatk_rnd = m_number_register->GetValue();
        pokemon_param->ChangeTalentPower( pml::pokepara::POWER_SPATK, spatk_rnd );
        DebugPokeMakePage1::UpdateSpatkOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_SPDEF_RND:
      {
        u32 spdef_rnd = m_number_register->GetValue();
        pokemon_param->ChangeTalentPower( pml::pokepara::POWER_SPDEF, spdef_rnd );
        DebugPokeMakePage1::UpdateSpdefOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_HP_EXP:
      {
        u32 hp_exp = m_number_register->GetValue();
        pokemon_param->ChangeEffortPower( pml::pokepara::POWER_HP, hp_exp );
        DebugPokeMakePage1::UpdateHpOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_ATK_EXP:
      {
        u32 atk_exp = m_number_register->GetValue();
        pokemon_param->ChangeEffortPower( pml::pokepara::POWER_ATK, atk_exp );
        DebugPokeMakePage1::UpdateAtkOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_DEF_EXP:
      {
        u32 def_exp = m_number_register->GetValue();
        pokemon_param->ChangeEffortPower( pml::pokepara::POWER_DEF, def_exp );
        DebugPokeMakePage1::UpdateDefOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_AGI_EXP:
      {
        u32 agi_exp = m_number_register->GetValue();
        pokemon_param->ChangeEffortPower( pml::pokepara::POWER_AGI, agi_exp );
        DebugPokeMakePage1::UpdateAgiOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_SPATK_EXP:
      {
        u32 spatk_exp = m_number_register->GetValue();
        pokemon_param->ChangeEffortPower( pml::pokepara::POWER_SPATK, spatk_exp );
        DebugPokeMakePage1::UpdateSpatkOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_SPDEF_EXP:
      {
        u32 spdef_exp = m_number_register->GetValue();
        pokemon_param->ChangeEffortPower( pml::pokepara::POWER_SPDEF, spdef_exp );
        DebugPokeMakePage1::UpdateSpdefOnDisplay( pokemon_param );
      }
      break;

    case NUMBOX_WAZA1_UP:
      {
        u32 up_count = m_number_register->GetValue();
        pokemon_param->SetWazaPPUpCount( 0, up_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 0 );
      }
      break;

    case NUMBOX_WAZA2_UP:
      {
        u32 up_count = m_number_register->GetValue();
        pokemon_param->SetWazaPPUpCount( 1, up_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 1 );
      }
      break;

    case NUMBOX_WAZA3_UP:
      {
        u32 up_count = m_number_register->GetValue();
        pokemon_param->SetWazaPPUpCount( 2, up_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 2 );
      }
      break;

    case NUMBOX_WAZA4_UP:
      {
        u32 up_count = m_number_register->GetValue();
        pokemon_param->SetWazaPPUpCount( 3, up_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 3 );
      }
      break;

    case NUMBOX_WAZA1_PP:
      {
        u32 pp_count = m_number_register->GetValue();
        pokemon_param->SetWazaPP( 0, pp_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 0 );
      }
      break;

    case NUMBOX_WAZA2_PP:
      {
        u32 pp_count = m_number_register->GetValue();
        pokemon_param->SetWazaPP( 1, pp_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 1 );
      }
      break; 

    case NUMBOX_WAZA3_PP:
      {
        u32 pp_count = m_number_register->GetValue();
        pokemon_param->SetWazaPP( 2, pp_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 2 );
      }
      break;

    case NUMBOX_WAZA4_PP:
      {
        u32 pp_count = m_number_register->GetValue();
        pokemon_param->SetWazaPP( 3, pp_count );
        DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, 3 );
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }

    DebugPokeMakePage1::StopAnimation( BUTTON_DESC_FOR_NUMBOX[ m_number_input_target ].animation_index_for_set_on_target_position );
    DebugPokeMakePage1::SetPaneVisibility( PANENAME_PAGE1_PANE_NUM_INPUT, false );  // l͗pyC
  }







  // SĂ̕\XV
  void DebugPokeMakePage1::UpdateAllOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    DebugPokeMakePage1::UpdateMonsNameOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateFormNoOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateTypeOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateSexOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateSeikakuOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateItemOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateTokuseiOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateLevelOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateExpOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateHpOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateAtkOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateDefOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateAgiOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateSpatkOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateSpdefOnDisplay( pokemon_param );
    DebugPokeMakePage1::UpdateAllWazaOnDisplay( pokemon_param );
  }

  // X^[̕\XV
  void DebugPokeMakePage1::UpdateMonsNameOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno );
    pml::System::PersonalSystem()->GetMonsName( monsno, DebugPokeMake::WorkStrBuf() ); 
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_MONS_NAME, DebugPokeMake::WorkStrBuf() );
  }

  // tHԍ̕\XV
  void DebugPokeMakePage1::UpdateFormNoOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno );
    pml::FormNo max_formno = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_form_max );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), formno, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_FORM_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), max_formno, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_FORM_MAX_VAL, DebugPokeMake::WorkStrBuf() );
  }

  // ^Cv̕\XV
  void DebugPokeMakePage1::UpdateTypeOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::PokeType type1 = pokemon_param->GetType1();
    pml::PokeType type2 = pokemon_param->GetType2();
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_TYPE1, DebugPokeMake::TYPE_NAME[ type1 ] );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_TYPE2, DebugPokeMake::TYPE_NAME[ type2 ] );
  }

  // ʂ̕\XV
  void DebugPokeMakePage1::UpdateSexOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::Sex sex = pokemon_param->GetSex();
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SEX_VAL, DebugPokeMake::SEX_NAME[ sex ] );
  }

  // i̕\XV
  void DebugPokeMakePage1::UpdateSeikakuOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::pokepara::Seikaku seikaku = pokemon_param->GetSeikaku();
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SEIKAKU_NAME, pml::pokepara::SEIKAKU_NAME[ seikaku ] );
  }

  // ̕\XV
  void DebugPokeMakePage1::UpdateItemOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 itemno = pokemon_param->GetParam( pml::pokepara::PARAM_ID_item );
    item::ITEM_DATA item_data( itemno, DebugPokeMake::Heap() );
    item_data.ITEM_GetItemName( DebugPokeMake::WorkStrBuf(), DebugPokeMake::Heap() );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ITEM_NAME, DebugPokeMake::WorkStrBuf() );
  }

  // ̕\XV
  void DebugPokeMakePage1::UpdateTokuseiOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    TokuseiNo tokusei_no = pokemon_param->GetTokuseiNo();
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_TOKUSEI_NAME, TOKUSEI_NAME[ tokusei_no ] ); 
  }

  // x̕\XV
  void DebugPokeMakePage1::UpdateLevelOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 level = pokemon_param->GetLevel();
    print::StrNumber( DebugPokeMake::WorkStrBuf(), level, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_LEVEL_VAL, DebugPokeMake::WorkStrBuf() );
  }

  // ol̕\XV
  void DebugPokeMakePage1::UpdateExpOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 exp = pokemon_param->GetExp();
    print::StrNumber( DebugPokeMake::WorkStrBuf(), exp, 7, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_EXP_VAL, DebugPokeMake::WorkStrBuf() );
  }

  // HP̕\XV
  void DebugPokeMakePage1::UpdateHpOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 hp = pokemon_param->GetHp();
    u32 max_hp = pokemon_param->GetPower( pml::pokepara::POWER_HP );
    u32 hp_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_HP );
    u32 hp_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_HP );
    u32 hp_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_hp );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), hp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_VAL, DebugPokeMake::WorkStrBuf() ); 
    print::StrNumber( DebugPokeMake::WorkStrBuf(), max_hp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_MAX, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), hp_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_RND_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), hp_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_EXP_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), hp_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_BASE_VAL, DebugPokeMake::WorkStrBuf() );
  }

  //uv̕\XV
  void DebugPokeMakePage1::UpdateAtkOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 atk = pokemon_param->GetPower( pml::pokepara::POWER_ATK );
    u32 atk_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_ATK );
    u32 atk_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_ATK );
    u32 atk_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_atk );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), atk, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), atk_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_RND_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), atk_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_EXP_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), atk_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_BASE_VAL, DebugPokeMake::WorkStrBuf() );
  }

  //uڂv̕\XV
  void DebugPokeMakePage1::UpdateDefOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 def = pokemon_param->GetPower( pml::pokepara::POWER_DEF );
    u32 def_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_DEF );
    u32 def_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_DEF );
    u32 def_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_def );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), def, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), def_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_RND_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), def_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_EXP_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), def_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_BASE_VAL, DebugPokeMake::WorkStrBuf() );
  }

  //u΂₳v̕\XV
  void DebugPokeMakePage1::UpdateAgiOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 agi = pokemon_param->GetPower( pml::pokepara::POWER_AGI );
    u32 agi_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_AGI );
    u32 agi_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_AGI );
    u32 agi_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_agi );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), agi, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), agi_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_RND_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), agi_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_EXP_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), agi_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_BASE_VAL, DebugPokeMake::WorkStrBuf() );
  }

  //uƂv̕\XV
  void DebugPokeMakePage1::UpdateSpatkOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 spatk = pokemon_param->GetPower( pml::pokepara::POWER_SPATK );
    u32 spatk_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_SPATK );
    u32 spatk_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_SPATK );
    u32 spatk_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_spatk );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spatk, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spatk_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_RND_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spatk_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_EXP_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spatk_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_BASE_VAL, DebugPokeMake::WorkStrBuf() );
  }

  //uƂڂv̕\XV
  void DebugPokeMakePage1::UpdateSpdefOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 spdef = pokemon_param->GetPower( pml::pokepara::POWER_SPDEF );
    u32 spdef_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_SPDEF );
    u32 spdef_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_SPDEF );
    u32 spdef_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_spdef );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spdef, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spdef_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_RND_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spdef_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_EXP_VAL, DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), spdef_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_BASE_VAL, DebugPokeMake::WorkStrBuf() );
  }

  // SĂ̋Z̕\XV
  void DebugPokeMakePage1::UpdateAllWazaOnDisplay( const pml::pokepara::PokemonParam* pokemon_param )
  {
    for( u32 i=0; i<pml::MAX_WAZA_NUM; i++ ) {
      DebugPokeMakePage1::UpdateWazaOnDisplay( pokemon_param, i );
    }
  }

  // w肵Z̕\XV
  void DebugPokeMakePage1::UpdateWazaOnDisplay( const pml::pokepara::PokemonParam* pokemon_param, u32 waza_index )
  {
    WazaNo wazano = pokemon_param->GetWazaNo( waza_index );
    u32 up_count = pokemon_param->GetWazaPPUpCount( waza_index );
    u32 pp = pokemon_param->GetWazaPP( waza_index );
    u32 max_pp = pokemon_param->GetWazaMaxPP( waza_index );
    pml::System::WazaDataSystem()->GetWazaName( wazano, DebugPokeMake::WorkStrBuf() );
    DebugPokeMakePage1::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_NAME[ waza_index ], DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), up_count, 1, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_UP_VAL[ waza_index ], DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), pp, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_PP_VAL[ waza_index ], DebugPokeMake::WorkStrBuf() );
    print::StrNumber( DebugPokeMake::WorkStrBuf(), max_pp, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_PP_MAX[ waza_index ], DebugPokeMake::WorkStrBuf() );
  }








  // eLXg{bNXyCɕݒ肷
  void DebugPokeMakePage1::SetTextBoxPaneString( gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::StrBuf* strbuf )
  {
    const gfl::str::STRCODE* strcode = strbuf->GetPtr();
    DebugPokeMakePage1::SetTextBoxPaneString( pane_index, strcode );
  }

  // eLXg{bNXyCɕݒ肷
  void DebugPokeMakePage1::SetTextBoxPaneString( gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::STRCODE* strcode )
  {
    gfl::grp::g2d::LytTextBox* text_box;
    text_box = m_layout_work->GetTextBoxPane( pane_index ); 
    GFL_ASSERT( text_box );
    if( text_box ) {
      text_box->SetString( strcode );
    }
  }





  // Aj[VJn
  void DebugPokeMakePage1::StartAnimation( AnimationIndex animation_index )
  {
    if( m_layout_work->IsBindAnime( animation_index ) == false ) {
      m_layout_work->BindAnime( animation_index );
    }
    m_layout_work->SetAutoAnime( animation_index, true );
    m_layout_work->SetAnimeFrame( animation_index, 0 );
  }

  // Aj[V~
  void DebugPokeMakePage1::StopAnimation( AnimationIndex animation_index )
  {
    if( m_layout_work->IsBindAnime( animation_index ) ) {
      m_layout_work->UnBindAnime( animation_index );
    }
  }




  // yC̕\E\ݒ肷
  void DebugPokeMakePage1::SetPaneVisibility( gfl::grp::g2d::LytPaneIndex pane_index, bool visibility )
  {
    gfl::grp::g2d::LytPane* pane;
    pane = m_layout_work->GetPane( pane_index ); 
    GFL_ASSERT( pane );
    if( pane ) {
      pane->SetVisible( visibility );
    }
  }











  gfl::grp::g2d::LytWk* DebugPokeMakePage1::m_layout_work = NULL; 
  DebugPokeMakePage1::Sequence DebugPokeMakePage1::m_seq = DebugPokeMakePage1::SEQ_WAIT;
  app::tool::ButtonManager* DebugPokeMakePage1::m_button_manager = NULL;
  DebugPokeMakePage1::NumberRegister* DebugPokeMakePage1::m_number_register = NULL;
  DebugPokeMakePage1::NumberBoxIndex DebugPokeMakePage1::m_number_input_target = NUMBOX_NUM;


  //-----------------------------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------------------------
  DebugPokeMakePage1::DebugPokeMakePage1( void ) : 
    DebugPokeMakePageBase()
  {
    gfl::heap::HeapBase* heap = DebugPokeMake::Heap();
    gfl::grp::g2d::LytSys* layout_system = DebugPokeMake::LayoutSystem(); 
    const gfl::ui::DeviceManager* ui_device_manager = DebugPokeMake::UiDeviceManager();

    gfl::fs::ArcFile arc_file( ARCID_DEBUG_POKEMAKE, heap );
    gfl::grp::g2d::LytResID layout_resource_id = layout_system->LoadLytRes( DebugPokeMake::NwDeviceAllocator(), &arc_file, GARC_debug_poke_make_debug_poke_make_LYTDAT );
    layout_system->TransferAllTexture( layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );
    m_layout_work = layout_system->CreateLytWk(
        layout_resource_id,
        LYTRES_DEBUG_POKE_MAKE_PAGE1_BCLYT,
        ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
        &gfl::grp::g2d::c_LytWkLowerDefaultSetUp,
        false );  // Aj[VoChȂ
    m_layout_work->SetAutoDrawFlag( false );

    m_layout_work->CreateShareAnime( ANIMATION_ARROW_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_ARROW_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_ARROW_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_ARROW_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_ARROW_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_ARROW_SELECT ] );
    m_layout_work->CreateShareAnime( ANIMATION_SWITCH_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_SWITCH_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_SWITCH_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_SWITCH_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_SWITCH_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_SWITCH_SELECT ] );
    m_layout_work->CreateShareAnime( ANIMATION_STRBOX_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_STRBOX_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_STRBOX_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_STRBOX_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_STRBOX_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_STRBOX_SELECT ] );
    m_layout_work->CreateShareAnime( ANIMATION_NUMBOX_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUMBOX_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_NUMBOX_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUMBOX_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_NUMBOX_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUMBOX_SELECT ] );

    m_button_manager = GFL_NEW( heap ) app::tool::ButtonManager( heap, ui_device_manager, ARROW_NUM + SWITCH_NUM + STRBOX_NUM + NUMBOX_NUM );
    for( u32 i=0; i<ARROW_NUM; i++ ) {
      m_button_manager->AddButton( 
          heap, i, m_layout_work, 
          BUTTON_DESC_FOR_ARROW[i].pane_index,
          BUTTON_DESC_FOR_ARROW[i].hold_animation_index,
          BUTTON_DESC_FOR_ARROW[i].release_animation_index,
          BUTTON_DESC_FOR_ARROW[i].select_animation_index,
          BUTTON_DESC_FOR_ARROW[i].callback_on_select, this );
    }
    for( u32 i=0; i<SWITCH_NUM; i++ ) {
      m_button_manager->AddButton( 
          heap, i, m_layout_work, 
          BUTTON_DESC_FOR_SWITCH[i].pane_index,
          BUTTON_DESC_FOR_SWITCH[i].hold_animation_index,
          BUTTON_DESC_FOR_SWITCH[i].release_animation_index,
          BUTTON_DESC_FOR_SWITCH[i].select_animation_index,
          BUTTON_DESC_FOR_SWITCH[i].callback_on_select, this );
    }
    for( u32 i=0; i<STRBOX_NUM; i++ ) {
      m_button_manager->AddButton( 
          heap, i, m_layout_work, 
          BUTTON_DESC_FOR_STRBOX[i].pane_index,
          BUTTON_DESC_FOR_STRBOX[i].hold_animation_index,
          BUTTON_DESC_FOR_STRBOX[i].release_animation_index,
          BUTTON_DESC_FOR_STRBOX[i].select_animation_index,
          BUTTON_DESC_FOR_STRBOX[i].callback_on_select, this );
    }
    for( u32 i=0; i<NUMBOX_NUM; i++ ) {
      m_button_manager->AddButton( 
          heap, i, m_layout_work, 
          BUTTON_DESC_FOR_NUMBOX[i].pane_index,
          BUTTON_DESC_FOR_NUMBOX[i].hold_animation_index,
          BUTTON_DESC_FOR_NUMBOX[i].release_animation_index,
          BUTTON_DESC_FOR_NUMBOX[i].select_animation_index,
          BUTTON_DESC_FOR_NUMBOX[i].callback_on_select, this );
    }

    m_number_register = GFL_NEW( heap ) NumberRegister( ui_device_manager );

    pml::pokepara::PokemonParam* clone_param = DebugPokeMake::ClonePokemonParam();
    UpdateMonsNameOnDisplay( clone_param );
    UpdateFormNoOnDisplay( clone_param );
    UpdateTypeOnDisplay( clone_param );
    UpdateSexOnDisplay( clone_param );
    UpdateSeikakuOnDisplay( clone_param );
    UpdateItemOnDisplay( clone_param );
    UpdateTokuseiOnDisplay( clone_param );
    UpdateLevelOnDisplay( clone_param );
    UpdateExpOnDisplay( clone_param );
    UpdateHpOnDisplay( clone_param );
    UpdateAtkOnDisplay( clone_param );
    UpdateDefOnDisplay( clone_param );
    UpdateAgiOnDisplay( clone_param );
    UpdateSpatkOnDisplay( clone_param );
    UpdateSpdefOnDisplay( clone_param ); 
    UpdateAllWazaOnDisplay( clone_param ); 
  }



  //-----------------------------------------------------------------------------------------------
  // fXgN^
  //-----------------------------------------------------------------------------------------------
  DebugPokeMakePage1::~DebugPokeMakePage1()
  {
    GFL_DELETE m_button_manager;
    GFL_DELETE m_number_register;

    gfl::grp::g2d::LytSys* layout_system = DebugPokeMake::LayoutSystem(); 
    layout_system->RemoveLytWk( m_layout_work );
  }






  //-----------------------------------------------------------------------------------------------
  // vZX`֐
  //-----------------------------------------------------------------------------------------------
  void DebugPokeMakePage1::Draw( void )
  {
    gfl::grp::GraphicsSystem* graphics_system = DebugPokeMake::GraphicsSystem();
    gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
    m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
  }




  //-----------------------------------------------------------------------------------------------
  // vZXXV֐
  //-----------------------------------------------------------------------------------------------
  DebugPokeMakePageBase::UpdateResult DebugPokeMakePage1::Update( void )
  {
    DebugPokeMakePageBase::UpdateResult result = DebugPokeMakePageBase::UPDATE_RESULT_CONTINUE;
    const gfl::ui::Button* button = DebugPokeMake::UiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
    switch( m_seq )
    {
    case SEQ_WAIT:
      m_button_manager->Update();
      if( button->IsTrigger( gfl::ui::BUTTON_L ) ) {
        result = DebugPokeMakePageBase::UPDATE_RESULT_PREV_PAGE;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_R ) ) {
        result = DebugPokeMakePageBase::UPDATE_RESULT_NEXT_PAGE;
      }
      else if( button->IsTrigger( gfl::ui::BUTTON_START ) ) {
        result = DebugPokeMakePageBase::UPDATE_RESULT_END;
      }
      break;

    case SEQ_NUM_INPUT:
      if( m_number_register->Update() == false ) {
        DebugPokeMakePage1::OnNumberInputFinished( m_number_input_target, DebugPokeMake::ClonePokemonParam() );
        m_seq = SEQ_WAIT;
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }

    m_layout_work->Update();
    return result;
  }









  //===============================================================================================
  // DebugPokeMakePage1::NumberRegister
  //===============================================================================================


  // eƂ̐ݒ
  const DebugPokeMakePage1::NumberRegister::PlaceDesc DebugPokeMakePage1::NumberRegister::PLACE_DESC[ DebugPokeMakePage1::NumberRegister::PLACE_NUM ] = 
  {
    {
      PANENAME_PAGE1_PANE_NUM1_VAL,
      ANIMATION_NUM_INPUT_PLACE_1,
    },
    {
      PANENAME_PAGE1_PANE_NUM2_VAL,
      ANIMATION_NUM_INPUT_PLACE_2,
    },
    {
      PANENAME_PAGE1_PANE_NUM3_VAL,
      ANIMATION_NUM_INPUT_PLACE_3,
    },
    {
      PANENAME_PAGE1_PANE_NUM4_VAL,
      ANIMATION_NUM_INPUT_PLACE_4,
    },
    {
      PANENAME_PAGE1_PANE_NUM5_VAL,
      ANIMATION_NUM_INPUT_PLACE_5,
    },
    {
      PANENAME_PAGE1_PANE_NUM6_VAL,
      ANIMATION_NUM_INPUT_PLACE_6,
    },
    {
      PANENAME_PAGE1_PANE_NUM7_VAL,
      ANIMATION_NUM_INPUT_PLACE_7,
    },
  };




  //-----------------------------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------------------------
  DebugPokeMakePage1::NumberRegister::NumberRegister( const gfl::ui::DeviceManager* ui_device_manager ) :
    m_ui_device_manager( ui_device_manager ),
    m_max_value( 0 ),
    m_value( 0 ),
    m_max_place_index( 0 ),
    m_current_place_index( 0 )
  {
  }

  //-----------------------------------------------------------------------------------------------
  // fXgN^
  //-----------------------------------------------------------------------------------------------
  DebugPokeMakePage1::NumberRegister::~NumberRegister()
  {
  } 

  //-----------------------------------------------------------------------------------------------
  // ͒l擾
  //-----------------------------------------------------------------------------------------------
  u32 DebugPokeMakePage1::NumberRegister::GetValue()
  {
    return m_value;
  } 



  //-----------------------------------------------------------------------------------------------
  // XV
  //-----------------------------------------------------------------------------------------------
  bool DebugPokeMakePage1::NumberRegister::Update()
  {
    const gfl::ui::Button* button = m_ui_device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
    if( button->IsTrigger( gfl::ui::BUTTON_UP ) ) {
      this->IncCurrentPlaceValue();
      this->UpdateDisplayValue();
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_DOWN ) ) {
      this->DecCurrentPlaceValue();
      this->UpdateDisplayValue();
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_RIGHT ) ) {
      if( 0 < m_current_place_index ) {
        m_current_place_index--;
        this->UpdateDisplayPlace();
      }
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_LEFT ) ) {
      if( m_current_place_index < m_max_place_index ) {
        m_current_place_index++;
        this->UpdateDisplayPlace();
      }
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_A ) || button->IsTrigger( gfl::ui::BUTTON_B ) ) {
      return false;
    }
    return true;
  }


  // ݑ쒆̌̒l𑝂₷
  void DebugPokeMakePage1::NumberRegister::IncCurrentPlaceValue( void )
  {
    u32 add_value = 1;
    for( u32 i=0; i<m_current_place_index; i++ ) {
      add_value *= 10;
    }
    u32 next_value = m_value + add_value;
    m_value = ( m_max_value < next_value ) ? m_max_value : next_value;
  }

  // ݑ쒆̌̒l炷
  void DebugPokeMakePage1::NumberRegister::DecCurrentPlaceValue( void )
  {
    u32 sub_value = 1;
    for( u32 i=0; i<m_current_place_index; i++ ) {
      sub_value *= 10;
    }
    m_value = ( m_value < sub_value ) ? 0 : ( m_value - sub_value );
  }


  // l̕\XV
  void DebugPokeMakePage1::NumberRegister::UpdateDisplayValue( void )
  {
    for( u32 i=0; i<PLACE_NUM; i++ ) {
      u32 number = NumberRegister::CalcPlaceNumber( m_value, i );
      UpdatePlaceNumber( i, number );
    }
  }


  // 쒆̌̕\XV
  void DebugPokeMakePage1::NumberRegister::UpdateDisplayPlace( void )
  {
    for( u32 i=0; i<PLACE_NUM; i++ ) {
      DebugPokeMakePage1::StopAnimation( PLACE_DESC[i].focus_animation_index );
    }
    DebugPokeMakePage1::StartAnimation( PLACE_DESC[ m_current_place_index ].focus_animation_index );
  }


  // w肵̐l߂
  u32 DebugPokeMakePage1::NumberRegister::CalcPlaceNumber( u32 value, u32 place_index )
  {
    u32 val = value;
    for( u32 i=0; i<place_index; i++ ) {
      val /= 10;
    }
    return val % 10;
  }


  // w肵ľ߂
  u32 DebugPokeMakePage1::NumberRegister::CalcPlaceCount( u32 value )
  {
    u32 place_count = 1;
    for( u32 val=value; 10<=val; val/=10 ) {
      place_count++;
    }
    return place_count;
  }


  // Zbg
  void DebugPokeMakePage1::NumberRegister::Reset( u32 max_value, u32 init_value )
  {
    m_max_value = max_value;
    m_value = init_value;
    m_max_place_index = CalcPlaceCount( max_value ) - 1;
    m_current_place_index = 0;
    this->UpdateDisplayValue();
    this->UpdateDisplayPlace();
  }


  // w肵̕\XV
  void DebugPokeMakePage1::NumberRegister::UpdatePlaceNumber( u32 place_index, u32 number )
  {
    print::StrNumber( DebugPokeMake::WorkStrBuf(), number, 1, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMakePage1::SetTextBoxPaneString( PLACE_DESC[ place_index ].value_pane_index, DebugPokeMake::WorkStrBuf() );
  }









} // namespace debug 
