//=============================================================================
/**
 *
 *	@file		FieldActionCmdWarp.h
 *	@brief  EFCg ANVR}h
 *	@author hosaka genya
 *	@data		2011.07.07
 *
 */
//=============================================================================
#ifndef __FIELDACTIONCMDWARP_H__
#define __FIELDACTIONCMDWARP_H__

#include "FieldActionCmdBase.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );

enum 
{ 
  AC_WARP_SYNC = 20,
};

typedef struct
{ 
  f32 total_offset;
  f32 value;
} AC_WARP_WORK;

//=================================================================================
// ActionCmdWarpUp
//=================================================================================
class ActionCmdWarpUp : public ActionCmdBase
{
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWarpUp );
public :
  ActionCmdWarpUp( void );
  virtual ~ActionCmdWarpUp(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WARP_UP; }
private:
  static ActionCmdBase::AcmdRet AcWarpInit( ActionCmdBase::ActionCmdWork* p_work );
  static ActionCmdBase::AcmdRet AcWarpMain( ActionCmdBase::ActionCmdWork* p_work );
};

//=================================================================================
// ActionCmdWarpDown
//=================================================================================
class ActionCmdWarpDown : public ActionCmdBase
{
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWarpDown );
public :
  ActionCmdWarpDown( void );
  virtual ~ActionCmdWarpDown(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WARP_DOWN; }
private:
  static ActionCmdBase::AcmdRet AcWarpInit( ActionCmdBase::ActionCmdWork* p_work );
  static ActionCmdBase::AcmdRet AcWarpMain( ActionCmdBase::ActionCmdWork* p_work );
};


GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );

#endif // __FIELDACTIONCMDWARP_H__
