//=============================================================================
/**
 *
 *	@file		FieldActionCmdWarp.cpp
 *	@brief  ANVR}h
 *	@author hosaka genya
 *	@data		2011.07.08
 *
 */
//=============================================================================

#include "FieldActionCmdWarp.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );


//===============================================================================
// ActionCmdWarpUp
//===============================================================================
ActionCmdWarpUp::ActionCmdWarpUp( void )
{
  m_pFuncTbl[0] = AcWarpInit;
  m_pFuncTbl[1] = AcWarpMain;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWarpUp::AcWarpInit( ActionCmdBase::ActionCmdWork* p_work )
{
  AC_WARP_WORK* p_wk = reinterpret_cast<AC_WARP_WORK*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(AC_WARP_WORK) ) );
  p_wk->total_offset = 0;
  p_wk->value = 16.0f;
  
  p_work->p_model->SetDrawStatus( DRAWSTA_DEFAULT_STOP );
  
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

ActionCmdBase::AcmdRet ActionCmdWarpUp::AcWarpMain( ActionCmdBase::ActionCmdWork* p_work )
{
  AC_WARP_WORK* p_wk = reinterpret_cast<AC_WARP_WORK*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(AC_WARP_WORK) ) );
  
  p_wk->total_offset += p_wk->value;
  
  {
    gfl::math::VEC3 vec(0, p_wk->total_offset ,0);
    p_work->p_model->SetDrawOffset( vec );
  }
  
  if( p_wk->total_offset < p_wk->value * AC_WARP_SYNC )
  {
    return ActionCmdBase::ACMD_RET_ONE_TIME_END;
  }
  
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//===============================================================================
// ActionCmdWarpDown
//===============================================================================
ActionCmdWarpDown::ActionCmdWarpDown( void )
{
  m_pFuncTbl[0] = AcWarpInit;
  m_pFuncTbl[1] = AcWarpMain;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWarpDown::AcWarpInit( ActionCmdBase::ActionCmdWork* p_work )
{
  AC_WARP_WORK* p_wk = reinterpret_cast<AC_WARP_WORK*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(AC_WARP_WORK) ) );
  p_wk->total_offset = 16 * AC_WARP_SYNC;
  p_wk->value = -16.0f;
  
  p_work->p_model->SetDrawStatus( DRAWSTA_DEFAULT_STOP );
  
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

ActionCmdBase::AcmdRet ActionCmdWarpDown::AcWarpMain( ActionCmdBase::ActionCmdWork* p_work )
{
  AC_WARP_WORK* p_wk = reinterpret_cast<AC_WARP_WORK*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(AC_WARP_WORK) ) );
  
  p_wk->total_offset += p_wk->value;
  
  if( p_wk->total_offset < 0 )
  {
    p_wk->total_offset = 0;
  }
  
  {
    gfl::math::VEC3 vec(0, p_wk->total_offset ,0);
    p_work->p_model->SetDrawOffset( vec );
  }
  
  if( p_wk->total_offset > 0 )
  {
    return ActionCmdBase::ACMD_RET_ONE_TIME_END;
  }
  
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );

