//======================================================================
/**
 * @file    DebugBtlSaveData.h
 * @brief   fobOogProcpZ[uf[^
 * @author  taya
 * @data    2011/07/08
 */
//======================================================================
#ifndef __DEBUG_BTL_SAVEDATA_H__
#define __DEBUG_BTL_SAVEDATA_H__

#include <gfl_Common.h>
#include <gfl_Heap.h>
#include <pmlib.h>

#include "DebugBtlCommon.h"

namespace test { namespace taya {

class DebugBtlSaveData
{
  GFL_FORBID_COPY_AND_ASSIGN( DebugBtlSaveData );

public:
  DebugBtlSaveData( gfl::heap::HeapBase* pHeap );
  ~DebugBtlSaveData();

  bool Load( void );

  void GetPokeParam( pml::pokepara::PokemonParam* pDst, u32 idx );



private:
  u8*  m_pokeData;

  struct {
    u8  btlMode;
    u8  msgSpeed;
    u8  changeRule;
    u8  badgeCount;
    u8  commMode;
    u8  bEffectEnable;
    u8  recMode;
    u8  recIdx;
  }m_param;


};  // class DebugBtlSaveData

}}  // end of namespace

#endif  // #ifndef __DEBUG_BTL_SAVEDATA_H__

