
#include <pmlib.h>
#include "DebugBtlSaveData.h"

namespace test { namespace taya {


DebugBtlSaveData::DebugBtlSaveData( gfl::heap::HeapBase* pHeap )
{
  m_pokeData = (u8*)GflHeapAllocMemory( pHeap, pml::pokepara::PokemonParam::SERIALIZE_DATA_SIZE * POKE_DATA_MAX );
}
DebugBtlSaveData::~DebugBtlSaveData( )
{
  if( m_pokeData )
  {
    GflHeapFreeMemory( (void*)m_pokeData );
  }
}

bool DebugBtlSaveData::Load( void )
{
  return true;
}

void DebugBtlSaveData::GetPokeParam( pml::pokepara::PokemonParam* pDst, u32 idx )
{
  if( idx < POKE_DATA_MAX )
  {
    u8* p = &m_pokeData[ idx * pml::pokepara::PokemonParam::SERIALIZE_DATA_SIZE ];
    pDst->Deserialize( (const void*)p );
  }
}

}}  // end of namespace

