//=================================================================================================
/**
 * @file DebugPokeMake.cpp
 * @brief fobO|P쐬
 * @author obata_toshihiro
 * @date 2011.07.07
 */
//=================================================================================================
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>
#include <print/printsys.h>
#include <item/item.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <debug/DebugPokeMake.h>

#include <arc/arc_def.h>
#include <arc/debug_poke_make.gaix>
#include "debug_poke_make.h"
#include "debug_poke_make_pane.h"


namespace debug {


  // CAEgVXẽZbgAbvf[^
  const gfl::grp::g2d::LytSysSetUp DebugPokeMake::LAYOUT_SYSTEM_SETUP = 
  {
    128, // Ǘ\[Xő吔
    10,  // ǗCAEg[Nő吔
  }; 

  // Ɨpobt@̒
  const u32 DebugPokeMake::WORK_STRBUF_LENGTH = 128;

  // ^Cv
  const gfl::str::STRCODE* DebugPokeMake::TYPE_NAME[ POKETYPE_MAX ] = 
  {
    L"m[}",
    L"Ƃ",
    L"Ђ",
    L"ǂ",
    L"߂",
    L"",
    L"ނ",
    L"S[Xg",
    L"͂",
    L"ق̂",
    L"݂",
    L"",
    L"ł",
    L"GXp[",
    L"",
    L"hS",
    L"",
    L"悤",
  };

  // ʕ
  const gfl::str::STRCODE* DebugPokeMake::SEX_NAME[ pml::SEX_NUM ] = 
  {
    L"",
    L"",
    L"H",
  };


  const gfl::grp::g2d::LytArcIndex DebugPokeMake::ANIMATION_DATA_TABLE[ DebugPokeMake::ANIMATION_DATA_NUM ] = 
  {
    /* ANIMATION_DATA_ARROW_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_ARROW_HOLD_BCLAN,
    /* ANIMATION_DATA_ARROW_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_ARROW_RELEASE_BCLAN,
    /* ANIMATION_DATA_ARROW_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_ARROW_SELECT_BCLAN,
    /* ANIMATION_DATA_SWITCH_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_BUTTON_HOLD_BCLAN,
    /* ANIMATION_DATA_SWITCH_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_BUTTON_RELEASE_BCLAN,
    /* ANIMATION_DATA_SWITCH_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_BUTTON_SELECT_BCLAN,
    /* ANIMATION_DATA_STRBOX_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_STRING_HOLD_BCLAN,
    /* ANIMATION_DATA_STRBOX_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_STRING_RELEASE_BCLAN,
    /* ANIMATION_DATA_STRBOX_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_STRING_SELECT_BCLAN, 
    /* ANIMATION_DATA_NUMBOX_HOLD */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUMBER_HOLD_BCLAN,
    /* ANIMATION_DATA_NUMBOX_RELEASE */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUMBER_RELEASE_BCLAN,
    /* ANIMATION_DATA_NUMBOX_SELECT */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUMBER_SELECT_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_1 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE1_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_2 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE2_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_3 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE3_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_4 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE4_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_5 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE5_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_6 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE6_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_PLACE_7 */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_PLACE7_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_FORMNO */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_FORMNO_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_LEVEL */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_LEVEL_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_HP_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_HP_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_HP_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_HP_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_ATK_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_ATK_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_ATK_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_ATK_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_DEF_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_DEF_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_DEF_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_DEF_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_AGI_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_AGI_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_AGI_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_AGI_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPATK_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPATK_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPATK_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPATK_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPDEF_RND */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPDEF_RND_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_SPDEF_EXP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_SPDEF_EXP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA1_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA1_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA1_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA1_PP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA2_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA2_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA2_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA2_PP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA3_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA3_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA3_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA3_PP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA4_UP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA4_UP_BCLAN,
    /* ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA4_PP */ LYTRES_DEBUG_POKE_MAKE_PAGE1_NUM_INPUT_BOX_ON_WAZA4_PP_BCLAN,
  };

  const gfl::grp::g2d::LytPaneIndex DebugPokeMake::PANE_INDEX_OF_WAZA_NAME[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_NAME,
    PANENAME_PAGE1_PANE_WAZA2_NAME,
    PANENAME_PAGE1_PANE_WAZA3_NAME,
    PANENAME_PAGE1_PANE_WAZA4_NAME,
  };
  const gfl::grp::g2d::LytPaneIndex DebugPokeMake::PANE_INDEX_OF_WAZA_UP_VAL[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_UP_VAL,
    PANENAME_PAGE1_PANE_WAZA2_UP_VAL,
    PANENAME_PAGE1_PANE_WAZA3_UP_VAL,
    PANENAME_PAGE1_PANE_WAZA4_UP_VAL,
  };
  const gfl::grp::g2d::LytPaneIndex DebugPokeMake::PANE_INDEX_OF_WAZA_PP_VAL[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_PP_VAL,
    PANENAME_PAGE1_PANE_WAZA2_PP_VAL,
    PANENAME_PAGE1_PANE_WAZA3_PP_VAL,
    PANENAME_PAGE1_PANE_WAZA4_PP_VAL,
  };
  const gfl::grp::g2d::LytPaneIndex DebugPokeMake::PANE_INDEX_OF_WAZA_PP_MAX[ pml::MAX_WAZA_NUM ] = 
  {
    PANENAME_PAGE1_PANE_WAZA1_PP_MAX,
    PANENAME_PAGE1_PANE_WAZA2_PP_MAX,
    PANENAME_PAGE1_PANE_WAZA3_PP_MAX,
    PANENAME_PAGE1_PANE_WAZA4_PP_MAX,
  };

  const DebugPokeMake::ButtonDesc DebugPokeMake::BUTTON_DESC_FOR_ARROW[ DebugPokeMake::ARROW_NUM ] = 
  {
    /* ARROW_MONSNO_L */ 
    { 
      PANENAME_PAGE1_PANE_MONS_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_MONSNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_MONSNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_MONSNO_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_MONSNO_R */ 
    { 
      PANENAME_PAGE1_PANE_MONS_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_MONSNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_MONSNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_MONSNO_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_FORMNO_L */ 
    { 
      PANENAME_PAGE1_PANE_FORM_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_FORMNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_FORMNO_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_FORMNO_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_FORMNO_R */ 
    { 
      PANENAME_PAGE1_PANE_FORM_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_FORMNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_FORMNO_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_FORMNO_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_SEIKAKU_L */ 
    { 
      PANENAME_PAGE1_PANE_SEIKAKU_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_SEIKAKU_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_SEIKAKU_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_SEIKAKU_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_SEIKAKU_R */ 
    { 
      PANENAME_PAGE1_PANE_SEIKAKU_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_SEIKAKU_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_SEIKAKU_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_SEIKAKU_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_ITEM_L */ 
    { 
      PANENAME_PAGE1_PANE_ITEM_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_ITEM_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_ITEM_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_ITEM_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_ITEM_R */ 
    { 
      PANENAME_PAGE1_PANE_ITEM_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_ITEM_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_ITEM_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_ITEM_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_TOKUSEI_L */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_TOKUSEI_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_TOKUSEI_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_TOKUSEI_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_TOKUSEI_R */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_TOKUSEI_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_TOKUSEI_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_TOKUSEI_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA1_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA1_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA1_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA1_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA1_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA1_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA1_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA1_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA2_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA2_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA2_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA2_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA2_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA2_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA2_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA2_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA3_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA3_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA3_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA3_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA3_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA3_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA3_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA3_R ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA4_L */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_L,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA4_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA4_L ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA4_L ),
      DebugPokeMake::OnArrowSelected,
    },
    /* ARROW_WAZA4_R */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_R,
      static_cast<AnimationIndex>( ANIMATION_ARROW_HOLD + ARROW_WAZA4_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_RELEASE + ARROW_WAZA4_R ),
      static_cast<AnimationIndex>( ANIMATION_ARROW_SELECT + ARROW_WAZA4_R ),
      DebugPokeMake::OnArrowSelected,
    },
  };
  const DebugPokeMake::ButtonDesc DebugPokeMake::BUTTON_DESC_FOR_SWITCH[ DebugPokeMake::SWITCH_NUM ] = 
  {
    /* SWITCH_SEX */ 
    { 
      PANENAME_PAGE1_PANE_SEX_BACK,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_SEX ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_SEX ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_SEX ),
      DebugPokeMake::OnSwitchSelected,
    },
    /* SWITCH_TOKUSEI1 */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BTN1,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_TOKUSEI1 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_TOKUSEI1 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_TOKUSEI1 ),
      DebugPokeMake::OnSwitchSelected,
    },
    /* SWITCH_TOKUSEI2 */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BTN2,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_TOKUSEI2 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_TOKUSEI2 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_TOKUSEI2 ),
      DebugPokeMake::OnSwitchSelected,
    },
    /* SWITCH_TOKUSEI3 */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BTN3,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_TOKUSEI3 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_TOKUSEI3 ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_TOKUSEI3 ),
      DebugPokeMake::OnSwitchSelected,
    },
    /* SWITCH_DEFAULT_WAZA */ 
    { 
      PANENAME_PAGE1_PANE_WAZA_DEF_BTN,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_DEFAULT_WAZA ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_DEFAULT_WAZA ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_DEFAULT_WAZA ),
      DebugPokeMake::OnSwitchSelected,
    },
    /* SWITCH_HATAKU */ 
    { 
      PANENAME_PAGE1_PANE_WAZA_HATAKU_BTN,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_HATAKU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_HATAKU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_HATAKU ),
      DebugPokeMake::OnSwitchSelected,
    },
    /* SWITCH_HANERU */ 
    { 
      PANENAME_PAGE1_PANE_WAZA_HANERU_BTN,
      static_cast<AnimationIndex>( ANIMATION_SWITCH_HOLD + SWITCH_HANERU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_RELEASE + SWITCH_HANERU ),
      static_cast<AnimationIndex>( ANIMATION_SWITCH_SELECT + SWITCH_HANERU ),
      DebugPokeMake::OnSwitchSelected,
    },
  };
  const DebugPokeMake::ButtonDesc DebugPokeMake::BUTTON_DESC_FOR_STRBOX[ DebugPokeMake::STRBOX_NUM ] = 
  {
    /* STRBOX_MONSNAME */ 
    { 
      PANENAME_PAGE1_PANE_MONS_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_MONSNAME ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_MONSNAME ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_MONSNAME ),
      DebugPokeMake::OnStrBoxSelected,
    },
    /* STRBOX_SEIKAKU */ 
    { 
      PANENAME_PAGE1_PANE_SEIKAKU_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_SEIKAKU ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_SEIKAKU ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_SEIKAKU ),
      DebugPokeMake::OnStrBoxSelected,
    },
    /* STRBOX_ITEM */ 
    { 
      PANENAME_PAGE1_PANE_ITEM_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_ITEM ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_ITEM ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_ITEM ),
      DebugPokeMake::OnStrBoxSelected,
    },
    /* STRBOX_TOKUSEI */ 
    { 
      PANENAME_PAGE1_PANE_TOKUSEI_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_TOKUSEI ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_TOKUSEI ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_TOKUSEI ),
      DebugPokeMake::OnStrBoxSelected,
    },
    /* STRBOX_WAZA1 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA1 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA1 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA1 ),
      DebugPokeMake::OnStrBoxSelected,
    },
    /* STRBOX_WAZA2 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA2 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA2 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA2 ),
      DebugPokeMake::OnStrBoxSelected,
    },
    /* STRBOX_WAZA3 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA3 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA3 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA3 ),
      DebugPokeMake::OnStrBoxSelected,
    },
    /* STRBOX_WAZA4 */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_NAME_BACK,
      static_cast<AnimationIndex>( ANIMATION_STRBOX_HOLD + STRBOX_WAZA4 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_RELEASE + STRBOX_WAZA4 ),
      static_cast<AnimationIndex>( ANIMATION_STRBOX_SELECT + STRBOX_WAZA4 ),
      DebugPokeMake::OnStrBoxSelected,
    },
  };
  const DebugPokeMake::ButtonDesc DebugPokeMake::BUTTON_DESC_FOR_NUMBOX[ DebugPokeMake::NUMBOX_NUM ] = 
  {
    /* NUMBOX_FORMNO */ 
    { 
      PANENAME_PAGE1_PANE_FORM_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_FORMNO ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_FORMNO ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_FORMNO ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_FORMNO,
    },
    /* NUMBOX_LEVEL */ 
    { 
      PANENAME_PAGE1_PANE_LEVEL_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_LEVEL ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_LEVEL ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_LEVEL ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_LEVEL,
    },
    /* NUMBOX_EXP */ 
    { 
      PANENAME_PAGE1_PANE_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_EXP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_EXP,
    },
    /* NUMBOX_HP_RND */ 
    { 
      PANENAME_PAGE1_PANE_HP_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_HP_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_HP_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_HP_RND ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_HP_RND,
    },
    /* NUMBOX_HP_EXP */ 
    { 
      PANENAME_PAGE1_PANE_HP_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_HP_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_HP_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_HP_EXP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_HP_EXP,
    },
    /* NUMBOX_ATK_RND */ 
    { 
      PANENAME_PAGE1_PANE_ATK_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_ATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_ATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_ATK_RND ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_ATK_RND,
    },
    /* NUMBOX_ATK_EXP */ 
    { 
      PANENAME_PAGE1_PANE_ATK_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_ATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_ATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_ATK_EXP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_ATK_EXP,
    },
    /* NUMBOX_DEF_RND */ 
    { 
      PANENAME_PAGE1_PANE_DEF_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_DEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_DEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_DEF_RND ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_DEF_RND,
    },
    /* NUMBOX_DEF_EXP */ 
    { 
      PANENAME_PAGE1_PANE_DEF_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_DEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_DEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_DEF_EXP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_DEF_EXP,
    },
    /* NUMBOX_AGI_RND */ 
    { 
      PANENAME_PAGE1_PANE_AGI_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_AGI_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_AGI_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_AGI_RND ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_AGI_RND,
    },
    /* NUMBOX_AGI_EXP */ 
    { 
      PANENAME_PAGE1_PANE_AGI_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_AGI_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_AGI_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_AGI_EXP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_AGI_EXP,
    },
    /* NUMBOX_SPATK_RND */ 
    { 
      PANENAME_PAGE1_PANE_SPATK_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPATK_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPATK_RND ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPATK_RND,
    },
    /* NUMBOX_SPATK_EXP */ 
    { 
      PANENAME_PAGE1_PANE_SPATK_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPATK_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPATK_EXP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPATK_EXP,
    },
    /* NUMBOX_SPDEF_RND */ 
    { 
      PANENAME_PAGE1_PANE_SPDEF_RND_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPDEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPDEF_RND ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPDEF_RND ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPDEF_RND,
    },
    /* NUMBOX_SPDEF_EXP */ 
    { 
      PANENAME_PAGE1_PANE_SPDEF_EXP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_SPDEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_SPDEF_EXP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_SPDEF_EXP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_SPDEF_EXP,
    },
    /* NUMBOX_WAZA1_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA1_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA1_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA1_UP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA1_UP,
    },
    /* NUMBOX_WAZA1_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA1_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA1_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA1_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA1_PP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA1_PP,
    },
    /* NUMBOX_WAZA2_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA2_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA2_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA2_UP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA2_UP,
    },
    /* NUMBOX_WAZA2_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA2_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA2_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA2_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA2_PP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA2_PP,
    },
    /* NUMBOX_WAZA3_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA3_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA3_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA3_UP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA3_UP,
    },
    /* NUMBOX_WAZA3_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA3_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA3_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA3_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA3_PP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA3_PP,
    },
    /* NUMBOX_WAZA4_UP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_UP_BACK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA4_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA4_UP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA4_UP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA4_UP,
    },
    /* NUMBOX_WAZA4_PP */ 
    { 
      PANENAME_PAGE1_PANE_WAZA4_PP_VAL_BCK,
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_HOLD + NUMBOX_WAZA4_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_RELEASE + NUMBOX_WAZA4_PP ),
      static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_WAZA4_PP ),
      DebugPokeMake::OnNumBoxSelected,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA4_PP,
    },
  };





  const gfl::grp::g2d::LytPaneIndex DebugPokeMake::NumberRegister::PANE_INDEX_OF_NUMBOX_PLACE_VALUE[ DebugPokeMake::NumberRegister::NUMBOX_PLACE_NUM ] = 
  {
    PANENAME_PAGE1_PANE_NUM1_VAL,
    PANENAME_PAGE1_PANE_NUM2_VAL,
    PANENAME_PAGE1_PANE_NUM3_VAL,
    PANENAME_PAGE1_PANE_NUM4_VAL,
    PANENAME_PAGE1_PANE_NUM5_VAL,
    PANENAME_PAGE1_PANE_NUM6_VAL,
    PANENAME_PAGE1_PANE_NUM7_VAL,
  };

  const DebugPokeMake::AnimationIndex DebugPokeMake::NumberRegister::ANIMATION_INDEX_OF_NUMBOX_PLACE[ DebugPokeMake::NumberRegister::NUMBOX_PLACE_NUM ] = 
  {
    ANIMATION_NUM_INPUT_PLACE_1,
    ANIMATION_NUM_INPUT_PLACE_2,
    ANIMATION_NUM_INPUT_PLACE_3,
    ANIMATION_NUM_INPUT_PLACE_4,
    ANIMATION_NUM_INPUT_PLACE_5,
    ANIMATION_NUM_INPUT_PLACE_6,
    ANIMATION_NUM_INPUT_PLACE_7,
  };


  DebugPokeMake::NumberRegister::NumberRegister( const gfl::ui::DeviceManager* ui_device_manager ) :
    m_ui_device_manager( ui_device_manager ),
    m_max_value( 0 ),
    m_value( 0 ),
    m_max_place( 0 ),
    m_current_place( 0 )
  {
  }
  DebugPokeMake::NumberRegister::~NumberRegister()
  {
  }
  bool DebugPokeMake::NumberRegister::Update()
  {
    const gfl::ui::Button* button = m_ui_device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
    if( button->IsTrigger( gfl::ui::BUTTON_UP ) ) {
      u32 add_value = 1;
      for( u32 i=0; i<m_current_place; i++ ) {
        add_value *= 10;
      }
      u32 next_value = m_value + add_value;
      m_value = ( m_max_value < next_value ) ? m_max_value : next_value;
      for( u32 i=0; i<=m_max_place; i++ ) {
        u32 number = this->GetPlaceNumber( m_value, i );
        print::StrNumber( m_work_strbuf, number, 1, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
        DebugPokeMake::SetTextBoxPaneString( PANE_INDEX_OF_NUMBOX_PLACE_VALUE[i], m_work_strbuf );
      }
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_DOWN ) ) {
      u32 sub_value = 1;
      for( u32 i=0; i<m_current_place; i++ ) {
        sub_value *= 10;
      }
      m_value = ( m_value < sub_value ) ? 0 : ( m_value - sub_value );
      for( u32 i=0; i<=m_max_place; i++ ) {
        u32 number = this->GetPlaceNumber( m_value, i );
        print::StrNumber( m_work_strbuf, number, 1, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
        DebugPokeMake::SetTextBoxPaneString( PANE_INDEX_OF_NUMBOX_PLACE_VALUE[i], m_work_strbuf );
      }
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_RIGHT ) ) {
      if( 0 < m_current_place ) {
        m_current_place--;
        for( u32 i=0; i<NUMBOX_PLACE_NUM; i++ ) {
          DebugPokeMake::StopAnimation( ANIMATION_INDEX_OF_NUMBOX_PLACE[i] );
        }
        DebugPokeMake::StartAnimation( ANIMATION_INDEX_OF_NUMBOX_PLACE[ m_current_place ] );
      }
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_LEFT ) ) {
      if( m_current_place < m_max_place ) {
        m_current_place++;
        for( u32 i=0; i<NUMBOX_PLACE_NUM; i++ ) {
          DebugPokeMake::StopAnimation( ANIMATION_INDEX_OF_NUMBOX_PLACE[i] );
        }
        DebugPokeMake::StartAnimation( ANIMATION_INDEX_OF_NUMBOX_PLACE[ m_current_place ] );
      }
    }
    else if( button->IsTrigger( gfl::ui::BUTTON_B ) ) {
      return false;
    }
    return true;
  }
  u32 DebugPokeMake::NumberRegister::GetPlaceNumber( u32 value, u32 place )
  {
    u32 val = m_value;
    for( u32 i=0; i<place; i++ ) {
      val /= 10;
    }
    return val % 10;
  }
  void DebugPokeMake::NumberRegister::Reset( u32 max_value, u32 init_value )
  {
    m_max_value = max_value;
    m_value = init_value;
    m_max_place = 0;
    for( u32 num=max_value; num/10!=0; num/=10 ) {
      m_max_place++;
    }
    m_current_place = 0;
    for( u32 i=0; i<NUMBOX_PLACE_NUM; i++ ) {
      u32 current_place_number = this->GetPlaceNumber( m_value, i );
      print::StrNumber( m_work_strbuf, current_place_number, 1, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
      DebugPokeMake::SetTextBoxPaneString( PANE_INDEX_OF_NUMBOX_PLACE_VALUE[i], m_work_strbuf );
    }
    for( u32 i=0; i<NUMBOX_PLACE_NUM; i++ ) {
      DebugPokeMake::StopAnimation( ANIMATION_INDEX_OF_NUMBOX_PLACE[i] );
    }
    DebugPokeMake::StartAnimation( ANIMATION_INDEX_OF_NUMBOX_PLACE[0] );
  }
  u32 DebugPokeMake::NumberRegister::GetValue()
  {
    return m_value;
  }





  void DebugPokeMake::OnArrowSelected( app::tool::ButtonManager::ButtonId arrow_index, void* work )
  {
    DebugPokeMake* debug_poke_make = reinterpret_cast<DebugPokeMake*>( work );
    pml::pokepara::PokemonParam* clone_param = debug_poke_make->GetCloneParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( arrow_index )
    {
    case ARROW_MONSNO_L:
      {
        MonsNo old_monsno = clone_param->GetMonsNo();
        MonsNo new_monsno = static_cast<MonsNo>( ( old_monsno + MONSNO_END ) % ( MONSNO_END + 1 ) );
        // @todo monsnoύX
      }
      break;

    case ARROW_MONSNO_R:
      {
        MonsNo old_monsno = clone_param->GetMonsNo();
        MonsNo new_monsno = static_cast<MonsNo>( ( old_monsno + 1 ) % ( MONSNO_END + 1 ) );
        // @todo monsnoύX
      }
      break;

    case ARROW_FORMNO_L:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo old_formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, old_formno );
        u32 form_num = personal_system->GetPersonalParam( pml::personal::PARAM_ID_form_max );
        if( 1 < form_num ) {
          pml::FormNo new_formno = ( old_formno + form_num - 1 ) % form_num;
          clone_param->ChangeFormNo( new_formno );
          DebugPokeMake::UpdateFormNo( clone_param );
        }
      }
      break;

    case ARROW_FORMNO_R:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo old_formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, old_formno );
        u32 form_num = personal_system->GetPersonalParam( pml::personal::PARAM_ID_form_max );
        if( 1 < form_num ) {
          pml::FormNo new_formno = ( old_formno + 1 ) % form_num;
          clone_param->ChangeFormNo( new_formno );
          DebugPokeMake::UpdateFormNo( clone_param );
        }
      }
      break;

    case ARROW_SEIKAKU_L:
      {
        pml::pokepara::Seikaku old_seikaku = clone_param->GetSeikaku();
        u32 new_seikaku_value = ( old_seikaku + pml::pokepara::SEIKAKU_MAX - 1 ) % pml::pokepara::SEIKAKU_MAX;
        pml::pokepara::Seikaku new_seikaku = static_cast<pml::pokepara::Seikaku>( new_seikaku_value );
        clone_param->ChangeSeikaku( new_seikaku );
        DebugPokeMake::UpdateSeikaku( clone_param );
        DebugPokeMake::UpdateHp( clone_param );
        DebugPokeMake::UpdateAtk( clone_param );
        DebugPokeMake::UpdateDef( clone_param );
        DebugPokeMake::UpdateAgi( clone_param );
        DebugPokeMake::UpdateSpatk( clone_param );
        DebugPokeMake::UpdateSpdef( clone_param );
      }
      break;

    case ARROW_SEIKAKU_R:
      {
        pml::pokepara::Seikaku old_seikaku = clone_param->GetSeikaku();
        u32 new_seikaku_value = ( old_seikaku + 1 ) % pml::pokepara::SEIKAKU_MAX;
        pml::pokepara::Seikaku new_seikaku = static_cast<pml::pokepara::Seikaku>( new_seikaku_value );
        clone_param->ChangeSeikaku( new_seikaku );
        DebugPokeMake::UpdateSeikaku( clone_param );
        DebugPokeMake::UpdateHp( clone_param );
        DebugPokeMake::UpdateAtk( clone_param );
        DebugPokeMake::UpdateDef( clone_param );
        DebugPokeMake::UpdateAgi( clone_param );
        DebugPokeMake::UpdateSpatk( clone_param );
        DebugPokeMake::UpdateSpdef( clone_param );
      }
      break;

    case ARROW_ITEM_L:
      {
        u32 old_itemno = clone_param->GetParam( pml::pokepara::PARAM_ID_item );
        u32 new_itemno = ( old_itemno + ITEM_DATA_MAX ) % ( ITEM_DATA_MAX + 1 );
        clone_param->SetParam( pml::pokepara::PARAM_ID_item, new_itemno );
        DebugPokeMake::UpdateItem( clone_param );
      }
      break;

    case ARROW_ITEM_R:
      {
        u32 old_itemno = clone_param->GetParam( pml::pokepara::PARAM_ID_item );
        u32 new_itemno = ( old_itemno + 1 ) % ( ITEM_DATA_MAX + 1 );
        clone_param->SetParam( pml::pokepara::PARAM_ID_item, new_itemno );
        DebugPokeMake::UpdateItem( clone_param );
      }
      break;

    case ARROW_TOKUSEI_L:
      // @todo 
      break;

    case ARROW_TOKUSEI_R:
      // @todo 
      break;

    case ARROW_WAZA1_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(0);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 0, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 0 );
      }
      break;

    case ARROW_WAZA1_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(0);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 0, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 0 );
      }
      break;

    case ARROW_WAZA2_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(1);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 1, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 1 );
      }
      break;

    case ARROW_WAZA2_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(1);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 1, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 1 );
      }
      break;

    case ARROW_WAZA3_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(2);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 2, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 2 );
      }
      break;

    case ARROW_WAZA3_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(2);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 2, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 2 );
      }
      break;

    case ARROW_WAZA4_L:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(3);
        u32 new_wazano_value = ( old_wazano + WAZANO_MAX - 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 3, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 3 );
      }
      break;

    case ARROW_WAZA4_R:
      {
        WazaNo old_wazano = clone_param->GetWazaNo(3);
        u32 new_wazano_value = ( old_wazano + 1 ) % WAZANO_MAX;
        WazaNo new_wazano = static_cast<WazaNo>( new_wazano_value );
        clone_param->SetWaza( 3, new_wazano );
        DebugPokeMake::UpdateWaza( clone_param, 3 );
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }

  void DebugPokeMake::OnSwitchSelected( app::tool::ButtonManager::ButtonId switch_index, void* work )
  {
    DebugPokeMake* debug_poke_make = reinterpret_cast<DebugPokeMake*>( work );
    pml::pokepara::PokemonParam* clone_param = debug_poke_make->GetCloneParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( switch_index )
    {
    case SWITCH_SEX:
      {
        pml::personal::SexType sex_type = clone_param->GetSexType();
        if( sex_type == pml::personal::SEX_TYPE_RANDOM ) {
          pml::Sex old_sex = clone_param->GetSex();
          pml::Sex new_sex = ( old_sex == pml::SEX_MALE ) ? pml::SEX_FEMALE : pml::SEX_MALE;
          // @todo ʂύX
          DebugPokeMake::UpdateSex( clone_param );
        }
      }
      break;

    case SWITCH_TOKUSEI1:
      // @todo
      break;

    case SWITCH_TOKUSEI2:
      // @todo
      break;

    case SWITCH_TOKUSEI3:
      // @todo
      break;

    case SWITCH_DEFAULT_WAZA:
      clone_param->SetDefaultWaza();
      DebugPokeMake::UpdateAllWaza( clone_param ); 
      break;

    case SWITCH_HATAKU:
      for( u32 i=0; i<pml::MAX_WAZA_NUM; i++ ) {
        clone_param->RemoveWaza(i);
      }
      clone_param->SetWaza( 0, WAZANO_HATAKU );
      DebugPokeMake::UpdateAllWaza( clone_param ); 
      break;

    case SWITCH_HANERU:
      for( u32 i=0; i<pml::MAX_WAZA_NUM; i++ ) {
        clone_param->RemoveWaza(i);
      }
      clone_param->SetWaza( 0, WAZANO_HANERU );
      DebugPokeMake::UpdateAllWaza( clone_param ); 
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }

  void DebugPokeMake::OnStrBoxSelected( app::tool::ButtonManager::ButtonId strbox_index, void* work )
  {
    DebugPokeMake* debug_poke_make = reinterpret_cast<DebugPokeMake*>( work );
    pml::pokepara::PokemonParam* clone_param = debug_poke_make->GetCloneParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( strbox_index )
    {
    case STRBOX_MONSNAME:
      // @todo 
      break;

    case STRBOX_SEIKAKU:
      // @todo 
      break;

    case STRBOX_ITEM:
      // @todo 
      break;

    case STRBOX_TOKUSEI:
      // @todo 
      break;

    case STRBOX_WAZA1:
      // @todo 
      break;

    case STRBOX_WAZA2:
      // @todo 
      break;

    case STRBOX_WAZA3:
      // @todo 
      break;

    case STRBOX_WAZA4:
      // @todo 
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }

  void DebugPokeMake::OnNumBoxSelected( app::tool::ButtonManager::ButtonId numbox_index, void* work )
  {
    DebugPokeMake* debug_poke_make = reinterpret_cast<DebugPokeMake*>( work );
    pml::pokepara::PokemonParam* clone_param = debug_poke_make->GetCloneParam();
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( numbox_index )
    {
    case NUMBOX_FORMNO:
      {
        MonsNo monsno = clone_param->GetMonsNo();
        pml::FormNo formno = clone_param->GetFormNo();
        personal_system->LoadPersonalData( monsno, formno );
        u32 form_num = personal_system->GetPersonalParam( pml::personal::PARAM_ID_form_max );
        m_number_register->Reset( form_num - 1, formno );
        DebugPokeMake::StartAnimation( BUTTON_DESC_FOR_NUMBOX[ NUMBOX_FORMNO ].animation_index_of_num_input_position_set );
        DebugPokeMake::SetPaneVisibility( PANENAME_PAGE1_PANE_NUM_INPUT, true );
        DebugPokeMake::m_number_input_target = NUMBOX_FORMNO;
        DebugPokeMake::m_seq = SEQ_NUM_INPUT;
      }
      break;

    case NUMBOX_LEVEL:
      {
        u32 level = clone_param->GetLevel();
        u32 form_num = personal_system->GetPersonalParam( pml::personal::PARAM_ID_form_max );
        m_number_register->Reset( pml::MAX_POKE_LEVEL, level );
        DebugPokeMake::StartAnimation( BUTTON_DESC_FOR_NUMBOX[ NUMBOX_LEVEL ].animation_index_of_num_input_position_set );
        DebugPokeMake::SetPaneVisibility( PANENAME_PAGE1_PANE_NUM_INPUT, true );
        DebugPokeMake::m_number_input_target = NUMBOX_LEVEL;
        DebugPokeMake::m_seq = SEQ_NUM_INPUT;
      }
      break;

    case NUMBOX_EXP:
      // @todo
      break;

    case NUMBOX_HP_RND:
      // @todo
      break;

    case NUMBOX_HP_EXP:
      // @todo
      break;

    case NUMBOX_ATK_RND:
      // @todo
      break;

    case NUMBOX_ATK_EXP:
      // @todo
      break;

    case NUMBOX_DEF_RND:
      // @todo
      break;

    case NUMBOX_DEF_EXP:
      // @todo
      break;

    case NUMBOX_AGI_RND:
      // @todo
      break;

    case NUMBOX_AGI_EXP:
      // @todo
      break;

    case NUMBOX_SPATK_RND:
      // @todo
      break;

    case NUMBOX_SPATK_EXP:
      // @todo
      break;

    case NUMBOX_SPDEF_RND:
      // @todo
      break;

    case NUMBOX_SPDEF_EXP:
      // @todo
      break;

    case NUMBOX_WAZA1_UP:
      // @todo
      break;

    case NUMBOX_WAZA1_PP:
      // @todo
      break;

    case NUMBOX_WAZA2_UP:
      // @todo
      break;

    case NUMBOX_WAZA2_PP:
      // @todo
      break;

    case NUMBOX_WAZA3_UP:
      // @todo
      break;

    case NUMBOX_WAZA3_PP:
      // @todo
      break;

    case NUMBOX_WAZA4_UP:
      // @todo
      break;

    case NUMBOX_WAZA4_PP:
      // @todo
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }


  void DebugPokeMake::OnNumberInputFinished( DebugPokeMake::NumberBoxIndex numbox_index, pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::personal::System* personal_system = pml::System::PersonalSystem();

    switch( numbox_index )
    {
    case NUMBOX_FORMNO:
      DebugPokeMake::UpdateFormNo( pokemon_param );
      StopAnimation( static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_FORMNO ) );
      break;

    case NUMBOX_LEVEL:
      {
        MonsNo monsno = pokemon_param->GetMonsNo();
        pml::FormNo formno = pokemon_param->GetFormNo();
        personal_system->LoadGrowTable( monsno, formno );
        u32 level = m_number_register->GetValue();
        u32 min_exp = personal_system->GetMinExp( level );
        pokemon_param->SetExp( min_exp );
        DebugPokeMake::UpdateLevel( pokemon_param );
        DebugPokeMake::UpdateExp( pokemon_param );
        StopAnimation( static_cast<AnimationIndex>( ANIMATION_NUMBOX_SELECT + NUMBOX_LEVEL ) );
      }
      break;

    case NUMBOX_EXP:
      // @todo
      break;

    case NUMBOX_HP_RND:
      // @todo
      break;

    case NUMBOX_HP_EXP:
      // @todo
      break;

    case NUMBOX_ATK_RND:
      // @todo
      break;

    case NUMBOX_ATK_EXP:
      // @todo
      break;

    case NUMBOX_DEF_RND:
      // @todo
      break;

    case NUMBOX_DEF_EXP:
      // @todo
      break;

    case NUMBOX_AGI_RND:
      // @todo
      break;

    case NUMBOX_AGI_EXP:
      // @todo
      break;

    case NUMBOX_SPATK_RND:
      // @todo
      break;

    case NUMBOX_SPATK_EXP:
      // @todo
      break;

    case NUMBOX_SPDEF_RND:
      // @todo
      break;

    case NUMBOX_SPDEF_EXP:
      // @todo
      break;

    case NUMBOX_WAZA1_UP:
      // @todo
      break;

    case NUMBOX_WAZA1_PP:
      // @todo
      break;

    case NUMBOX_WAZA2_UP:
      // @todo
      break;

    case NUMBOX_WAZA2_PP:
      // @todo
      break;

    case NUMBOX_WAZA3_UP:
      // @todo
      break;

    case NUMBOX_WAZA3_PP:
      // @todo
      break;

    case NUMBOX_WAZA4_UP:
      // @todo
      break;

    case NUMBOX_WAZA4_PP:
      // @todo
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }



  void DebugPokeMake::UpdateMonsName( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno );
    pml::System::PersonalSystem()->GetMonsName( monsno, m_work_strbuf ); 
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_MONS_NAME, m_work_strbuf );
  }
  void DebugPokeMake::UpdateFormNo( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno );
    pml::FormNo max_formno = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_form_max );
    print::StrNumber( m_work_strbuf, formno, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_FORM_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, max_formno, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_FORM_MAX_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateType( const pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::PokeType type1 = pokemon_param->GetType1();
    pml::PokeType type2 = pokemon_param->GetType2();
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_TYPE1, TYPE_NAME[ type1 ] );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_TYPE2, TYPE_NAME[ type2 ] );
  }
  void DebugPokeMake::UpdateSex( const pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::Sex sex = pokemon_param->GetSex();
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SEX_VAL, SEX_NAME[ sex ] );
  }
  void DebugPokeMake::UpdateSeikaku( const pml::pokepara::PokemonParam* pokemon_param )
  {
    pml::pokepara::Seikaku seikaku = pokemon_param->GetSeikaku();
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SEIKAKU_NAME, pml::pokepara::SEIKAKU_NAME[ seikaku ] );
  }
  void DebugPokeMake::UpdateItem( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 itemno = pokemon_param->GetParam( pml::pokepara::PARAM_ID_item );
    item::ITEM_DATA item_data( itemno, m_heap );
    item_data.ITEM_GetItemName( m_work_strbuf, m_heap );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ITEM_NAME, m_work_strbuf );
  }
  void DebugPokeMake::UpdateTokusei( const pml::pokepara::PokemonParam* pokemon_param )
  {
    TokuseiNo tokusei_no = pokemon_param->GetTokuseiNo();
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_TOKUSEI_NAME, TOKUSEI_NAME[ tokusei_no ] ); 
  }
  void DebugPokeMake::UpdateLevel( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 level = pokemon_param->GetLevel();
    print::StrNumber( m_work_strbuf, level, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_LEVEL_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateExp( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 exp = pokemon_param->GetExp();
    print::StrNumber( m_work_strbuf, exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_EXP_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateHp( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 hp = pokemon_param->GetHp();
    u32 max_hp = pokemon_param->GetPower( pml::pokepara::POWER_HP );
    u32 hp_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_HP );
    u32 hp_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_HP );
    u32 hp_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_hp );
    print::StrNumber( m_work_strbuf, hp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_VAL, m_work_strbuf ); 
    print::StrNumber( m_work_strbuf, max_hp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_MAX, m_work_strbuf );
    print::StrNumber( m_work_strbuf, hp_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_RND_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, hp_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_EXP_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, hp_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_HP_BASE_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateAtk( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 atk = pokemon_param->GetPower( pml::pokepara::POWER_ATK );
    u32 atk_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_ATK );
    u32 atk_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_ATK );
    u32 atk_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_atk );
    print::StrNumber( m_work_strbuf, atk, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, atk_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_RND_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, atk_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_EXP_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, atk_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_ATK_BASE_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateDef( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 def = pokemon_param->GetPower( pml::pokepara::POWER_DEF );
    u32 def_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_DEF );
    u32 def_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_DEF );
    u32 def_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_def );
    print::StrNumber( m_work_strbuf, def, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, def_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_RND_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, def_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_EXP_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, def_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_DEF_BASE_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateAgi( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 agi = pokemon_param->GetPower( pml::pokepara::POWER_AGI );
    u32 agi_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_AGI );
    u32 agi_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_AGI );
    u32 agi_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_agi );
    print::StrNumber( m_work_strbuf, agi, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, agi_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_RND_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, agi_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_EXP_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, agi_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_AGI_BASE_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateSpatk( const pml::pokepara::PokemonParam* pokemon_param )
  {
    u32 spatk = pokemon_param->GetPower( pml::pokepara::POWER_SPATK );
    u32 spatk_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_SPATK );
    u32 spatk_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_SPATK );
    u32 spatk_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_spatk );
    print::StrNumber( m_work_strbuf, spatk, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, spatk_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_RND_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, spatk_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_EXP_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, spatk_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPATK_BASE_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateSpdef( const pml::pokepara::PokemonParam* pokemon_param )
  {
    MonsNo monsno = pokemon_param->GetMonsNo();
    pml::FormNo formno = pokemon_param->GetFormNo();
    pml::System::PersonalSystem()->LoadPersonalData( monsno, formno ); 
    u32 spdef = pokemon_param->GetPower( pml::pokepara::POWER_SPDEF );
    u32 spdef_rnd = pokemon_param->GetTalentPower( pml::pokepara::POWER_SPDEF );
    u32 spdef_exp = pokemon_param->GetEffortPower( pml::pokepara::POWER_SPDEF );
    u32 spdef_base = pml::System::PersonalSystem()->GetPersonalParam( pml::personal::PARAM_ID_basic_spdef );
    print::StrNumber( m_work_strbuf, spdef, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, spdef_rnd, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_RND_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, spdef_exp, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_EXP_VAL, m_work_strbuf );
    print::StrNumber( m_work_strbuf, spdef_base, 3, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANENAME_PAGE1_PANE_SPDEF_BASE_VAL, m_work_strbuf );
  }
  void DebugPokeMake::UpdateAllWaza( const pml::pokepara::PokemonParam* pokemon_param )
  {
    for( u32 i=0; i<pml::MAX_WAZA_NUM; i++ ) {
      DebugPokeMake::UpdateWaza( pokemon_param, i );
    }
  }
  void DebugPokeMake::UpdateWaza( const pml::pokepara::PokemonParam* pokemon_param, u32 waza_index )
  {
    WazaNo wazano = pokemon_param->GetWazaNo( waza_index );
    u32 up_count = pokemon_param->GetWazaPPUpCount( waza_index );
    u32 pp = pokemon_param->GetWazaPP( waza_index );
    u32 max_pp = pokemon_param->GetWazaMaxPP( waza_index );
    pml::System::WazaDataSystem()->GetWazaName( wazano, m_work_strbuf );
    DebugPokeMake::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_NAME[ waza_index ], m_work_strbuf );
    print::StrNumber( m_work_strbuf, up_count, 1, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_UP_VAL[ waza_index ], m_work_strbuf );
    print::StrNumber( m_work_strbuf, pp, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_PP_VAL[ waza_index ], m_work_strbuf );
    print::StrNumber( m_work_strbuf, max_pp, 2, print::NUM_DISP_SPACE, print::NUM_CODE_HANKAKU );
    DebugPokeMake::SetTextBoxPaneString( PANE_INDEX_OF_WAZA_PP_MAX[ waza_index ], m_work_strbuf );
  }







  // eLXg{bNXyCɕݒ肷
  void DebugPokeMake::SetTextBoxPaneString( gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::StrBuf* strbuf )
  {
    const gfl::str::STRCODE* strcode = strbuf->GetPtr();
    DebugPokeMake::SetTextBoxPaneString( pane_index, strcode );
  }

  // eLXg{bNXyCɕݒ肷
  void DebugPokeMake::SetTextBoxPaneString( gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::STRCODE* strcode )
  {
    gfl::grp::g2d::LytTextBox* text_box;
    text_box = m_layout_work->GetTextBoxPane( pane_index ); 
    GFL_ASSERT( text_box );
    if( text_box ) {
      text_box->SetString( strcode );
    }
  }




  void DebugPokeMake::StartAnimation( AnimationIndex animation_index )
  {
    if( m_layout_work->IsBindAnime( animation_index ) == false ) {
      m_layout_work->BindAnime( animation_index );
    }
    m_layout_work->SetAutoAnime( animation_index, true );
    m_layout_work->SetAnimeFrame( animation_index, 0 );
  }

  void DebugPokeMake::StopAnimation( AnimationIndex animation_index )
  {
    if( m_layout_work->IsBindAnime( animation_index ) ) {
      m_layout_work->UnBindAnime( animation_index );
    }
  }

  void DebugPokeMake::SetPaneVisibility( gfl::grp::g2d::LytPaneIndex pane_index, bool visible )
  {
    gfl::grp::g2d::LytPane* pane;
    pane = m_layout_work->GetPane( pane_index ); 
    GFL_ASSERT( pane );
    if( pane ) {
      pane->SetVisible( visible );
    }
  }





  gfl::heap::HeapBase* DebugPokeMake::m_heap = NULL;
  gfl::heap::HeapBase* DebugPokeMake::m_device_heap = NULL;
  gfl::str::StrBuf* DebugPokeMake::m_work_strbuf = NULL;
  gfl::grp::g2d::LytWk* DebugPokeMake::m_layout_work = NULL; 
  DebugPokeMake::Sequence DebugPokeMake::m_seq = DebugPokeMake::SEQ_WAIT;
  DebugPokeMake::NumberRegister* DebugPokeMake::m_number_register = NULL;
  DebugPokeMake::NumberBoxIndex DebugPokeMake::m_number_input_target = NUMBOX_NUM;


  DebugPokeMake::DebugPokeMake( void ) : 
    gamesystem::GameProc(),
    m_nw_heap_allocator( NULL ),
    m_nw_device_allocator( NULL ),
    m_graphics_system( NULL ),
    m_g3d_system( NULL ),
    m_layout_system( NULL ),
    m_ui_device_manager( NULL ),
    m_target_param( NULL ),
    m_clone_param( NULL ),
    m_button_manager( NULL )
  {
  }



  DebugPokeMake::~DebugPokeMake()
  {
  }



  void DebugPokeMake::SetMakeTarget( pml::pokepara::PokemonParam* poke_param )
  {
    m_target_param = poke_param;
  }

  pml::pokepara::PokemonParam* DebugPokeMake::GetCloneParam( void ) const
  {
    return m_clone_param;
  }



  gfl::proc::Result DebugPokeMake::InitFunc( gfl::proc::Manager* proc_manager )
  {
    GFL_ASSERT( m_target_param );

    gfl::heap::HeapBase* parent_app_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ); 
    gfl::heap::HeapBase* parent_dev_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
    size_t app_heap_size = parent_app_heap->GetTotalAllocatableSize();
    size_t dev_heap_size = parent_dev_heap->GetTotalAllocatableSize();
    m_heap = gfl::heap::Manager::CreateHeap( parent_app_heap, HEAPID_DEBUG_POKE_MAKE, app_heap_size, gfl::heap::HEAP_TYPE_EXP ); // @todo
    m_device_heap = gfl::heap::Manager::CreateHeap( parent_dev_heap, HEAPID_DEBUG_POKE_MAKE_DEVICE, dev_heap_size, gfl::heap::HEAP_TYPE_EXP );
    m_nw_heap_allocator = GFL_NEW( m_heap ) gfl::heap::NwAllocator( m_heap );
    m_nw_device_allocator = GFL_NEW( m_device_heap ) gfl::heap::NwAllocator( m_device_heap );
    m_work_strbuf = GFL_NEW( m_heap ) gfl::str::StrBuf( WORK_STRBUF_LENGTH, m_heap );

    const gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    m_ui_device_manager = game_manager->GetUiDeviceManager();
    m_graphics_system = game_manager->GetGraphicsSystem();
    m_graphics_system->InitializeApplicationMemory( m_nw_device_allocator );

    m_g3d_system = GFL_NEW( m_heap ) gfl::grp::g3d::System( m_nw_heap_allocator, m_nw_device_allocator );
    m_layout_system = GFL_NEW( m_heap ) gfl::grp::g2d::LytSys( &LAYOUT_SYSTEM_SETUP, m_nw_heap_allocator, m_nw_device_allocator ); 
    gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );

    gfl::fs::ArcFile arc_file( ARCID_DEBUG_POKEMAKE, m_heap );
    gfl::grp::g2d::LytResID layout_resource_id = m_layout_system->LoadLytRes( m_nw_device_allocator, &arc_file, GARC_debug_poke_make_debug_poke_make_LYTDAT );
    m_layout_system->TransferAllTexture( layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );
    m_layout_work = m_layout_system->CreateLytWk(
        layout_resource_id,
        LYTRES_DEBUG_POKE_MAKE_PAGE1_BCLYT,
        ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
        &gfl::grp::g2d::c_LytWkLowerDefaultSetUp,
        false );  // Aj[VoChȂ

    m_layout_work->CreateShareAnime( ANIMATION_ARROW_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_ARROW_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_ARROW_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_ARROW_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_ARROW_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_ARROW_SELECT ] );
    m_layout_work->CreateShareAnime( ANIMATION_SWITCH_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_SWITCH_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_SWITCH_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_SWITCH_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_SWITCH_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_SWITCH_SELECT ] );
    m_layout_work->CreateShareAnime( ANIMATION_STRBOX_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_STRBOX_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_STRBOX_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_STRBOX_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_STRBOX_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_STRBOX_SELECT ] );
    m_layout_work->CreateShareAnime( ANIMATION_NUMBOX_HOLD, ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUMBOX_HOLD ] );
    m_layout_work->CreateShareAnime( ANIMATION_NUMBOX_RELEASE, ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUMBOX_RELEASE ] );
    m_layout_work->CreateShareAnime( ANIMATION_NUMBOX_SELECT, ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUMBOX_SELECT ] );

    m_button_manager = GFL_NEW( m_heap ) app::tool::ButtonManager( m_heap, m_ui_device_manager, ARROW_NUM + SWITCH_NUM + STRBOX_NUM + NUMBOX_NUM );
    for( u32 i=0; i<ARROW_NUM; i++ ) {
      m_button_manager->AddButton( 
          m_heap, i, m_layout_work, 
          BUTTON_DESC_FOR_ARROW[i].pane_index,
          BUTTON_DESC_FOR_ARROW[i].hold_animation_index,
          BUTTON_DESC_FOR_ARROW[i].release_animation_index,
          BUTTON_DESC_FOR_ARROW[i].select_animation_index,
          BUTTON_DESC_FOR_ARROW[i].callback_on_select, this );
    }
    for( u32 i=0; i<SWITCH_NUM; i++ ) {
      m_button_manager->AddButton( 
          m_heap, i, m_layout_work, 
          BUTTON_DESC_FOR_SWITCH[i].pane_index,
          BUTTON_DESC_FOR_SWITCH[i].hold_animation_index,
          BUTTON_DESC_FOR_SWITCH[i].release_animation_index,
          BUTTON_DESC_FOR_SWITCH[i].select_animation_index,
          BUTTON_DESC_FOR_SWITCH[i].callback_on_select, this );
    }
    for( u32 i=0; i<STRBOX_NUM; i++ ) {
      m_button_manager->AddButton( 
          m_heap, i, m_layout_work, 
          BUTTON_DESC_FOR_STRBOX[i].pane_index,
          BUTTON_DESC_FOR_STRBOX[i].hold_animation_index,
          BUTTON_DESC_FOR_STRBOX[i].release_animation_index,
          BUTTON_DESC_FOR_STRBOX[i].select_animation_index,
          BUTTON_DESC_FOR_STRBOX[i].callback_on_select, this );
    }
    for( u32 i=0; i<NUMBOX_NUM; i++ ) {
      m_button_manager->AddButton( 
          m_heap, i, m_layout_work, 
          BUTTON_DESC_FOR_NUMBOX[i].pane_index,
          BUTTON_DESC_FOR_NUMBOX[i].hold_animation_index,
          BUTTON_DESC_FOR_NUMBOX[i].release_animation_index,
          BUTTON_DESC_FOR_NUMBOX[i].select_animation_index,
          BUTTON_DESC_FOR_NUMBOX[i].callback_on_select, this );
    }

    m_number_register = GFL_NEW( m_heap ) NumberRegister( m_ui_device_manager );

    pml::bridge::CtrAllocator allocator( m_heap );
    m_clone_param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_HUSIGIDANE, 5, 0 );
    m_clone_param->CopyFrom( m_target_param );
    m_clone_param->StartFastMode();

    UpdateMonsName( m_clone_param );
    UpdateFormNo( m_clone_param );
    UpdateType( m_clone_param );
    UpdateSex( m_clone_param );
    UpdateSeikaku( m_clone_param );
    UpdateItem( m_clone_param );
    UpdateTokusei( m_clone_param );
    UpdateLevel( m_clone_param );
    UpdateExp( m_clone_param );
    UpdateHp( m_clone_param );
    UpdateAtk( m_clone_param );
    UpdateDef( m_clone_param );
    UpdateAgi( m_clone_param );
    UpdateSpatk( m_clone_param );
    UpdateSpdef( m_clone_param ); 
    UpdateAllWaza( m_clone_param ); 

    return gfl::proc::RES_FINISH;
  }







  gfl::proc::Result DebugPokeMake::EndFunc( gfl::proc::Manager* proc_manager )
  {
    GFL_DELETE m_work_strbuf;
    GFL_DELETE m_button_manager;
    m_clone_param->EndFastMode( true );
    pml::System::PokeParaFactory()->DeletePokemonParam( m_clone_param );
    m_layout_system->RemoveLytWk( m_layout_work );
    GFL_DELETE m_layout_system;
    GFL_DELETE m_g3d_system;
    GFL_DELETE m_nw_heap_allocator;
    GFL_DELETE m_nw_device_allocator;
    gfl::heap::Manager::DeleteHeap( m_heap );
    gfl::heap::Manager::DeleteHeap( m_device_heap );
    return gfl::proc::RES_FINISH;
  }






  void DebugPokeMake::DrawFunc( gfl::proc::Manager* proc_manager )
  {
    gfl::grp::RenderTarget* lower_frame_buffer = m_graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
    m_layout_system->DrawAll( m_graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
  }




  gfl::proc::Result DebugPokeMake::UpdateFunc( gfl::proc::Manager* proc_manager )
  {
    switch( m_seq )
    {
    case SEQ_WAIT:
      m_button_manager->Update();
      break;

    case SEQ_NUM_INPUT:
      if( m_number_register->Update() == false ) {
        DebugPokeMake::OnNumberInputFinished( m_number_input_target, m_clone_param );
        DebugPokeMake::SetPaneVisibility( PANENAME_PAGE1_PANE_NUM_INPUT, false );
        m_seq = SEQ_WAIT;
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }

    m_layout_system->UpdateAll();
    return gfl::proc::RES_CONTINUE;
  }














} // namespace debug 
