//=================================================================================================
/**
 * @file DebugPokeMake.h
 * @brief fobO|P쐬
 * @author obata_toshihiro
 * @date 2011.07.07
 */
//=================================================================================================
#ifndef __DEBUGPOKEMAKE_H__
#define __DEBUGPOKEMAKE_H__
#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <app/tool/app_tool_ButtonManager.h>


namespace debug {


  class DebugPokeMake : public gamesystem::GameProc
  {
    GFL_FORBID_COPY_AND_ASSIGN( DebugPokeMake );

    public:

    DebugPokeMake( void );
    virtual ~DebugPokeMake(); 
    virtual gfl::proc::Result InitFunc( gfl::proc::Manager* proc_manager );
    virtual gfl::proc::Result EndFunc( gfl::proc::Manager* proc_manager );
    virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager* proc_manager );
    virtual void DrawFunc( gfl::proc::Manager* proc_manager );
    void SetMakeTarget( pml::pokepara::PokemonParam* poke_param );
    pml::pokepara::PokemonParam* GetCloneParam( void ) const;

    private:
    enum Sequence {
      SEQ_WAIT,
      SEQ_NUM_INPUT,
      SEQ_NUM,
    };
    enum ArrowIndex {
      ARROW_MONSNO_L,
      ARROW_MONSNO_R,
      ARROW_FORMNO_L,
      ARROW_FORMNO_R,
      ARROW_SEIKAKU_L,
      ARROW_SEIKAKU_R,
      ARROW_ITEM_L,
      ARROW_ITEM_R,
      ARROW_TOKUSEI_L,
      ARROW_TOKUSEI_R,
      ARROW_WAZA1_L,
      ARROW_WAZA1_R,
      ARROW_WAZA2_L,
      ARROW_WAZA2_R,
      ARROW_WAZA3_L,
      ARROW_WAZA3_R,
      ARROW_WAZA4_L,
      ARROW_WAZA4_R,
      ARROW_NUM,
    };
    enum SwitchIndex {
      SWITCH_SEX,
      SWITCH_TOKUSEI1,
      SWITCH_TOKUSEI2,
      SWITCH_TOKUSEI3,
      SWITCH_DEFAULT_WAZA,
      SWITCH_HATAKU,
      SWITCH_HANERU,
      SWITCH_NUM,
    };
    enum StringBoxIndex {
      STRBOX_MONSNAME,
      STRBOX_SEIKAKU,
      STRBOX_ITEM,
      STRBOX_TOKUSEI,
      STRBOX_WAZA1,
      STRBOX_WAZA2,
      STRBOX_WAZA3,
      STRBOX_WAZA4,
      STRBOX_NUM,
    };
    enum NumberBoxIndex {
      NUMBOX_FORMNO,
      NUMBOX_LEVEL,
      NUMBOX_EXP,
      NUMBOX_HP_RND,
      NUMBOX_HP_EXP,
      NUMBOX_ATK_RND,
      NUMBOX_ATK_EXP,
      NUMBOX_DEF_RND,
      NUMBOX_DEF_EXP,
      NUMBOX_AGI_RND,
      NUMBOX_AGI_EXP,
      NUMBOX_SPATK_RND,
      NUMBOX_SPATK_EXP,
      NUMBOX_SPDEF_RND,
      NUMBOX_SPDEF_EXP,
      NUMBOX_WAZA1_UP,
      NUMBOX_WAZA1_PP,
      NUMBOX_WAZA2_UP,
      NUMBOX_WAZA2_PP,
      NUMBOX_WAZA3_UP,
      NUMBOX_WAZA3_PP,
      NUMBOX_WAZA4_UP,
      NUMBOX_WAZA4_PP,
      NUMBOX_NUM,
    };
    enum AnimationDataIndex {
      ANIMATION_DATA_ARROW_HOLD,
      ANIMATION_DATA_ARROW_RELEASE,
      ANIMATION_DATA_ARROW_SELECT,
      ANIMATION_DATA_SWITCH_HOLD,
      ANIMATION_DATA_SWITCH_RELEASE,
      ANIMATION_DATA_SWITCH_SELECT,
      ANIMATION_DATA_STRBOX_HOLD,
      ANIMATION_DATA_STRBOX_RELEASE,
      ANIMATION_DATA_STRBOX_SELECT,
      ANIMATION_DATA_NUMBOX_HOLD,
      ANIMATION_DATA_NUMBOX_RELEASE,
      ANIMATION_DATA_NUMBOX_SELECT,
      ANIMATION_DATA_NUM_INPUT_PLACE_1,
      ANIMATION_DATA_NUM_INPUT_PLACE_2,
      ANIMATION_DATA_NUM_INPUT_PLACE_3,
      ANIMATION_DATA_NUM_INPUT_PLACE_4,
      ANIMATION_DATA_NUM_INPUT_PLACE_5,
      ANIMATION_DATA_NUM_INPUT_PLACE_6,
      ANIMATION_DATA_NUM_INPUT_PLACE_7,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_FORMNO,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_LEVEL,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_EXP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_HP_RND,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_HP_EXP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_ATK_RND,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_ATK_EXP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_DEF_RND,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_DEF_EXP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_AGI_RND,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_AGI_EXP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_SPATK_RND,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_SPATK_EXP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_SPDEF_RND,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_SPDEF_EXP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA1_UP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA1_PP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA2_UP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA2_PP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA3_UP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA3_PP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA4_UP,
      ANIMATION_DATA_NUM_INPUT_BOX_ON_WAZA4_PP,
      ANIMATION_DATA_NUM,
    };
    enum AnimationIndex {
      DUMMY_ANIMATION_DATA_ARROW_HOLD,
      DUMMY_ANIMATION_DATA_ARROW_RELEASE,
      DUMMY_ANIMATION_DATA_ARROW_SELECT,
      DUMMY_ANIMATION_DATA_SWITCH_HOLD,
      DUMMY_ANIMATION_DATA_SWITCH_RELEASE,
      DUMMY_ANIMATION_DATA_SWITCH_SELECT,
      DUMMY_ANIMATION_DATA_STRBOX_HOLD,
      DUMMY_ANIMATION_DATA_STRBOX_RELEASE,
      DUMMY_ANIMATION_DATA_STRBOX_SELECT,
      DUMMY_ANIMATION_DATA_NUMBOX_HOLD,
      DUMMY_ANIMATION_DATA_NUMBOX_RELEASE,
      DUMMY_ANIMATION_DATA_NUMBOX_SELECT,
      ANIMATION_NUM_INPUT_PLACE_1,
      ANIMATION_NUM_INPUT_PLACE_2,
      ANIMATION_NUM_INPUT_PLACE_3,
      ANIMATION_NUM_INPUT_PLACE_4,
      ANIMATION_NUM_INPUT_PLACE_5,
      ANIMATION_NUM_INPUT_PLACE_6,
      ANIMATION_NUM_INPUT_PLACE_7,
      ANIMATION_NUM_INPUT_BOX_ON_FORMNO,
      ANIMATION_NUM_INPUT_BOX_ON_LEVEL,
      ANIMATION_NUM_INPUT_BOX_ON_EXP,
      ANIMATION_NUM_INPUT_BOX_ON_HP_RND,
      ANIMATION_NUM_INPUT_BOX_ON_HP_EXP,
      ANIMATION_NUM_INPUT_BOX_ON_ATK_RND,
      ANIMATION_NUM_INPUT_BOX_ON_ATK_EXP,
      ANIMATION_NUM_INPUT_BOX_ON_DEF_RND,
      ANIMATION_NUM_INPUT_BOX_ON_DEF_EXP,
      ANIMATION_NUM_INPUT_BOX_ON_AGI_RND,
      ANIMATION_NUM_INPUT_BOX_ON_AGI_EXP,
      ANIMATION_NUM_INPUT_BOX_ON_SPATK_RND,
      ANIMATION_NUM_INPUT_BOX_ON_SPATK_EXP,
      ANIMATION_NUM_INPUT_BOX_ON_SPDEF_RND,
      ANIMATION_NUM_INPUT_BOX_ON_SPDEF_EXP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA1_UP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA1_PP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA2_UP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA2_PP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA3_UP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA3_PP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA4_UP,
      ANIMATION_NUM_INPUT_BOX_ON_WAZA4_PP,
      // ȉ, LAj[V
      ANIMATION_ARROW_HOLD,
      ANIMATION_ARROW_RELEASE = ANIMATION_ARROW_HOLD + ARROW_NUM,
      ANIMATION_ARROW_SELECT = ANIMATION_ARROW_RELEASE + ARROW_NUM,
      ANIMATION_SWITCH_HOLD = ANIMATION_ARROW_SELECT + ARROW_NUM,
      ANIMATION_SWITCH_RELEASE = ANIMATION_SWITCH_HOLD + SWITCH_NUM,
      ANIMATION_SWITCH_SELECT = ANIMATION_SWITCH_RELEASE + SWITCH_NUM,
      ANIMATION_STRBOX_HOLD = ANIMATION_SWITCH_SELECT + SWITCH_NUM,
      ANIMATION_STRBOX_RELEASE = ANIMATION_STRBOX_HOLD + STRBOX_NUM,
      ANIMATION_STRBOX_SELECT = ANIMATION_STRBOX_RELEASE + STRBOX_NUM,
      ANIMATION_NUMBOX_HOLD = ANIMATION_STRBOX_SELECT + STRBOX_NUM,
      ANIMATION_NUMBOX_RELEASE = ANIMATION_NUMBOX_HOLD + NUMBOX_NUM,
      ANIMATION_NUMBOX_SELECT = ANIMATION_NUMBOX_RELEASE + NUMBOX_NUM,
      ANIMATION_NUM = ANIMATION_NUMBOX_SELECT + NUMBOX_NUM,
    };
    struct ButtonDesc {
      gfl::grp::g2d::LytPaneIndex pane_index;
      AnimationIndex hold_animation_index;
      AnimationIndex release_animation_index;
      AnimationIndex select_animation_index;
      app::tool::ButtonManager::CallbackFunc callback_on_select;
      AnimationIndex animation_index_of_num_input_position_set;
    };
    static const gfl::grp::g2d::LytSysSetUp LAYOUT_SYSTEM_SETUP; 
    static const u32 WORK_STRBUF_LENGTH;
    static const gfl::str::STRCODE* TYPE_NAME[ POKETYPE_MAX ];
    static const gfl::str::STRCODE* SEX_NAME[ pml::SEX_NUM ];
    static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
    static const gfl::grp::g2d::LytPaneIndex PANE_INDEX_OF_WAZA_NAME[ pml::MAX_WAZA_NUM ];
    static const gfl::grp::g2d::LytPaneIndex PANE_INDEX_OF_WAZA_UP_VAL[ pml::MAX_WAZA_NUM ];
    static const gfl::grp::g2d::LytPaneIndex PANE_INDEX_OF_WAZA_PP_VAL[ pml::MAX_WAZA_NUM ];
    static const gfl::grp::g2d::LytPaneIndex PANE_INDEX_OF_WAZA_PP_MAX[ pml::MAX_WAZA_NUM ];
    static const ButtonDesc BUTTON_DESC_FOR_ARROW[ ARROW_NUM ];
    static const ButtonDesc BUTTON_DESC_FOR_SWITCH[ SWITCH_NUM ];
    static const ButtonDesc BUTTON_DESC_FOR_STRBOX[ STRBOX_NUM ];
    static const ButtonDesc BUTTON_DESC_FOR_NUMBOX[ NUMBOX_NUM ];
    static gfl::heap::HeapBase* m_heap;
    static gfl::heap::HeapBase* m_device_heap;
    static gfl::str::StrBuf* m_work_strbuf;
    static gfl::grp::g2d::LytWk* m_layout_work;
    static Sequence m_seq;
    static void OnArrowSelected( app::tool::ButtonManager::ButtonId arrow_index, void* work );
    static void OnSwitchSelected( app::tool::ButtonManager::ButtonId switch_index, void* work );
    static void OnStrBoxSelected( app::tool::ButtonManager::ButtonId strbox_index, void* work );
    static void OnNumBoxSelected( app::tool::ButtonManager::ButtonId numbox_index, void* work );
    static void OnNumberInputFinished( NumberBoxIndex numbox_index, pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateMonsName( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateFormNo( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateType( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateSex( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateSeikaku( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateItem( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateTokusei( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateLevel( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateExp( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateHp( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateAtk( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateDef( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateAgi( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateSpatk( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateSpdef( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateAllWaza( const pml::pokepara::PokemonParam* pokemon_param );
    static void UpdateWaza( const pml::pokepara::PokemonParam* pokemon_param, u32 waza_index ); 
    static void SetTextBoxPaneString( gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::StrBuf* strbuf );
    static void SetTextBoxPaneString( gfl::grp::g2d::LytPaneIndex pane_index, const gfl::str::STRCODE* strcode );
    static void StartAnimation( AnimationIndex animation_index );
    static void StopAnimation( AnimationIndex animation_index );
    static void SetPaneVisibility( gfl::grp::g2d::LytPaneIndex pane_index, bool visible );

    class NumberRegister {
      public:
        NumberRegister( const gfl::ui::DeviceManager* ui_device_manager );
        ~NumberRegister();
        bool Update( void );
        void Reset( u32 max_value, u32 init_value );
        u32 GetValue( void );
      private:
        static const u32 NUMBOX_PLACE_NUM = 7;
        static const gfl::grp::g2d::LytPaneIndex PANE_INDEX_OF_NUMBOX_PLACE_VALUE[ NUMBOX_PLACE_NUM ];
        static const AnimationIndex ANIMATION_INDEX_OF_NUMBOX_PLACE[ NUMBOX_PLACE_NUM ];
        const gfl::ui::DeviceManager* m_ui_device_manager;
        u32 m_max_value;
        u32 m_value;
        u32 m_max_place;
        u32 m_current_place;
        u32 GetPlaceNumber( u32 value, u32 place );
    };
    static NumberRegister* m_number_register;
    static NumberBoxIndex m_number_input_target;


    gfl::heap::NwAllocator* m_nw_heap_allocator;
    gfl::heap::NwAllocator* m_nw_device_allocator;
    gfl::grp::GraphicsSystem* m_graphics_system;
    gfl::grp::g3d::System* m_g3d_system;
    gfl::grp::g2d::LytSys* m_layout_system;
    const gfl::ui::DeviceManager* m_ui_device_manager;
    pml::pokepara::PokemonParam* m_target_param;
    pml::pokepara::PokemonParam* m_clone_param;
    app::tool::ButtonManager* m_button_manager;

  };


} // namespace debug 


#endif // __DEBUGPOKEMAKE_H__
