//======================================================================
/**
 * @file    DebugBtl.h
 * @brief   fobOogProc
 * @author  taya
 * @data    2011/07/07
 */
//======================================================================
#ifndef __DEBUG_BTL_H__
#define __DEBUG_BTL_H__

#include <gfl_Common.h>
#include <gfl_Grp.h>
#include <gfl_Heap.h>

#include "gamesystem\GameProc.h"

namespace test { namespace taya {

class DebugBtlProc : public gamesystem::GameProc
{
  GFL_FORBID_COPY_AND_ASSIGN( DebugBtlProc );

public:
  DebugBtlProc( void );
  ~DebugBtlProc();

  virtual gfl::proc::Result InitFunc( gfl::proc::Manager* pManager );
  virtual gfl::proc::Result EndFunc( gfl::proc::Manager* pManager );
  virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager* pManager );
  virtual void DrawFunc( gfl::proc::Manager* pManager );

  inline void  SetupParam( gfl::heap::HeapBase* heapSys,  gfl::heap::HeapBase* heapDev )
  {
    m_sysHeapBase = heapSys;
    m_devHeapBase = heapDev;
  }

private:
  gfl::heap::HeapBase* m_sysHeapBase;
  gfl::heap::HeapBase* m_devHeapBase;
  gfl::heap::HeapBase* m_sysHeap;
  gfl::heap::HeapBase* m_devHeap;

  gfl::grp::GraphicsSystem*   m_graphicSys;
  gfl::heap::NwAllocator*     m_sysAllocator;
  gfl::heap::NwAllocator*     m_devAllocator;
  gfl::fs::ArcFile*           m_pArcRes;
  gfl::grp::g2d::LytSys*      m_lytSys;
  gfl::grp::g2d::LytWk*       m_lytWk;

  gfl::ui::DeviceManager*     m_uiMan;
  gfl::ui::VectorDevice*      m_uiKey;
  gfl::ui::Button*            m_uiButton;

  void  initGraphicSystem( void );
  void  quitGraphicSystem( void );
  void  init2D( void );
  void  quit2D( void );

  void  drawLyt( void );
  bool  keyControl( void );
  bool  checkKeyForItemSelect( void );

  u32   m_page;
  u32   m_pointIndex;
  gfl::grp::g2d::LytTextBox*  m_currentPane;

  void resetSelectPane( gfl::grp::g2d::LytTextBox* pPane );
  void setSelectPane( gfl::grp::g2d::LytTextBox* pPane );



};  // class DebugBtlProc

}}  // end of namespace

#endif  // #ifndef __DEBUG_BTL_H__

