//======================================================================
/**
 * @file    DebugBtl.cpp
 * @brief   fobOogProc
 * @author  taya
 * @data    2011/07/07
 */
//======================================================================

#include  "DebugBtl.h"

#include "BtlDebugRes.h"
#include "BtlDebugRes_pane.h"
#include "BtlDebugRes.gaix"


namespace test { namespace taya {

/**
 *  RXgN^EfXgN^
 */
DebugBtlProc::DebugBtlProc( void ) :
  m_sysHeapBase(NULL),
  m_devHeapBase(NULL),
  m_sysHeap(NULL),
  m_devHeap(NULL),
  m_page(0),
  m_pointIndex(PANENAME_BTLDEBUG_PANE_TEXT_P1_1)
{
}
DebugBtlProc::~DebugBtlProc( )
{
}


//---------------------------------------------------------------
/**
 *  PROC Jn
 */
//---------------------------------------------------------------
gfl::proc::Result DebugBtlProc::InitFunc( gfl::proc::Manager*  )
{
  if( (m_sysHeapBase != NULL)
  &&  (m_devHeapBase != NULL)
  ){
    m_sysHeap  = gfl::heap::Manager::CreateHeap( m_sysHeapBase, HEAPID_BATTLE_SYS,  0x200000,
                        gfl::heap::HEAP_TYPE_EXP, false );

    m_devHeap  = gfl::heap::Manager::CreateHeap( m_devHeapBase, HEAPID_BATTLE_DEVICE, 0x1000000,
                        gfl::heap::HEAP_TYPE_EXP, false );

    m_uiMan = mpGameProcManager->GetGameManager()->GetUiDeviceManager();
    m_uiButton = m_uiMan->GetButton( 0 );
    m_uiKey    = m_uiMan->GetCrossKey( 0 );

    this->initGraphicSystem();
    this->init2D();
//    gfl::grp::Fade_RequestIn();
  }
  else
  {
    GFL_ASSERT(0);
  }
  return gfl::proc::RES_FINISH;
}
//---------------------------------------------------------------
/**
 *  PROC I
 */
//---------------------------------------------------------------
gfl::proc::Result DebugBtlProc::EndFunc( gfl::proc::Manager*  )
{
  this->quit2D();
  this->quitGraphicSystem();
  gfl::heap::Manager::DeleteHeap( m_devHeap );
  gfl::heap::Manager::DeleteHeap( m_sysHeap );
  return gfl::proc::RES_FINISH;
}

/**
 *  GraphicsSystem 
 */
void DebugBtlProc::initGraphicSystem( void )
{
  // AP[^
  m_sysAllocator   = GFL_NEW(m_sysHeap)  gfl::heap::NwAllocator(m_sysHeap);
  m_devAllocator   = GFL_NEW(m_devHeap)  gfl::heap::NwAllocator(m_devHeap);

  // OtBbNXVXe
#if 0
  gfl::grp::GraphicsSystemSetUp setup = gfl::grp::GraphicsSystemSetupDefault;
  setup.useUpperRight = true;   // ̎
  setup.stereoOn      = true;  // ftHg̎It
  m_graphicSys   = GFL_NEW(m_sysHeap) gfl::grp::GraphicsSystem( m_sysAllocator, m_devAllocator, &setup );
#else
  m_graphicSys   = mpGameProcManager->GetGameManager()->GetGraphicsSystem();
  m_graphicSys->InitializeApplicationMemory( m_devAllocator );
#endif
}
/**
 *  GraphicsSystem I
 */
void DebugBtlProc::quitGraphicSystem( void )
{
  if( m_graphicSys ){
//    GFL_DELETE  m_graphicSys;
    m_graphicSys->FinalizeApplicationMemory();
    m_graphicSys = NULL;
  }
  if( m_devAllocator ){
    GFL_DELETE  m_devAllocator;
    m_devAllocator = NULL;
  }
  if( m_sysAllocator ){
    GFL_DELETE  m_sysAllocator;
    m_sysAllocator = NULL;
  }
}
/**
 *  2D\[X
 */
void DebugBtlProc::init2D( void )
{
  // CAEgVXe
  {
    const gfl::grp::g2d::LytSysSetUp SetUp = {
      10, // lyt_resource_max
      10  // lyt_wk_max
    };

    m_lytSys = GFL_NEW(m_sysHeap) gfl::grp::g2d::LytSys( &SetUp, m_sysAllocator, m_devAllocator );

    // \[Xǂݍ
    m_pArcRes = GFL_NEW_LOW(m_sysHeap) gfl::fs::ArcFile( L"rom:/BtlDebugRes.garc", m_sysHeap );
    u32 resID = m_lytSys->LoadLytRes( m_devAllocator, m_pArcRes, GARC_BtlDebugRes_BtlDebugRes_LYTDAT );

    // CAEg[N
    gfl::grp::g2d::LytWkSetUp setup = {
      gfl::math::VEC3(0,0,0),
      gfl::math::VEC2(1.0f,1.0f),
      gfl::math::VEC3(0,0,0),
      0,
      0,
    };

    m_lytWk  = m_lytSys->CreateLytWk( resID, LYTRES_BTLDEBUGRES_BTLDEBUG_BCLYT, NULL, 0, 0, &setup );
    m_currentPane = m_lytWk->GetTextBoxPane( m_pointIndex );
    setSelectPane( m_currentPane );
  }

  m_lytWk->SetAutoDrawFlag( false );
}

/**
 *  2D\[Xj
 */
void DebugBtlProc::quit2D( void )
{
  if( m_pArcRes ){
    GFL_DELETE( m_pArcRes );
  }

  if( m_lytSys )
  {
    if( m_lytWk )
    {
      m_lytSys->RemoveLytWk( m_lytWk );
      m_lytWk = NULL;
    }

    GFL_DELETE  m_lytSys;
    m_lytSys = NULL;
  }
}



//----------------------------------------------------------------------------------------------
/**
 *  PROC Main
 */
//----------------------------------------------------------------------------------------------
gfl::proc::Result DebugBtlProc::UpdateFunc( gfl::proc::Manager*  )
{
  if( !this->keyControl() ){
    return gfl::proc::RES_FINISH;
  }

  // CAEgAj[VXV
  m_lytSys->UpdateAll();

  return gfl::proc::RES_CONTINUE;
}
void DebugBtlProc::DrawFunc( gfl::proc::Manager*  )
{
  this->drawLyt();
}

/**
 *  Layout system `
 */
void DebugBtlProc::drawLyt( void )
{
  gfl::grp::RenderTarget* upperFrameBuffer = m_graphicSys->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
  gfl::grp::RenderTarget* rightFrameBuffer = m_graphicSys->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );
  gfl::grp::RenderTarget* lowerFrameBuffer = m_graphicSys->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );

#if 0
  m_lytSys->DrawAll( m_graphicSys, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
#else
  m_lytWk->Draw( m_graphicSys, gfl::grp::DISPLAY_UPPER,       upperFrameBuffer );
  m_lytWk->Draw( m_graphicSys, gfl::grp::DISPLAY_UPPER_RIGHT, rightFrameBuffer );
//  m_lytWk[1]->Draw( m_graphicSys, gfl::grp::DISPLAY_LOWER,       lowerFrameBuffer );
#endif
}

/**
 *  Key 
 */
bool DebugBtlProc::keyControl( void )
{
  if( this->checkKeyForItemSelect() )
  {
    resetSelectPane( m_currentPane );
    m_currentPane = m_lytWk->GetTextBoxPane( m_pointIndex );
    setSelectPane( m_currentPane );
  }
  return true;
}
/**
 *  L[`FbNIACe̕ύXǂԂ
 */
bool DebugBtlProc::checkKeyForItemSelect( void )
{
  enum {
    KEY_NONE, KEY_L, KEY_R, KEY_U, KEY_D
  };

  static const struct {
    u16  cur;
    u16  l, r, u, d;
  }keyTrans[] = {
    {
      PANENAME_BTLDEBUG_PANE_TEXT_P1_1,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_1, PANENAME_BTLDEBUG_PANE_TEXT_P2_1,
      PANENAME_BTLDEBUG_PANE_TEXT_BADGECOUNT, PANENAME_BTLDEBUG_PANE_TEXT_P1_2,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P1_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_2, PANENAME_BTLDEBUG_PANE_TEXT_P2_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_1, PANENAME_BTLDEBUG_PANE_TEXT_P1_3,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P1_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_3, PANENAME_BTLDEBUG_PANE_TEXT_P2_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_2, PANENAME_BTLDEBUG_PANE_TEXT_P1_4,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P1_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_4, PANENAME_BTLDEBUG_PANE_TEXT_P2_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_3, PANENAME_BTLDEBUG_PANE_TEXT_P1_5,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P1_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_5, PANENAME_BTLDEBUG_PANE_TEXT_P2_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_4, PANENAME_BTLDEBUG_PANE_TEXT_P1_6,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P1_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_6, PANENAME_BTLDEBUG_PANE_TEXT_P2_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_5, PANENAME_BTLDEBUG_PANE_TEXT_BTLMODE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P2_1,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_1, PANENAME_BTLDEBUG_PANE_TEXT_P3_1,
      PANENAME_BTLDEBUG_PANE_TEXT_BADGECOUNT, PANENAME_BTLDEBUG_PANE_TEXT_P2_2,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P2_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_2, PANENAME_BTLDEBUG_PANE_TEXT_P3_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_1, PANENAME_BTLDEBUG_PANE_TEXT_P2_3,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P2_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_3, PANENAME_BTLDEBUG_PANE_TEXT_P3_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_2, PANENAME_BTLDEBUG_PANE_TEXT_P2_4,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P2_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_4, PANENAME_BTLDEBUG_PANE_TEXT_P3_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_3, PANENAME_BTLDEBUG_PANE_TEXT_P2_5,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P2_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_5, PANENAME_BTLDEBUG_PANE_TEXT_P3_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_4, PANENAME_BTLDEBUG_PANE_TEXT_P2_6,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P2_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_6, PANENAME_BTLDEBUG_PANE_TEXT_P3_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_5, PANENAME_BTLDEBUG_PANE_TEXT_BTLMODE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P3_1,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_1, PANENAME_BTLDEBUG_PANE_TEXT_P4_1,
      PANENAME_BTLDEBUG_PANE_TEXT_LOAD, PANENAME_BTLDEBUG_PANE_TEXT_P3_2,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P3_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_2, PANENAME_BTLDEBUG_PANE_TEXT_P4_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_1, PANENAME_BTLDEBUG_PANE_TEXT_P3_3,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P3_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_3, PANENAME_BTLDEBUG_PANE_TEXT_P4_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_2, PANENAME_BTLDEBUG_PANE_TEXT_P3_4,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P3_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_4, PANENAME_BTLDEBUG_PANE_TEXT_P4_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_3, PANENAME_BTLDEBUG_PANE_TEXT_P3_5,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P3_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_5, PANENAME_BTLDEBUG_PANE_TEXT_P4_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_4, PANENAME_BTLDEBUG_PANE_TEXT_P3_6,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P3_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P2_6, PANENAME_BTLDEBUG_PANE_TEXT_P4_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_5, PANENAME_BTLDEBUG_PANE_TEXT_COMMMODE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P4_1,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_1, PANENAME_BTLDEBUG_PANE_TEXT_P1_1,
      PANENAME_BTLDEBUG_PANE_TEXT_SAVE, PANENAME_BTLDEBUG_PANE_TEXT_P4_2,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P4_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_2, PANENAME_BTLDEBUG_PANE_TEXT_P1_2,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_1, PANENAME_BTLDEBUG_PANE_TEXT_P4_3,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P4_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_3, PANENAME_BTLDEBUG_PANE_TEXT_P1_3,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_2, PANENAME_BTLDEBUG_PANE_TEXT_P4_4,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P4_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_4, PANENAME_BTLDEBUG_PANE_TEXT_P1_4,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_3, PANENAME_BTLDEBUG_PANE_TEXT_P4_5,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P4_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_5, PANENAME_BTLDEBUG_PANE_TEXT_P1_5,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_4, PANENAME_BTLDEBUG_PANE_TEXT_P4_6,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_P4_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P3_6, PANENAME_BTLDEBUG_PANE_TEXT_P1_6,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_5, PANENAME_BTLDEBUG_PANE_TEXT_COMMMODE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_BTLMODE,
      PANENAME_BTLDEBUG_PANE_TEXT_COMMMODE, PANENAME_BTLDEBUG_PANE_TEXT_COMMMODE,
      PANENAME_BTLDEBUG_PANE_TEXT_P1_5,     PANENAME_BTLDEBUG_PANE_TEXT_MSGSPEED,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_MSGSPEED,
      PANENAME_BTLDEBUG_PANE_TEXT_EFFENABLE, PANENAME_BTLDEBUG_PANE_TEXT_EFFENABLE,
      PANENAME_BTLDEBUG_PANE_TEXT_BTLMODE,   PANENAME_BTLDEBUG_PANE_TEXT_CHANGERULE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_CHANGERULE,
      PANENAME_BTLDEBUG_PANE_TEXT_RECIDX,    PANENAME_BTLDEBUG_PANE_TEXT_RECMODE,
      PANENAME_BTLDEBUG_PANE_TEXT_MSGSPEED,  PANENAME_BTLDEBUG_PANE_TEXT_BADGECOUNT,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_BADGECOUNT,
      PANENAME_BTLDEBUG_PANE_TEXT_SAVE,       PANENAME_BTLDEBUG_PANE_TEXT_LOAD,
      PANENAME_BTLDEBUG_PANE_TEXT_CHANGERULE, PANENAME_BTLDEBUG_PANE_TEXT_P1_1,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_COMMMODE,
      PANENAME_BTLDEBUG_PANE_TEXT_BTLMODE,    PANENAME_BTLDEBUG_PANE_TEXT_BTLMODE,
      PANENAME_BTLDEBUG_PANE_TEXT_P4_5,       PANENAME_BTLDEBUG_PANE_TEXT_EFFENABLE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_EFFENABLE,
      PANENAME_BTLDEBUG_PANE_TEXT_MSGSPEED,   PANENAME_BTLDEBUG_PANE_TEXT_MSGSPEED,
      PANENAME_BTLDEBUG_PANE_TEXT_COMMMODE,   PANENAME_BTLDEBUG_PANE_TEXT_RECMODE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_RECMODE,
      PANENAME_BTLDEBUG_PANE_TEXT_CHANGERULE,  PANENAME_BTLDEBUG_PANE_TEXT_RECIDX,
      PANENAME_BTLDEBUG_PANE_TEXT_EFFENABLE,   PANENAME_BTLDEBUG_PANE_TEXT_LOAD,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_RECIDX,
      PANENAME_BTLDEBUG_PANE_TEXT_RECMODE,     PANENAME_BTLDEBUG_PANE_TEXT_CHANGERULE,
      PANENAME_BTLDEBUG_PANE_TEXT_EFFENABLE,   PANENAME_BTLDEBUG_PANE_TEXT_SAVE,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_SAVE,
      PANENAME_BTLDEBUG_PANE_TEXT_LOAD,     PANENAME_BTLDEBUG_PANE_TEXT_BADGECOUNT,
      PANENAME_BTLDEBUG_PANE_TEXT_RECIDX,   PANENAME_BTLDEBUG_PANE_TEXT_P4_1,
    },{
      PANENAME_BTLDEBUG_PANE_TEXT_LOAD,
      PANENAME_BTLDEBUG_PANE_TEXT_BADGECOUNT,    PANENAME_BTLDEBUG_PANE_TEXT_SAVE,
      PANENAME_BTLDEBUG_PANE_TEXT_RECMODE,       PANENAME_BTLDEBUG_PANE_TEXT_P4_1,
    },
  };

  u32 key = KEY_NONE;
  do {
    if( m_uiKey->IsTrigger(gfl::ui::DIR_LEFT) ) { key = KEY_L; break; }
    if( m_uiKey->IsTrigger(gfl::ui::DIR_RIGHT) ){ key = KEY_R; break; }
    if( m_uiKey->IsTrigger(gfl::ui::DIR_UP) )   { key = KEY_U; break; }
    if( m_uiKey->IsTrigger(gfl::ui::DIR_DOWN) ) { key = KEY_D; break; }
  }while(0);

  if( key != KEY_NONE )
  {
    for(u32 i=0; i<GFL_NELEMS(keyTrans); ++i)
    {
      if( keyTrans[i].cur == m_pointIndex )
      {
        u32 nextIndex = m_pointIndex;
        switch( key ){
        case KEY_L: nextIndex = keyTrans[i].l; break;
        case KEY_R: nextIndex = keyTrans[i].r; break;
        case KEY_U: nextIndex = keyTrans[i].u; break;
        case KEY_D: nextIndex = keyTrans[i].d; break;
        }
        if( nextIndex != m_pointIndex ){
          m_pointIndex = nextIndex;
          return true;
        }
        break;
      }
    }
  }

  return false;

}

// I͂ꂽPane̕`FύX
void DebugBtlProc::resetSelectPane( gfl::grp::g2d::LytTextBox* pPane )
{
  nw::ut::Color8 colorU( 154, 154, 154, 255 );
  nw::ut::Color8 colorD( 0, 0, 0, 255 );
  pPane->SetTextColor( colorU, colorD );
}
// IꂽPane̕`FύX
void DebugBtlProc::setSelectPane( gfl::grp::g2d::LytTextBox* pPane )
{
  nw::ut::Color8 color( 255, 64, 64, 255 );
  pPane->SetTextColor( color, color );
}

}}
