//=============================================================================
/**
 *
 *	@file		FieldActionCmdDrawFlag.h
 *	@brief  `ntO ANVR}h
 *	@author hosaka genya
 *	@data		2011.07.07
 *
 */
//=============================================================================
#ifndef __FIELDACTIONCMDDRAWFLAG_H__
#define __FIELDACTIONCMDDRAWFLAG_H__

#include "FieldActionCmdBase.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );


//--------------------------------------------------------------
///	VANISH ON
//==============================================================
class ActionCmdVanishON : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdVanishON );
public :
  ActionCmdVanishON( void );
  virtual ~ActionCmdVanishON(){}
  virtual Acmd GetAcmdID( void ) const { return AC_VANISH_ON; }
private:
  static ActionCmdBase::AcmdRet AcVanishONInit( ActionCmdBase::ActionCmdWork* p_work );
};

//--------------------------------------------------------------
///	VANISH OFF
//==============================================================
class ActionCmdVanishOFF : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdVanishOFF );
public :
  ActionCmdVanishOFF( void );
  virtual ~ActionCmdVanishOFF(){}
  virtual Acmd GetAcmdID( void ) const { return AC_VANISH_OFF; }
private:
  static ActionCmdBase::AcmdRet AcVanishOFFInit( ActionCmdBase::ActionCmdWork* p_work );
};

//--------------------------------------------------------------
///	PAUSE DIR ON
//==============================================================
class ActionCmdPauseDirON : public ActionCmdBase
{
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdPauseDirON );
public :
  ActionCmdPauseDirON( void );
  virtual ~ActionCmdPauseDirON(){}
  virtual Acmd GetAcmdID( void ) const { return AC_PAUSE_DIR_ON; }
private:
  static ActionCmdBase::AcmdRet AcPauseDirONInit( ActionCmdBase::ActionCmdWork* p_work );
};

//--------------------------------------------------------------
///	PAUSE DIR OFF
//==============================================================
class ActionCmdPauseDirOFF : public ActionCmdBase
{
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdPauseDirOFF );
public :
  ActionCmdPauseDirOFF( void );
  virtual ~ActionCmdPauseDirOFF(){}
  virtual Acmd GetAcmdID( void ) const { return AC_PAUSE_DIR_OFF; }
private:
  static ActionCmdBase::AcmdRet AcPauseDirOFFInit( ActionCmdBase::ActionCmdWork* p_work );
};

//--------------------------------------------------------------
///	PAUSE ANM ON
//==============================================================
class ActionCmdPauseAnmON : public ActionCmdBase
{
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdPauseAnmON );
public :
  ActionCmdPauseAnmON( void );
  virtual ~ActionCmdPauseAnmON(){}
  virtual Acmd GetAcmdID( void ) const { return AC_PAUSE_ANM_ON; }
private:
  static ActionCmdBase::AcmdRet AcPauseAnmONInit( ActionCmdBase::ActionCmdWork* p_work );
};

//--------------------------------------------------------------
///	PAUSE ANM OFF
//==============================================================
class ActionCmdPauseAnmOFF : public ActionCmdBase
{
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdPauseAnmOFF );
public :
  ActionCmdPauseAnmOFF( void );
  virtual ~ActionCmdPauseAnmOFF(){}
  virtual Acmd GetAcmdID( void ) const { return AC_PAUSE_ANM_OFF; }
private:
  static ActionCmdBase::AcmdRet AcPauseAnmOFFInit( ActionCmdBase::ActionCmdWork* p_work );
};

GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );

#endif // __FIELDACTIONCMDWAIT_H__
