//=============================================================================
/**
 *
 *	@file		FieldActionCmdDrawFlag.h
 *	@brief  `ntO ANVR}h
 *	@author hosaka genya
 *	@data		2011.07.07
 *
 */
//=============================================================================

#include "FieldActionCmdDrawFlag.h" 

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );

//======================================================================================
// ActionCmdVanishON
//======================================================================================
ActionCmdVanishON::ActionCmdVanishON( void )
{
  m_pFuncTbl[0] = AcVanishONInit;
  m_SeqNum = 1;
}

ActionCmdBase::AcmdRet ActionCmdVanishON::AcVanishONInit( ActionCmdBase::ActionCmdWork* p_work )
{
  p_work->p_model->OnStatusBit( MoveModelBase::STABIT_VANISH );
  
  return ActionCmdBase::ACMD_RET_ONE_TIME_END;
}

//======================================================================================
// ActionCmdVanishOFF
//======================================================================================
ActionCmdVanishOFF::ActionCmdVanishOFF( void )
{
  m_pFuncTbl[0] = AcVanishOFFInit;
  m_SeqNum = 1;
}

ActionCmdBase::AcmdRet ActionCmdVanishOFF::AcVanishOFFInit( ActionCmdBase::ActionCmdWork* p_work )
{
  p_work->p_model->OffStatusBit( MoveModelBase::STABIT_VANISH );
  
  return ActionCmdBase::ACMD_RET_ONE_TIME_END;
}

//======================================================================================
// ActionCmdPauseDirON
//======================================================================================
ActionCmdPauseDirON::ActionCmdPauseDirON( void )
{
  m_pFuncTbl[0] = AcPauseDirONInit;
  m_SeqNum = 1;
}

ActionCmdBase::AcmdRet ActionCmdPauseDirON::AcPauseDirONInit( ActionCmdBase::ActionCmdWork* p_work )
{
  p_work->p_model->OnStatusBit( MoveModelBase::STABIT_PAUSE_DIR );
  
  return ActionCmdBase::ACMD_RET_ONE_TIME_END;
}

//======================================================================================
// ActionCmdPauseDirOFF
//======================================================================================
ActionCmdPauseDirOFF::ActionCmdPauseDirOFF( void )
{
  m_pFuncTbl[0] = AcPauseDirOFFInit;
  m_SeqNum = 1;
}

ActionCmdBase::AcmdRet ActionCmdPauseDirOFF::AcPauseDirOFFInit( ActionCmdBase::ActionCmdWork* p_work )
{
  p_work->p_model->OffStatusBit( MoveModelBase::STABIT_PAUSE_DIR );
  
  return ActionCmdBase::ACMD_RET_ONE_TIME_END;
}

//======================================================================================
// ActionCmdPauseAnmON
//======================================================================================
ActionCmdPauseAnmON::ActionCmdPauseAnmON( void )
{
  m_pFuncTbl[0] = AcPauseAnmONInit;
  m_SeqNum = 1;
}

ActionCmdBase::AcmdRet ActionCmdPauseAnmON::AcPauseAnmONInit( ActionCmdBase::ActionCmdWork* p_work )
{
  p_work->p_model->OnStatusBit( MoveModelBase::STABIT_PAUSE_ANM );
  
  return ActionCmdBase::ACMD_RET_ONE_TIME_END;
}

//======================================================================================
// ActionCmdPauseAnmOFF
//======================================================================================
ActionCmdPauseAnmOFF::ActionCmdPauseAnmOFF( void )
{
  m_pFuncTbl[0] = AcPauseAnmOFFInit;
  m_SeqNum = 1;
}

ActionCmdBase::AcmdRet ActionCmdPauseAnmOFF::AcPauseAnmOFFInit( ActionCmdBase::ActionCmdWork* p_work )
{
  p_work->p_model->OffStatusBit( MoveModelBase::STABIT_PAUSE_ANM );
  
  return ActionCmdBase::ACMD_RET_ONE_TIME_END;
}

GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );
