//=============================================================================
/**
 *
 *	@file		FieldActionCmdWait.h
 *	@brief  EFCg ANVR}h
 *	@author hosaka genya
 *	@data		2011.07.07
 *
 */
//=============================================================================
#ifndef __FIELDACTIONCMDWAIT_H__
#define __FIELDACTIONCMDWAIT_H__

#include "FieldActionCmdBase.h"

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );

class ActionCmdWait
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait );
public :
  struct Work
  {
    s8 wait;
    s8 wait_max;
  };
  
  static void InitializeWork( ActionCmdBase::ActionCmdWork* p_work, s8 wait );
  static ActionCmdBase::AcmdRet AcWait( ActionCmdBase::ActionCmdWork* p_work );
};

//================================================================================================
// ActionCmdWait1F
//================================================================================================
class ActionCmdWait1F : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait1F );
public :
  ActionCmdWait1F( void );
  virtual ~ActionCmdWait1F(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WAIT_1F; }
private:
  static const int WAIT = 1;
  static ActionCmdBase::AcmdRet AcWaitInit( ActionCmdBase::ActionCmdWork* p_work );
};

//================================================================================================
// ActionCmdWait2F
//================================================================================================
class ActionCmdWait2F : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait2F );
public :
  ActionCmdWait2F( void );
  virtual ~ActionCmdWait2F(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WAIT_2F; }
private:
  static const int WAIT = 2;
  static ActionCmdBase::AcmdRet AcWaitInit( ActionCmdBase::ActionCmdWork* p_work );
};

//================================================================================================
// ActionCmdWait4F
//================================================================================================
class ActionCmdWait4F : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait4F );
public :
  ActionCmdWait4F( void );
  virtual ~ActionCmdWait4F(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WAIT_4F; }
private:
  static const int WAIT = 4;
  static ActionCmdBase::AcmdRet AcWaitInit( ActionCmdBase::ActionCmdWork* p_work );
};

//================================================================================================
// ActionCmdWait8F
//================================================================================================
class ActionCmdWait8F : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait8F );
public :
  ActionCmdWait8F( void );
  virtual ~ActionCmdWait8F(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WAIT_8F; }
private:
  static const int WAIT = 8;
  static ActionCmdBase::AcmdRet AcWaitInit( ActionCmdBase::ActionCmdWork* p_work );
};

//================================================================================================
// ActionCmdWait15F
//================================================================================================
class ActionCmdWait15F : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait15F );
public :
  ActionCmdWait15F( void );
  virtual ~ActionCmdWait15F(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WAIT_15F; }
private:
  static const int WAIT = 15;
  static ActionCmdBase::AcmdRet AcWaitInit( ActionCmdBase::ActionCmdWork* p_work );
};

//================================================================================================
// ActionCmdWait16F
//================================================================================================
class ActionCmdWait16F : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait16F );
public :
  ActionCmdWait16F( void );
  virtual ~ActionCmdWait16F(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WAIT_16F; }
private:
  static const int WAIT = 16;
  static ActionCmdBase::AcmdRet AcWaitInit( ActionCmdBase::ActionCmdWork* p_work );
};

//================================================================================================
// ActionCmdWait32F
//================================================================================================
class ActionCmdWait32F : public ActionCmdBase
{ 
  GFL_FORBID_COPY_AND_ASSIGN( ActionCmdWait32F );
public :
  ActionCmdWait32F( void );
  virtual ~ActionCmdWait32F(){}
  virtual Acmd GetAcmdID( void ) const { return AC_WAIT_32F; }
private:
  static const int WAIT = 32;
  static ActionCmdBase::AcmdRet AcWaitInit( ActionCmdBase::ActionCmdWork* p_work );
};

GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );

#endif // __FIELDACTIONCMDWAIT_H__
