//============================================================================
/**
 *
 *	@file		FieldActionCmdWait.cpp
 *	@brief  EFCg ANVR}h
 *	@author hosaka genya
 *	@data		2011.07.07
 *
 */
//============================================================================
#include "FieldActionCmdWait.h"


GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( mmodel );


void ActionCmdWait::InitializeWork( ActionCmdBase::ActionCmdWork* p_work, s8 wait )
{
  Work* p_wk = reinterpret_cast<Work*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(Work) ) );
  
  p_wk->wait = 0;
  p_wk->wait_max = wait;

  // next
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );
}

ActionCmdBase::AcmdRet ActionCmdWait::AcWait( ActionCmdBase::ActionCmdWork* p_work )
{
  Work* p_wk = reinterpret_cast<Work*>( ActionCmdBase::GetAcmdWork( p_work, sizeof(Work) ) );
  
  ++p_wk->wait;
  if( p_wk->wait < p_wk->wait_max-1 )
  {
    return ActionCmdBase::ACMD_RET_ONE_TIME_END;
  }
  
  // 
  ActionCmdBase::AddAcmdWorkSeq( p_work, 1 );
  
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//================================================================================================
// ActionCmdWait1F
//================================================================================================
ActionCmdWait1F::ActionCmdWait1F( void )
{
  m_pFuncTbl[0] = AcWaitInit;
  m_pFuncTbl[1] = ActionCmdWait::AcWait;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWait1F::AcWaitInit( ActionCmdBase::ActionCmdWork* p_work )
{ 
  ActionCmdWait::InitializeWork( p_work, WAIT );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//================================================================================================
// ActionCmdWait2F
//================================================================================================
ActionCmdWait2F::ActionCmdWait2F( void )
{
  m_pFuncTbl[0] = AcWaitInit;
  m_pFuncTbl[1] = ActionCmdWait::AcWait;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWait2F::AcWaitInit( ActionCmdBase::ActionCmdWork* p_work )
{ 
  ActionCmdWait::InitializeWork( p_work, WAIT );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//================================================================================================
// ActionCmdWait4F
//================================================================================================
ActionCmdWait4F::ActionCmdWait4F( void )
{
  m_pFuncTbl[0] = AcWaitInit;
  m_pFuncTbl[1] = ActionCmdWait::AcWait;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWait4F::AcWaitInit( ActionCmdBase::ActionCmdWork* p_work )
{ 
  ActionCmdWait::InitializeWork( p_work, WAIT );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//================================================================================================
// ActionCmdWait8F
//================================================================================================
ActionCmdWait8F::ActionCmdWait8F( void )
{
  m_pFuncTbl[0] = AcWaitInit;
  m_pFuncTbl[1] = ActionCmdWait::AcWait;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWait8F::AcWaitInit( ActionCmdBase::ActionCmdWork* p_work )
{ 
  ActionCmdWait::InitializeWork( p_work, WAIT );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//================================================================================================
// ActionCmdWait15F
//================================================================================================
ActionCmdWait15F::ActionCmdWait15F( void )
{
  m_pFuncTbl[0] = AcWaitInit;
  m_pFuncTbl[1] = ActionCmdWait::AcWait;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWait15F::AcWaitInit( ActionCmdBase::ActionCmdWork* p_work )
{ 
  ActionCmdWait::InitializeWork( p_work, WAIT );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//================================================================================================
// ActionCmdWait16F
//================================================================================================
ActionCmdWait16F::ActionCmdWait16F( void )
{
  m_pFuncTbl[0] = AcWaitInit;
  m_pFuncTbl[1] = ActionCmdWait::AcWait;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWait16F::AcWaitInit( ActionCmdBase::ActionCmdWork* p_work )
{ 
  ActionCmdWait::InitializeWork( p_work, WAIT );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

//================================================================================================
// ActionCmdWait32F
//================================================================================================
ActionCmdWait32F::ActionCmdWait32F( void )
{
  m_pFuncTbl[0] = AcWaitInit;
  m_pFuncTbl[1] = ActionCmdWait::AcWait;
  m_pFuncTbl[2] = ActionCmdBase::AcEnd;
  m_SeqNum = 3;
}

ActionCmdBase::AcmdRet ActionCmdWait32F::AcWaitInit( ActionCmdBase::ActionCmdWork* p_work )
{ 
  ActionCmdWait::InitializeWork( p_work, WAIT );
  return ActionCmdBase::ACMD_RET_CONTINUE;
}

GFL_NAMESPACE_END( mmodel );
GFL_NAMESPACE_END( field );
