//=================================================================================================
/**
 * @file app_tool_ButtonManager.cpp
 * @brief {^Ǘ
 * @author obata_toshihiro
 * @date 2011.07.06
 */
//=================================================================================================
#include <gflib.h>
#include <app/tool/app_tool_ButtonManager.h>


namespace app {
  namespace tool {


    // RXgN^
    ButtonManager::Button::Button( 
        ButtonId button_id,
        gfl::grp::g2d::LytWk* layout_work,
        gfl::grp::g2d::LytPaneIndex pane_index,
        u32 hold_animation_index,
        u32 release_animation_index,
        u32 select_animation_index,
        CallbackFunc callback_func_on_selectd,
        void* callback_work ) :
      m_id( button_id ),
      m_layout_work( layout_work ),
      m_pane_index( pane_index ),
      m_hold_animation_index( hold_animation_index ),
      m_release_animation_index( release_animation_index ),
      m_select_animation_index( select_animation_index ),
      m_callback_func_on_selectd( callback_func_on_selectd ),
      m_callback_work( callback_work ),
      m_state( STATE_RELEASE )
    {
    }


    // fXgN^
    ButtonManager::Button::~Button() 
    {
    }


    // {^ʎq擾
    ButtonManager::ButtonId ButtonManager::Button::GetId( void ) const
    {
      return m_id;
    }


    // {^̓蔻
    bool ButtonManager::Button::IsHit( u16 x, u16 y ) const
    {
      gfl::math::VEC2 pos;
      pos.x = static_cast<float>( x - 160 );
      pos.y = static_cast<float>( 120 - y ); 
      gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( m_pane_index );
      return nw::lyt::IsContain( pane, pos );
    }


    // ^b`Ă邱Ƃʒm
    bool ButtonManager::Button::Hold( void )
    {
      if( m_state == STATE_RELEASE ) {
        this->StopAnimation( m_release_animation_index );
        this->StartAnimation( m_hold_animation_index );
        m_state = STATE_HOLD;
        return true;  // Ԃς
      }
      return false;  // ԂςȂ
    }


    // ^b`ĂȂƂʒm
    bool ButtonManager::Button::Release( void )
    {
      if( m_state == STATE_HOLD ) {
        this->StopAnimation( m_hold_animation_index );
        this->StartAnimation( m_release_animation_index );
        m_state = STATE_RELEASE;
        return true;  // Ԃς
      }
      return false;  // ԂςȂ
    }


    // IꂽƂʒm
    void ButtonManager::Button::Select( void )
    {
      this->StartAnimation( m_select_animation_index );
      if( m_callback_func_on_selectd ) {
        m_callback_func_on_selectd( m_callback_work );  // R[obN
      }
    }


    // Aj[VJn
    void ButtonManager::Button::StartAnimation( u32 animation_index )
    {
      if( m_layout_work->IsBindAnime( animation_index ) == false ) {
        m_layout_work->BindAnime( animation_index );
      }
      m_layout_work->SetAutoAnime( animation_index, true );
      m_layout_work->SetAnimeFrame( animation_index, 0 );
    }


    // Aj[V~
    void ButtonManager::Button::StopAnimation( u32 animation_index )
    {
      if( m_layout_work->IsBindAnime( animation_index ) ) {
        m_layout_work->UnBindAnime( animation_index );
      }
    }










    //---------------------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------------------
    ButtonManager::ButtonManager( 
        gfl::heap::HeapBase* heap, 
        const gfl::ui::DeviceManager* ui_device_manager, 
        u32 max_button_num ) : 
      m_ui_device_manager( ui_device_manager ),
      m_touch_panel( NULL ),
      m_select_type( SELECT_TYPE_RELEASE ),
      m_buttons( NULL ),
      m_max_button_num( max_button_num ),
      m_managed_button_num( 0 ),
      m_holding_button_index( max_button_num ),
      m_holding_flag( false )
    {
      m_touch_panel = ui_device_manager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );
      m_buttons = GFL_NEW( heap ) Button*[ max_button_num ];
      for( u32 i=0; i<max_button_num; i++ ) {
        m_buttons[i] = NULL;
      }
    }


    //---------------------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------------------
    ButtonManager::~ButtonManager()
    {
      for( u32 i=0; i<m_managed_button_num; i++ ) {
        GFL_ASSERT( m_buttons[i] );
        if( m_buttons[i] ) {
          GFL_DELETE m_buttons[i];
        }
      }
    }


    //---------------------------------------------------------------------------------------------
    // {^̑I@ύX
    //---------------------------------------------------------------------------------------------
    void ButtonManager::SetSelectType( SelectType type )
    {
      m_select_type = type;
    }



    //---------------------------------------------------------------------------------------------
    // {^ǉ
    //---------------------------------------------------------------------------------------------
    void ButtonManager::AddButton( 
        gfl::heap::HeapBase* heap, 
        u32 button_id,
        gfl::grp::g2d::LytWk* layout_work,
        gfl::grp::g2d::LytPaneIndex pane_index,
        u32 hold_animation_index,
        u32 release_animation_index,
        u32 select_animation_index,
        CallbackFunc callback_func_on_selectd,
        void* callback_work )
    {
      if( m_managed_button_num < m_max_button_num ) {
        Button* new_button = GFL_NEW( heap ) 
          Button( 
              button_id, 
              layout_work, 
              pane_index, 
              hold_animation_index, 
              release_animation_index, 
              select_animation_index, 
              callback_func_on_selectd, 
              callback_work );
        GFL_ASSERT( m_buttons[ m_managed_button_num ] == NULL );
        m_buttons[ m_managed_button_num ] = new_button;
        m_managed_button_num++;
      }
    }





    //---------------------------------------------------------------------------------------------
    // t[̍XV
    //---------------------------------------------------------------------------------------------
    u32 ButtonManager::Update( void )
    {
      if( m_select_type == SELECT_TYPE_TRIGGER ) {
        return this->UpdateByTrigger();
      }
      else {
        return this->UpdateByRelease();
      } 
    }


    // gKI̍XV
    ButtonManager::ButtonId ButtonManager::UpdateByTrigger( void )
    {
      if( !m_touch_panel->IsTouchTrigger() ) {
        return BUTTON_ID_NULL;  // ^b`ĂȂ
      } 
      u16 touch_x = m_touch_panel->GetX();
      u16 touch_y = m_touch_panel->GetY(); 
      for( u32 i=0; i<m_managed_button_num; i++ ) {
        Button* button = m_buttons[i];
        GFL_ASSERT( button );
        if( button->IsHit( touch_x, touch_y ) ) {
          button->Select();
          return button->GetId();  // Iꂽ{^IDԂ
        }
      }
      return BUTTON_ID_NULL;
    }


    // [XI̍XV
    ButtonManager::ButtonId ButtonManager::UpdateByRelease( void )
    {
      ButtonId selected_button_id = BUTTON_ID_NULL;
      u16 touch_x = m_touch_panel->GetX();
      u16 touch_y = m_touch_panel->GetY(); 

      if( m_touch_panel->IsTouchTrigger() ) {
        for( u32 i=0; i<m_managed_button_num; i++ ) {
          Button* button = m_buttons[i];
          GFL_ASSERT( button );
          bool touch_hit = button->IsHit( touch_x, touch_y );
          if( touch_hit ) {
            button->Hold();
            m_holding_button_index = i;
            m_holding_flag = true;
            break;
          }
        }
      }
      else if( m_touch_panel->IsTouch() ) {
        if( m_holding_flag ) {
          GFL_ASSERT( m_holding_button_index < m_managed_button_num );
          Button* holding_button = m_buttons[ m_holding_button_index ];
          GFL_ASSERT( holding_button );
          bool touch_hit = holding_button->IsHit( touch_x, touch_y );
          if( touch_hit ) {
            holding_button->Hold();
          }
          else { 
            holding_button->Release();
          }
        }
      }
      else if( m_touch_panel->IsTouchRelease() ) {
        if( m_holding_flag ) {
          m_holding_flag = false;
          GFL_ASSERT( m_holding_button_index < m_managed_button_num );
          Button* holding_button = m_buttons[ m_holding_button_index ];
          GFL_ASSERT( holding_button );
          bool button_released = holding_button->Release();
          if( button_released ) {
            holding_button->Select();
            selected_button_id = holding_button->GetId();
          }
        }
      }
      return selected_button_id;
    }






  } // namespace tool
} // namespace app
