//=================================================================================================
/**
 * @file app_tool_ButtonManager.h
 * @brief {^Ǘ
 * @author obata_toshihiro
 * @date 2011.07.06
 */
//=================================================================================================
#ifndef __APPTOOLBUTTONMANAGER_H__
#define __APPTOOLBUTTONMANAGER_H__
#include <gflib.h>


namespace app {
  namespace tool {


    class ButtonManager {
      GFL_FORBID_COPY_AND_ASSIGN( ButtonManager );  // Rs[֎~

      public:

      // R[obN֐
      typedef void (*CallbackFunc)( void* work );

      // {^ʎq
      typedef u32 ButtonId;
      static const ButtonId BUTTON_ID_NULL = 0xffffffff;


      // {^̑I@
      enum SelectType {
        SELECT_TYPE_TRIGGER,  // gKI
        SELECT_TYPE_RELEASE,  // [XI( ftHgl )
      };



      //-------------------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param heap               CX^X̐Ɏgpq[v
       * @param ui_device_manager  ɎgpUIfoCX
       * @param max_button_num     Ǘ\ȃ{^̍ő吔
       */
      //-------------------------------------------------------------------------------------------
      ButtonManager( 
          gfl::heap::HeapBase* heap, 
          const gfl::ui::DeviceManager* ui_device_manager, 
          u32 max_button_num ); 

      //-------------------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //-------------------------------------------------------------------------------------------
      virtual ~ButtonManager(); 


      //-------------------------------------------------------------------------------------------
      /**
       * @brief XV( t[Ăł )
       * @return Iꂽ{^ID
       * @retval BUTTON_ID_NULL  ǂ̃{^IĂȂꍇ
       */
      //-------------------------------------------------------------------------------------------
      ButtonId Update( void ); 


      //-------------------------------------------------------------------------------------------
      /**
       * @brief {^ǉ
       * @param heap                       Ǘ[NmۂɎgpq[v
       * @param button_id                  {^̎ʎq( IꂽۂUpdate()ŕԂĂl )
       * @param layout_work                {^郌CAEg[N
       * @param pane_index                 {^\yC( 蔻Ɏgp )
       * @param hold_animation_index       {^^b`ꂽۂɍĐAj[V
       * @param release_animation_index    {^ꂽۂɍĐAj[V
       * @param select_animation_index     {^IꂽۂɍĐAj[V
       * @param callback_func_on_selected  {^IꂽۂɌĂ΂R[obN֐( svȂNULL )
       * @param callback_work              R[obN֐ɓnCӂ̃[N( svȂNULL )
       */
      //-------------------------------------------------------------------------------------------
      void AddButton( 
          gfl::heap::HeapBase* heap, 
          ButtonId button_id,
          gfl::grp::g2d::LytWk* layout_work,
          gfl::grp::g2d::LytPaneIndex pane_index,
          u32 hold_animation_index,
          u32 release_animation_index,
          u32 select_animation_index,
          CallbackFunc callback_func_on_selectd,
          void* callback_work );


      //-------------------------------------------------------------------------------------------
      /**
       * @brief {^̑I@ύX
       * @param type  ݒ肷I@
       */
      //-------------------------------------------------------------------------------------------
      void SetSelectType( SelectType type );







      private: 

      // 1̃{^\NX
      class Button {
        public:
          Button( 
              ButtonId button_id,
              gfl::grp::g2d::LytWk* layout_work,
              gfl::grp::g2d::LytPaneIndex pane_index,
              u32 hold_animation_index,
              u32 release_animation_index,
              u32 select_animation_index,
              CallbackFunc callback_func_on_selectd,
              void* callback_work );
          virtual ~Button();
          ButtonId GetId( void ) const;
          bool IsHit( u16 x, u16 y ) const;
          bool Hold( void );
          bool Release( void );
          void Select( void );
        private:
          enum State {
            STATE_HOLD,
            STATE_RELEASE,
          };
          void StartAnimation( u32 animation_index );
          void StopAnimation( u32 animation_index );
          ButtonId m_id;
          gfl::grp::g2d::LytWk* m_layout_work;
          gfl::grp::g2d::LytPaneIndex m_pane_index;
          u32 m_hold_animation_index;
          u32 m_release_animation_index;
          u32 m_select_animation_index;
          CallbackFunc m_callback_func_on_selectd;
          void* m_callback_work; 
          State m_state;
      };




      const gfl::ui::DeviceManager* m_ui_device_manager;
      const gfl::ui::TouchPanel* m_touch_panel;
      SelectType m_select_type;
      Button** m_buttons;
      u32 m_max_button_num;
      u32 m_managed_button_num;
      u32 m_holding_button_index;
      bool m_holding_flag;

      ButtonId UpdateByTrigger( void );
      ButtonId UpdateByRelease( void );
    };


  } // namespace tool
} // namespace app


#endif // __APPTOOLBUTTONMANAGER_H__
