//================================================================================
/**
 * @file   test_obata_ButtonManager.h
 * @brief  {^}l[W̃eXg
 * @author obata_toshihiro
 * @date   2011.07.06
 */ 
//================================================================================
#pragma once 
#include <gfl_Heap.h>
#include <app/tool/app_tool_ButtonManager.h>
#include "test_obata_Base.h"

namespace test {
  namespace obata {


    class ButtonManagerTest : public Base { 
      public: 
        ButtonManagerTest( 
            gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
            gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
            gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager );
        virtual ~ButtonManagerTest(); 
        virtual void UpdateTest( void );
        virtual void DrawTest( void );
      private:
        static const u32 BUTTON_NUM = 6;
        static const gfl::grp::g2d::LytPaneIndex BUTTON_PANE_INDEX[ BUTTON_NUM ];
        static const app::tool::ButtonManager::CallbackFunc CALLBACK_ON_SELECTED[ BUTTON_NUM ];
        enum AnimationDataId {
          ANIMATION_DATA_BUTTON_ON_HOLD_DUMMY,
          ANIMATION_DATA_BUTTON_ON_RELEASE_DUMMY,
          ANIMATION_DATA_BUTTON_ON_SELECT_DUMMY,
          ANIMATION_DATA_NUM,
        };
        static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
        enum AnimationId {
          ANIMATION_BUTTON_ON_HOLD_DUMMY,
          ANIMATION_BUTTON_ON_RELEASE_DUMMY,
          ANIMATION_BUTTON_ON_SELECT_DUMMY,
          // ȉALAj[V
          ANIMATION_BUTTON_01_ON_HOLD,
          ANIMATION_BUTTON_01_ON_RELEASE = ANIMATION_BUTTON_01_ON_HOLD + BUTTON_NUM,
          ANIMATION_BUTTON_01_ON_SELECT = ANIMATION_BUTTON_01_ON_RELEASE + BUTTON_NUM,
          ANIMATION_NUM = ANIMATION_BUTTON_01_ON_SELECT + BUTTON_NUM,
        };
        gfl::grp::g2d::LytSys*  m_layout_system;
        gfl::grp::g2d::LytWk* m_layout_work; 
        app::tool::ButtonManager* m_button_manager;
        static void CallbackFuncOnButton01Selected( void* work );
        static void CallbackFuncOnButton02Selected( void* work );
        static void CallbackFuncOnButton03Selected( void* work );
        static void CallbackFuncOnButton04Selected( void* work );
        static void CallbackFuncOnButton05Selected( void* work );
        static void CallbackFuncOnButton06Selected( void* work );
    };


  } // namespace obata 
} // namespace test
