//================================================================================
/**
 * @file   test_obata_ButtonManager.cpp
 * @brief  {^}l[W̃eXg
 * @author obata_toshihiro
 * @date   2011.07.06
 */ 
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <pmlib.h>
#include <arc/arc_def.h>
#include "buttons.gaix"
#include "buttons.h"
#include "buttons_pane.h"
#include "test_obata_ButtonManager.h"


void Func( void* work )
{
}

namespace test {
  namespace obata {

    // {^̃yC
    const gfl::grp::g2d::LytPaneIndex ButtonManagerTest::BUTTON_PANE_INDEX[ ButtonManagerTest::BUTTON_NUM ] = 
    {
      PANENAME_BUTTONS_PANE_BUTTON_01,
      PANENAME_BUTTONS_PANE_BUTTON_02,
      PANENAME_BUTTONS_PANE_BUTTON_03,
      PANENAME_BUTTONS_PANE_BUTTON_04,
      PANENAME_BUTTONS_PANE_BUTTON_05,
      PANENAME_BUTTONS_PANE_BUTTON_06,
    };

    // Aj[Ve[u
    const gfl::grp::g2d::LytArcIndex ButtonManagerTest::ANIMATION_DATA_TABLE[ ButtonManagerTest::ANIMATION_DATA_NUM ] =
    {
      LYTRES_BUTTONS_BUTTONS_ON_HOLD_BCLAN,
      LYTRES_BUTTONS_BUTTONS_ON_RELEASE_BCLAN,
      LYTRES_BUTTONS_BUTTONS_ON_SELECT_BCLAN,
    };


    // {^ĨR[obN֐e[u
    const app::tool::ButtonManager::CallbackFunc ButtonManagerTest::CALLBACK_ON_SELECTED[ ButtonManagerTest::BUTTON_NUM ] = 
    {
      ButtonManagerTest::CallbackFuncOnButton01Selected,
      ButtonManagerTest::CallbackFuncOnButton02Selected,
      ButtonManagerTest::CallbackFuncOnButton03Selected,
      ButtonManagerTest::CallbackFuncOnButton04Selected,
      ButtonManagerTest::CallbackFuncOnButton05Selected,
      ButtonManagerTest::CallbackFuncOnButton06Selected,
    };


    //-----------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------
    ButtonManagerTest::ButtonManagerTest( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
        gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allocator,
        gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
      Base( heap, device_heap, heap_allocator, device_allocator, graphics_system, ui_device_manager ),
      m_layout_system( NULL ),
      m_layout_work( NULL ),
      m_button_manager( NULL )
    { 
      static const gfl::grp::g2d::LytSysSetUp system_setup_data = 
      {
        128, // Ǘ\[Xő吔
        10,  // ǗCAEg[Nő吔
      }; 
      m_layout_system = GFL_NEW( heap ) 
        gfl::grp::g2d::LytSys( &system_setup_data, heap_allocator, device_allocator );
      gfl::fs::ArcFile arc_file( L"rom:/obata/buttons.garc", heap );
      gfl::grp::g2d::LytResID layout_res_id = 
        m_layout_system->LoadLytRes( device_allocator, &arc_file, GARC_buttons_buttons_LYTDAT );
      m_layout_system->TransferAllTexture( layout_res_id, gfl::grp::MEMORY_AREA_FCRAM );
      m_layout_work = m_layout_system->CreateLytWk(
          layout_res_id, 
          LYTRES_BUTTONS_BUTTONS_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &gfl::grp::g2d::c_LytWkLowerDefaultSetUp, false );
      GFL_PRINT( "%d\n",
      m_layout_work->CreateShareAnime( 
          ANIMATION_BUTTON_01_ON_HOLD, 
          ANIMATION_DATA_TABLE[ ANIMATION_DATA_BUTTON_ON_HOLD_DUMMY ] )
      );
      GFL_PRINT( "%d\n",
      m_layout_work->CreateShareAnime( 
          ANIMATION_BUTTON_01_ON_RELEASE, 
          ANIMATION_DATA_TABLE[ ANIMATION_DATA_BUTTON_ON_RELEASE_DUMMY ] )
      );
      GFL_PRINT( "%d\n",
      m_layout_work->CreateShareAnime( 
          ANIMATION_BUTTON_01_ON_SELECT, 
          ANIMATION_DATA_TABLE[ ANIMATION_DATA_BUTTON_ON_SELECT_DUMMY ] )
      );

      m_button_manager = GFL_NEW( heap ) app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM );
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        m_button_manager->AddButton( 
            heap, i, m_layout_work, 
            BUTTON_PANE_INDEX[i],
            ANIMATION_BUTTON_01_ON_HOLD + i,
            ANIMATION_BUTTON_01_ON_RELEASE + i,
            ANIMATION_BUTTON_01_ON_SELECT + i,
            CALLBACK_ON_SELECTED[i], this );
      }
    }


    //-----------------------------------------------------------------------------
    // fXgN^
    //-----------------------------------------------------------------------------
    ButtonManagerTest::~ButtonManagerTest()
    {
      m_layout_system->RemoveLytWk( m_layout_work );
      GFL_DELETE m_layout_system;
    } 




    //-----------------------------------------------------------------------------
    // C
    //-----------------------------------------------------------------------------
    void ButtonManagerTest::UpdateTest( void )
    {
      m_layout_system->UpdateAll();
      app::tool::ButtonManager::ButtonId selected_button_id = m_button_manager->Update();
      if( selected_button_id != app::tool::ButtonManager::BUTTON_ID_NULL ) {
        GFL_PRINT( "selected_button_id = %d\n", selected_button_id );
      }
      // I@ύX
      if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
        static bool flag = false;
        app::tool::ButtonManager::SelectType select_type = ( flag ) ? 
          app::tool::ButtonManager::SELECT_TYPE_RELEASE : app::tool::ButtonManager::SELECT_TYPE_TRIGGER;
        m_button_manager->SetSelectType( select_type );
        flag = !flag;
      }
      // START {^ŏI
      if( m_button->IsTrigger( gfl::ui::BUTTON_START ) ) {
        this->End(); 
      }
    } 



    // {^ĨR[obN֐
    void ButtonManagerTest::CallbackFuncOnButton01Selected( void* work )
    {
      GFL_UNUSED( work );
      GFL_PRINT( "callback on button 01 selected\n" );
    }
    void ButtonManagerTest::CallbackFuncOnButton02Selected( void* work )
    {
      GFL_UNUSED( work );
      GFL_PRINT( "callback on button 02 selected\n" );
    }
    void ButtonManagerTest::CallbackFuncOnButton03Selected( void* work )
    {
      GFL_UNUSED( work );
      GFL_PRINT( "callback on button 03 selected\n" );
    }
    void ButtonManagerTest::CallbackFuncOnButton04Selected( void* work )
    {
      GFL_UNUSED( work );
      GFL_PRINT( "callback on button 04 selected\n" );
    }
    void ButtonManagerTest::CallbackFuncOnButton05Selected( void* work )
    {
      GFL_UNUSED( work );
      GFL_PRINT( "callback on button 05 selected\n" );
    }
    void ButtonManagerTest::CallbackFuncOnButton06Selected( void* work )
    {
      GFL_UNUSED( work );
      GFL_PRINT( "callback on button 06 selected\n" );
    }




    //-----------------------------------------------------------------------------
    // `揈
    //-----------------------------------------------------------------------------
    void ButtonManagerTest::DrawTest( void )
    {
      gfl::grp::RenderTarget* lower_frame_buffer = 
        m_graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_system->DrawAll( m_graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }



  } // namespace obata 
} // namespace test
