//============================================================================================
/**
 * @file		nakahiro.cpp
 * @brief		^CgfobOuNakamura Hiroyukiv
 * @author	Hiroyuki Nakamura
 * @date		11.07.04
 *
 * namespace	test::nakahiro::
 */
//============================================================================================
#include "test/nakahiro/pma_viewer/pma_viewer.h"
#include "test/nakahiro/pokeicon_test/pokeicon_test.h"
#include "test/nakahiro/ar_test/ar_test.h"
#include "test/nakahiro/3Dview_test/3Dview_test.h"
#include "test/nakahiro/nakahiro.h"



namespace test {
namespace nakahiro {

// x`
enum SkelUserLabel {
	LAUNCHERLABEL_PMAV,
	LAUNCHERLABEL_AR,
	LAUNCHERLABEL_POKEICON,
	LAUNCHERLABEL_V3D,
//	LAUNCHERLABEL_STRINPUT,

	LAUNCHERLABEL_MAX,     // xől

	ENUM_FORCE_DWORD(SkelUserLabel)
};

static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap );


// N
static const skel::LauncherLabel LauncherLabel[] =
{
	{ L"poke anm viewer", LAUNCHERLABEL_PMAV },
	{ L"AR", LAUNCHERLABEL_AR },
	{ L"poke icon", LAUNCHERLABEL_POKEICON },
	{ L"view 3D", LAUNCHERLABEL_V3D },
//	{ L"str input", LAUNCHERLABEL_STRINPUT },
};

// NZbgAbv
static const skel::LauncherSetUp LauncherSetUp = {
	LauncherLabel,
	LAUNCHERLABEL_MAX
};



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	CreateMenu();
//	return gfl::proc::RES_FINISH;
	return gfl::proc::RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
}


void Proc::CreateMenu(void)
{
	skel::LauncherProc * pLauncher = GFL_NEW( mpGameProcManager->GetHeap() )	skel::LauncherProc;
	pLauncher->SetGameProcManager( mpGameProcManager );
	mpGameProcManager->CallProc( pLauncher );
	pLauncher->SetParamGM( &LauncherSetUp, SetUpUserProc );
}
void Proc::DeleteMenu(void)
{
//	GFL_DELETE	pLauncher;
}


static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap )
{
	GFL_UNUSED( heap );

	switch( selectNum ){
	case LAUNCHERLABEL_PMAV:
		GFL_PROC_CALL( p_procMan, test::pmav::Proc );
		return skel::LAUNCHER_RET_CALL_NORMAL;

	case LAUNCHERLABEL_AR:
		GFL_PROC_CALL( p_procMan, test::ar_test::Proc );
		return skel::LAUNCHER_RET_CALL_NORMAL;

	case LAUNCHERLABEL_POKEICON:
		GFL_PROC_CALL( p_procMan, test::pokeicon::Proc );
		return skel::LAUNCHER_RET_CALL_NORMAL;

	case LAUNCHERLABEL_V3D:
		GFL_PROC_CALL( p_procMan, test::v3d::Proc );
		return skel::LAUNCHER_RET_CALL_NORMAL;

/*
	case LAUNCHERLABEL_STRINPUT:
		return skel::LAUNCHER_RET_CALL_NORMAL;
*/
	}

	return skel::LAUNCHER_RET_CALL_DEBUGMODE;
}


}	// nakahiro
}	// test
