//=================================================================================================
/**
 * @brief BGMC^[tF[XNX
 * @file  BGMController.cpp
 * @author obata
 * @date   2011.06.29
 */
//=================================================================================================
#include <sound/BGMManager.h>
#include <sound/BGMController.h>


namespace snd { 


  // BGMtF[h̃t[
  const u32 BGMController::BGM_FADE_FRAME[ BGM_FADE_NUM ] = 
  {
    /* BGM_FADE_NONE */ 0,
    /* BGM_FADE_VERY_FAST */ 6,
    /* BGM_FADE_FAST */ 30,
    /* BGM_FADE_MIDDLE */ 60,
    /* BGM_FADE_SLOW */ 90,
  };


  // BGM{[
  const f32 BGMController::BGM_VOLUME[ BGM_VOLUME_NUM ] = 
  {
    /* BGM_VOLUME_LOW */ 0.5f,
    /* BGM_VOLUME_NORMAL */ 1.0f,
    /* BGM_VOLUME_HIGH */ 2.0f,
  };


  const u32 BGMController::SOUND_ITEM_ID_NULL = 0;


  BGMManager* BGMController::m_bgm_manager = NULL; 
  u32 BGMController::m_last_bgm = SOUND_ITEM_ID_NULL;
  u32 BGMController::m_push_count = 0;
  u32* BGMController::m_pushed_bgm = NULL;


  //-----------------------------------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------------------------------
  void BGMController::Initialize( gfl::heap::HeapBase* heap, BGMManager* bgm_manager )
  {
    m_bgm_manager = bgm_manager;
    m_last_bgm = SOUND_ITEM_ID_NULL;
    m_push_count = 0;

    const PokemonSoundSystem* sound_system = bgm_manager->GetSoundSystem();
    u32 max_push_count = sound_system->GetMaxPushBGMCount();
    m_pushed_bgm = GFL_NEW( heap ) u32[ max_push_count ];
  }

  //-----------------------------------------------------------------------------------------------
  // j
  //-----------------------------------------------------------------------------------------------
  void BGMController::Finalize( void )
  {
    GFL_DELETE_ARRAY m_pushed_bgm;
  }






  //-----------------------------------------------------------------------------------------------
  // ^Cg
  //-----------------------------------------------------------------------------------------------

  // Jn
  void BGMController::StartTitleBgm( void )
  {
    u32 title_bgm = STRM_BGM_POKEMON_THEME;
    if( m_last_bgm != title_bgm ) {
      m_bgm_manager->RegisterRequest_FORCE_PLAY( title_bgm );
      m_last_bgm = title_bgm;
    }
  }


  // I
  void BGMController::EndTitleBgm( void )
  {
    u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
    m_bgm_manager->RegisterRequest_FADE_OUT( fade_out_frame );
    m_last_bgm = SOUND_ITEM_ID_NULL;
  }




  //-----------------------------------------------------------------------------------------------
  // Q[Jn
  //-----------------------------------------------------------------------------------------------
  void BGMController::StartFirstFieldBgm( u32 sound_item_id )
  {
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_NONE ];
      m_bgm_manager->RegisterRequest_CHANGE( sound_item_id, fade_out_frame, fade_in_frame );
      m_last_bgm = sound_item_id;
    }
  }



  //-----------------------------------------------------------------------------------------------
  // ][`FW
  //-----------------------------------------------------------------------------------------------
  void BGMController::ChangeBgmByZoneChange( u32 sound_item_id, u16 player_move_form )
  {
    GFL_UNUSED( player_move_form ); // @todo @tH[ŃtF[hԂω
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_NONE ];
      m_bgm_manager->RegisterRequest_CHANGE( sound_item_id, fade_out_frame, fade_in_frame );
      m_last_bgm = sound_item_id;
    }
  }




  //-----------------------------------------------------------------------------------------------
  // }bv`FW
  //-----------------------------------------------------------------------------------------------
  void BGMController::StandByNextMapBgm( u32 sound_item_id )
  {
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      m_bgm_manager->RegisterRequest_STAND_BY( sound_item_id, fade_out_frame );
      m_last_bgm = sound_item_id;
    }
  }

  void BGMController::StartNextMapBgm( void )
  {
    u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_NONE ];
    m_bgm_manager->RegisterRequest_FADE_IN( fade_in_frame );
  }




  //-----------------------------------------------------------------------------------------------
  // @ړtH[ύX
  //-----------------------------------------------------------------------------------------------

  // 
  void BGMController::ChangeBgmByPlayerFormWalk( u32 sound_item_id )
  {
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_NONE ];
      m_bgm_manager->RegisterRequest_CHANGE( sound_item_id, fade_out_frame, fade_in_frame );
      m_last_bgm = sound_item_id;
    }
  } 

  // ]
  void BGMController::ChangeBgmByPlayerFormBicycle( void )
  {
    u32 sound_item_id = 0;  // @todo  
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_NONE ];
      m_bgm_manager->RegisterRequest_CHANGE( sound_item_id, fade_out_frame, fade_in_frame );
      m_last_bgm = sound_item_id;
    }
  } 

  // g
  void BGMController::ChangeBgmByPlayerFormNaminori( void )
  {
    u32 sound_item_id = 0;  // @todo  
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_NONE ];
      m_bgm_manager->RegisterRequest_CHANGE( sound_item_id, fade_out_frame, fade_in_frame );
      m_last_bgm = sound_item_id;
    }
  }





  //-----------------------------------------------------------------------------------------------
  // og
  //-----------------------------------------------------------------------------------------------

  // 
  void BGMController::StartTrainerEyeBgm( u32 sound_item_id )
  {
    if( m_push_count < PUSH_COUNT_BASE ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
      m_bgm_manager->RegisterRequest_PUSH( fade_out_frame );
      m_bgm_manager->RegisterRequest_FORCE_PLAY( sound_item_id );
      m_pushed_bgm[ m_push_count ] = m_last_bgm;
      m_last_bgm = sound_item_id;
      m_push_count++;
    }
    else {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
      m_bgm_manager->RegisterRequest_FADE_OUT( fade_out_frame );
      m_bgm_manager->RegisterRequest_FORCE_PLAY( sound_item_id );
      m_last_bgm = sound_item_id;
    }
  }


  // ogJn
  void BGMController::StartBattleBgm( u32 sound_item_id )
  {
    if( m_push_count < PUSH_COUNT_BASE ) {  // x[XBGMĐ
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
      m_bgm_manager->RegisterRequest_PUSH( fade_out_frame );
      m_pushed_bgm[ m_push_count ] = m_last_bgm;
      m_push_count++;
    }
    else {  // ȍĐ
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
      m_bgm_manager->RegisterRequest_FADE_OUT( fade_out_frame );
    }
    m_bgm_manager->RegisterRequest_FORCE_PLAY( sound_item_id );
    m_last_bgm = sound_item_id;
  }


  // ogI
  void BGMController::StartBaseBgmFromBattle( void )
  {
    if( PUSH_COUNT_NONE < m_push_count ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
      u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      m_bgm_manager->RegisterRequest_POP( fade_out_frame, fade_in_frame );
      m_push_count--;
      m_last_bgm = m_pushed_bgm[ m_push_count ];
    }
  }





  //-----------------------------------------------------------------------------------------------
  // Cxg
  //-----------------------------------------------------------------------------------------------

  // CxgȊJn
  void BGMController::StartEventBgm( u32 sound_item_id )
  {
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
      m_bgm_manager->RegisterRequest_FADE_OUT( fade_out_frame );
      m_bgm_manager->RegisterRequest_FORCE_PLAY( sound_item_id );
      m_last_bgm = sound_item_id;
    }
  }

  // CxgȂ̃x[XȕA
  void BGMController::StartBaseBgmFromEvent( u32 sound_item_id )
  {
    if( m_last_bgm != sound_item_id ) {
      u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_SLOW ];
      u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_MIDDLE ];
      m_bgm_manager->RegisterRequest_CHANGE( sound_item_id, fade_out_frame, fade_in_frame );
      m_last_bgm = sound_item_id;
    }
  }





  //-----------------------------------------------------------------------------------------------
  // ME
  //-----------------------------------------------------------------------------------------------

  // MEJn
  void BGMController::StartJingleBgm( u32 sound_item_id )
  {
    u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
    m_bgm_manager->RegisterRequest_PUSH( fade_out_frame );
    m_bgm_manager->RegisterRequest_FORCE_PLAY( sound_item_id );
    m_pushed_bgm[ m_push_count ] = m_last_bgm;
    m_push_count++;
    m_last_bgm = sound_item_id;
  }

  // MẼx[XBGMA
  void BGMController::StartBaseBgmFromJingle( void )
  {
    u32 fade_out_frame = BGM_FADE_FRAME[ BGM_FADE_NONE ];
    u32 fade_in_frame = BGM_FADE_FRAME[ BGM_FADE_VERY_FAST ];
    m_bgm_manager->RegisterRequest_POP( fade_out_frame, fade_in_frame );
    m_push_count--;
    m_last_bgm = m_pushed_bgm[ m_push_count ];
  }







#if PM_DEBUG
  void BGMController::PauseBgm( void )
  {
    m_bgm_manager->RegisterRequest_FADE_OUT(0);
    m_last_bgm = SOUND_ITEM_ID_NULL;
  }
#endif


} // namespace snd
