//=================================================================================================
/**
 * @brief BGMC^[tF[XNX
 * @file  BGMController.h
 * @author obata
 * @date   2011.06.29
 */
//=================================================================================================
#ifndef __BGMCONTROLLER_H__
#define __BGMCONTROLLER_H__
#include <gflib.h>


namespace snd {

  class BGMManager;


  class BGMController {
    GFL_FORBID_COPY_AND_ASSIGN( BGMController );  // Rs[֎~

    public: 

    static void Initialize( gfl::heap::HeapBase* heap, BGMManager* bgm_manager );
    static void Finalize( void );



    //---------------------------------------------------------------------------------------------
    // ^Cg
    //--------------------------------------------------------------------------------------------- 
    static void StartTitleBgm( void );
    static void EndTitleBgm( void );


    //---------------------------------------------------------------------------------------------
    // tB[h
    //---------------------------------------------------------------------------------------------
    
    // Q[Jn
    static void StartFirstFieldBgm( u32 sound_item_id );

    // ][`FW
    static void ChangeBgmByZoneChange( u32 sound_item_id, u16 player_move_form );

    // }bv`FW
    static void StandByNextMapBgm( u32 sound_item_id );
    static void StartNextMapBgm( void );

    // @ړtH[ύX
    static void ChangeBgmByPlayerFormWalk( u32 sound_item_id );
    static void ChangeBgmByPlayerFormBicycle( void );
    static void ChangeBgmByPlayerFormNaminori( void ); 

    // og
    static void StartTrainerEyeBgm( u32 sound_item_id ); // 
    static void StartBattleBgm( u32 sound_item_id );
    static void StartBaseBgmFromBattle( void );

    // Cxg
    static void StartEventBgm( u32 sound_item_id );
    static void StartBaseBgmFromEvent( u32 sound_item_id );

    // ME
    static void StartJingleBgm( u32 sound_item_id );
    static void StartBaseBgmFromJingle( void );



#if PM_DEBUG
    //--------------------------------------------------------------------------------------------- 
    // L̊֐, ̂폜܂BgȂłB
    //--------------------------------------------------------------------------------------------- 
    static void PauseBgm( void );
#endif




    private:

    // BGMޔ
    enum PushCount {
      PUSH_COUNT_NONE,  // ޔȂ
      PUSH_COUNT_BASE,  // x[XBGMޔ
      PUSH_COUNT_OVER,  // ޔ𐔃I[o[
    };

    // BGMtF[h̑x
    enum FadeSpeed {
      BGM_FADE_NONE,       // 
      BGM_FADE_VERY_FAST,  // ƂĂ
      BGM_FADE_FAST,       // 
      BGM_FADE_MIDDLE,     // 
      BGM_FADE_SLOW,       // x
      BGM_FADE_NUM,
    };

    // BGM{[
    enum VolumeLevel {
      BGM_VOLUME_LOW,     // 
      BGM_VOLUME_NORMAL,  // ʏ
      BGM_VOLUME_HIGH,    // 傫
      BGM_VOLUME_NUM,
    };

    static const u32 SOUND_ITEM_ID_NULL;
    static const u32 BGM_FADE_FRAME[ BGM_FADE_NUM ];
    static const f32 BGM_VOLUME[ BGM_VOLUME_NUM ]; 
    static BGMManager* m_bgm_manager;
    static u32 m_last_bgm;
    static u32 m_push_count;
    static u32* m_pushed_bgm;
  };


} // namespace snd


#endif // __BGMCONTROLLER_H__ 
