//=================================================================================================
/**
 * @file app_tool_Gauge.cpp
 * @brief Q[W֘A
 * @author obat_toshihiro
 * @date 2011.07.05
 */
//=================================================================================================
#include <app/tool/app_tool_Gauge.h>


namespace app {
  namespace tool {


    //-----------------------------------------------------------------------------------------
    /**
     * @brief	ݒl̃Q[Whbg擾
     * @param	now_value	ݒl
     * @param	max_value	ől
     * @param	max_dot	őhbg
     * @return hbg
     */
    //-----------------------------------------------------------------------------------------
    u8 Gauge::GetDottoNum( u32 now_value, u32 max_value, u8 max_dot )
    {
      u8 put_dot;

      put_dot = now_value * max_dot / max_value;
      if( put_dot == 0 && now_value > 0 )   // ޯČvZł0łۂ̒l1ȏȂ1ޯĂɂ
      {
        put_dot = 1;
      }
      return put_dot;
    }



    //-----------------------------------------------------------------------------------------
    /**
     * @brief HPQ[W̃J[擾
     * @param now_value	݂̒l
     * @param max_value	ől
     * @return Q[WJ[
     */
    //-----------------------------------------------------------------------------------------
    Gauge::GaugeColor Gauge::GetDottoColor( u32 now_value, u32 max_value )
    {
      now_value <<= 8;		//Zgpׁ̈Ax܂Ō悤ɌŒ菬
      max_value <<= 8;

      if( now_value > (max_value/2) )
      {
        return GAUGE_COLOR_GREEN;	// 
      }
      else if( now_value > (max_value/5) )
      {
        return GAUGE_COLOR_YELLOW;	// 
      }
      else if( now_value > 0 )
      {
        return GAUGE_COLOR_RED;		// 
      }
      return GAUGE_COLOR_NULL;			// HP=0
    }


  } // namespace tool
} // namespace app
