//======================================================================
/**
 * @file	btlv_ui_target.cpp
 * @brief	og` UI ΏۑI
 * @author	ariizumi
 * @data	11/07/05
 */
//======================================================================
#include <gflib.h>

#include "btlv_core.h"
#include "btlv_types.h"
#include "btlv_ui.h"
#include "btlv_ui_target.h"

namespace btl
{
  
BtlvUiTarget::BtlvUiTarget(BattleViewSystem* core,BtlvUi* ui):
  BtlvUiWork( core,ui )
{
}

//
void BtlvUiTarget::Create(void)
{
  gfl::fs::ArcFile* arc = mBtlvUi->GetResArc();

  gfl::grp::g2d::LytArcIndex anmIdxTbl[TARGET_ANM_NUM];

  switch( mBtlvCore->GetBattleRule() )
  {
  case BTL_RULE_SINGLE:    ///< VO
    anmIdxTbl[0] = LYTRES_BTLV_LYT_BTL_TARGET_TARGET_SEL_SINGLE_BCLAN;
    break;
  case BTL_RULE_DOUBLE:    ///< _u
    anmIdxTbl[0] = LYTRES_BTLV_LYT_BTL_TARGET_TARGET_SEL_DOUBLE_BCLAN;
    break;
  case BTL_RULE_TRIPLE:    ///< gv
  case BTL_RULE_ROTATION:  ///< [e[V
    anmIdxTbl[0] = LYTRES_BTLV_LYT_BTL_TARGET_TARGET_SEL_TRIPLE_BCLAN;
    break;
  case BTL_RULE_BAND:      ///< Q
    anmIdxTbl[0] = LYTRES_BTLV_LYT_BTL_TARGET_TARGET_SEL_BAND_BCLAN;
    break;
  }


  const BTLV_LAYOUT_PARAM gaugeParam =
  {
    GARC_btlv_lyt_btlv_lyt_LYTDAT,
    LYTRES_BTLV_LYT_BTL_TARGET_BCLYT ,
    {
      gfl::math::VEC3(0,LAYOUT_DOWN_OFS,0),   // pos
      gfl::math::VEC2(1,1),     // scale
      gfl::math::VEC3(0,0,0),   // rotate
      1,                        // priority
    },
    GFL_NELEMS(anmIdxTbl),
    anmIdxTbl,
    TARGET_ANM_NUM
  };
  
  mLytWk.CreateLayout( arc , &gaugeParam , mBtlvCore );
}

//
void BtlvUiTarget::Delete(void)
{
  mLytWk.DeleteLayout(mBtlvCore);
}
  
//Layout擾
BtlvLayout* BtlvUiTarget::GetLayout( const int type )
{
  GFL_UNUSED(type);
  return &mLytWk;
}

//XV
BTLV_COMMAND_RESULT BtlvUiTarget::UpdateTarget(void)
{
  const gfl::ui::Button *btn = mBtlvCore->GetButton();
  const gfl::ui::TouchPanel* tp = mBtlvCore->GetTP();

  if( tp->IsTouch() == true )
  {
    const s32 vx = tp->GetX();
    const s32 vy = tp->GetY();

    const gfl::grp::g2d::LytPaneIndex ret = mLytWk.GetLytWk()->GetHitPaneIndexGroup( PANENAME_BTL_TARGET_GROUP_TARGET_HIT_GROUP , vx,vy,false );
    
    switch(ret)
    {
    case PANENAME_BTL_TARGET_PANE_TRG_SEL_00:
    case PANENAME_BTL_TARGET_PANE_TRG_SEL_01:
    case PANENAME_BTL_TARGET_PANE_TRG_SEL_02:
    case PANENAME_BTL_TARGET_PANE_TRG_SEL_03:
    case PANENAME_BTL_TARGET_PANE_TRG_SEL_04:
    case PANENAME_BTL_TARGET_PANE_TRG_SEL_05:
      {
        const int hitIdx = (ret-PANENAME_BTL_TARGET_PANE_TRG_SEL_00)/(PANENAME_BTL_TARGET_PANE_TRG_SEL_01-PANENAME_BTL_TARGET_PANE_TRG_SEL_00);
        return (BTLV_COMMAND_RESULT)(BCR_SEL_IDX1+hitIdx);
      }
      //break;
    }
  }
  if( btn->IsTrigger( gfl::ui::BUTTON_B ) )
  {
    return BCR_SEL_CANCEL;
  }
  
  return BCR_SEL_NONE;
}

void BtlvUiTarget::SetName(void)
{
  gfl::heap::HeapBase *heapMem = mBtlvCore->GetHeapMem();
  int maxNum = 6;
  switch( mBtlvCore->GetBattleRule() )
  {
  case BTL_RULE_SINGLE:    ///< VO
    maxNum = 2;
    break;
  case BTL_RULE_DOUBLE:    ///< _u
    maxNum = 4;
    break;
//  case BTL_RULE_TRIPLE:    ///< gv
//  case BTL_RULE_ROTATION:  ///< [e[V
//  case BTL_RULE_BAND:      ///< Q
//    break;
  }
  
  static const u32 paneArr[BTL_PARTY_MEMBER_MAX] = 
  {
    PANENAME_BTL_TARGET_PANE_TARGET_NAME_00,
    PANENAME_BTL_TARGET_PANE_TARGET_NAME_01,
    PANENAME_BTL_TARGET_PANE_TARGET_NAME_02,
    PANENAME_BTL_TARGET_PANE_TARGET_NAME_03,
    PANENAME_BTL_TARGET_PANE_TARGET_NAME_04,
    PANENAME_BTL_TARGET_PANE_TARGET_NAME_05,
  };

  gfl::str::StrBuf buf( 32 , heapMem->GetLowerHandle() );
  pml::personal::System *pokeSys = pml::System::PersonalSystem();
  gfl::grp::g2d::LytTextBox *textBox;

  for( int i=0;i<maxNum;i++ )
  {
    const BTL_POKEPARAM *bpp = mBtlvCore->GetBattlePokeParam( i );
    textBox = mLytWk.GetLytWk()->GetTextBoxPane(paneArr[i]);

    if( bpp )
    {
      const PokePara* pp = bpp->GetViewSrcData();
      pp->GetNickName( &buf );

      textBox->SetString(buf.GetPtr());
    }
    else
    {
      buf.SetStr(L"--------");
      textBox->SetString(buf.GetPtr());
    }
    
  }
  

}

}//namespace btl
