//=================================================================================================
/**
 * @file BGMPrepareThread.h
 * @brief BGM̍ĐsXbh
 * @author obata_toshihiro
 * @date 2011.06.30
 */
//=================================================================================================
#ifndef __BGMPREPARETHREAD_H__
#define __BGMPREPARETHREAD_H__
#include <gflib.h>

namespace snd {

  class PokemonSoundSystem;


  class BGMPrepareThread : public gfl::base::Thread
  {
    GFL_FORBID_COPY_AND_ASSIGN( BGMPrepareThread );

    public:

    BGMPrepareThread( 
        gfl::heap::HeapBase* heap_for_stack,
        snd::PokemonSoundSystem* sound_system, u32 sound_item_id );

    ~BGMPrepareThread();


    private:

    static const u32 STACK_SIZE;

    snd::PokemonSoundSystem* m_sound_system;
    u32 m_sound_item_id;
    u32 m_seq;

    // C
    virtual void Main( void ); 
  };


} // namespace snd

#endif // __BGMPREPARETHREAD_H__
