//=================================================================================================
/**
 * @file BGMPrepareThread.cpp
 * @brief BGM̍ĐsXbh
 * @author obata_toshihiro
 * @date 2011.06.30
 */
//=================================================================================================
#include <gflib.h>
#include "BGMPrepareThread.h"

namespace snd {


  const u32 BGMPrepareThread::STACK_SIZE = 1024;


  //-----------------------------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------------------------
  BGMPrepareThread::BGMPrepareThread(
      gfl::heap::HeapBase* heap_for_stack,
      snd::PokemonSoundSystem* sound_system, u32 sound_item_id ) : 
    gfl::base::Thread( heap_for_stack, STACK_SIZE ),
    m_sound_system( sound_system ),
    m_sound_item_id( sound_item_id ),
    m_seq( 0 )
  {
  }


  //-----------------------------------------------------------------------------------------------
  // fXgN^
  //-----------------------------------------------------------------------------------------------
  BGMPrepareThread::~BGMPrepareThread()
  {
  }




  //-----------------------------------------------------------------------------------------------
  // C
  //-----------------------------------------------------------------------------------------------
  void BGMPrepareThread::Main( void )
  {
    switch( m_seq ) {
    case 0:
      m_sound_system->PrepareBGM( m_sound_item_id );
      ++m_seq;
      break;

    case 1:
      if( m_sound_system->IsBGMPrepared() ) {
        this->Kill();  // E
      }
      break;
    }
  }



} // namespace snd
