//=================================================================================================
/**
 * @brief BGMǗNX
 * @file  BGMManager.h
 * @author obata
 * @date   2011.06.29
 */
//=================================================================================================
#ifndef __BGMMANAGER_H__
#define __BGMMANAGER_H__
#include <gflib.h>


namespace snd {

  class PokemonSoundSystem;
  class BGMPrepareThread;


  class BGMManager {
    GFL_FORBID_COPY_AND_ASSIGN( BGMManager ); 

    public:

    BGMManager( gfl::heap::HeapBase* heap, snd::PokemonSoundSystem* sound_system );
    ~BGMManager();


    void Update( void );
    void Reset( void );


    // NGXg̓o^
    void RegisterRequest_FADE_IN( u32 fade_in_frame );
    void RegisterRequest_FADE_OUT( u32 fade_out_frame );
    void RegisterRequest_PUSH( u32 fade_out_frame );
    void RegisterRequest_POP( u32 fade_out_frame, u32 fade_in_frame );
    void RegisterRequest_CHANGE( u32 sound_item_id, u32 fade_out_frame, u32 fade_in_frame );
    void RegisterRequest_STAND_BY( u32 sound_item_id, u32 fade_out_frame );
    void RegisterRequest_FORCE_PLAY( u32 sound_item_id ); 

    // 擾
    bool HaveRequest( void ) const; // ( or  )̃NGXgĂ邩ǂ



    private:

    // VXe
    enum SystemState {
      STATE_STOP,              // ~
      STATE_PLAY,              // Đ
      STATE_WAIT,              // ҋ@
      STATE_FADE_OUT,          // BGMtF[hAEg
      STATE_FADE_IN,           // BGMtF[hC
      STATE_PUSH,              // BGMޔ(tF[hAEg҂)
      STATE_POP_out,           // BGMA(tF[hAEg҂)
      STATE_POP_in,            // BGMA(pops҂)
      STATE_CHANGE_out,        // BGMύX(tF[hAEg҂)
      STATE_CHANGE_load,       // BGMύX([h҂)
      STATE_CHANGE_in,         // BGMύX(tF[hC҂)
      STATE_CHANGE_PUSH_out,   // BGMύXޔ(tF[hAEg҂)
      STATE_CHANGE_PUSH_load,  // BGMύXޔ([h҂)
      STATE_STAND_BY_out,      // BGMĐ(tF[hAEg҂)
      STATE_STAND_BY_load,     // BGMĐ([h҂)
      STATE_NUM
    };

    // NGXg̎
    enum RequestType {
      REQUEST_NONE,        // NGXgȂ  @todo num̌Ɉړ
      REQUEST_FADE_IN,     // BGM tF[hC
      REQUEST_FADE_OUT,    // BGM tF[hAEg
      REQUEST_PUSH,        // BGM ޔ
      REQUEST_POP,         // BGM A
      REQUEST_CHANGE,      // BGM ύX
      REQUEST_STAND_BY,    // BGM Đ
      REQUEST_FORCE_PLAY,  // Đ
      REQUEST_NUM          // 
    };

    // NGXg̏ڍ׃f[^
    struct RequestData { 
      RequestType request_type;  // NGXg̎
      u32 sound_item_id;         // BGM̃TEhACeID
      u32 fade_out_frame;        // ĐBGM̃tF[hAEg t[
      u32 fade_in_frame;         // ĐBGM̃tF[hC t[
    };


    static const u32 SOUND_ITEM_ID_NULL;
    static const u8 REQUEST_QUEUE_SIZE;
    static const u8 RequestAcceptTable[ STATE_NUM ][ REQUEST_NUM ];
    static const u8 DeadRockTable[ REQUEST_NUM ][ REQUEST_NUM ];


    PokemonSoundSystem* m_sound_system;
    gfl::base::Queue<RequestData> m_request_queue; // NGXgL[
    SystemState state;  // ݂̏
    u32  currentBGM;    // ݍĐBGM
    u32  requestBGM;    // NGXgꂽBGM
    u32  loadBGM;       // [hBGM
    u32  loadSeq;       // [h̃V[PX
    u32  fadeInFrame;   // tF[hC t[ 
    u32  fadeOutFrame;  // tF[hAEg t[
    RequestType request;  // ̃NGXg

    gfl::heap::HeapBase* m_heap_for_work;  // Ɨ̈Ɏgpq[v
    BGMPrepareThread* m_bgm_prepare_thread;


    // VXȅ
    void Initialize( void );
    void ResetFieldSoundSystem( void );

    // NGXgL[̑
    void RequestQueueCheck( void );
    bool QueueHaveRequest( void ) const;
    void RegisterNewRequest( const RequestData& requestData );
    // L[ɃNGXgo^ł邩ǂ̔
    bool CanRegisterRequest( RequestType request ) const;

    // NGXg̔s
    void ThrowRequest( const RequestData& requestData );
    void ThrowRequest_FADE_IN( u32 fadeInFrame );
    void ThrowRequest_FADE_OUT( u32 fadeOutFrame );
    void ThrowRequest_PUSH( u32 fadeOutFrame );
    void ThrowRequest_POP( u32 fadeOutFrame, u32 fadeInFrame );
    void ThrowRequest_CHANGE( u32 sound_item_id, u32 fadeOutFrame, u32 fadeInFrame );
    void ThrowRequest_STAND_BY( u32 sound_item_id, u32 fadeOutFrame );
    void ThrowRequest_FORCE_PLAY( u32 sound_item_id );
    // VXeNGXg󗝂ł邩ǂ̔
    bool CanAcceptRequest( RequestType request ) const;
    // NGXgɑ΂铮
    void RequestCheck_STOP            ( void );
    void RequestCheck_PLAY            ( void );
    void RequestCheck_WAIT            ( void );
    void RequestCheck_FADE_OUT        ( void );
    void RequestCheck_FADE_IN         ( void );
    void RequestCheck_PUSH            ( void );
    void RequestCheck_POP_out         ( void );
    void RequestCheck_POP_in          ( void );
    void RequestCheck_CHANGE_out      ( void );
    void RequestCheck_CHANGE_load     ( void );
    void RequestCheck_CHANGE_in       ( void );
    void RequestCheck_CHANGE_PUSH_out ( void );
    void RequestCheck_CHANGE_PUSH_load( void );
    void RequestCheck_STAND_BY_out    ( void );
    void RequestCheck_STAND_BY_load   ( void );
    // 
    void Main_STOP            ( void );
    void Main_PLAY            ( void );
    void Main_WAIT            ( void );
    void Main_FADE_OUT        ( void );
    void Main_FADE_IN         ( void );
    void Main_PUSH            ( void );
    void Main_POP_out         ( void );
    void Main_POP_in          ( void );
    void Main_CHANGE_out      ( void );
    void Main_CHANGE_load     ( void );
    void Main_CHANGE_in       ( void );
    void Main_CHANGE_PUSH_out ( void );
    void Main_CHANGE_PUSH_load( void );
    void Main_STAND_BY_out    ( void );
    void Main_STAND_BY_load   ( void );
    // Ԃ̕ύX
    void ChangeState( SystemState nextState );
    // NGXg󗝏Ԃ̍XV
    void ResetRequest( void );
    void CancelRequest( void );
    void FinishRequest( void ); 

    // BGM̑
    void FadeInBGM( void );
    void FadeOutBGM( void );
    void PushBGM( void );
    void PopBGM ( void );
    //bool DivLoadBGM_start( void );
    //bool DivLoadBGM_load( void );
    void ForcePlayBGM( void );

    void StartAsyncPrepareBGM( void );
    bool IsAsyncPrepareBGMFinished( void ) const;
    void EndAsyncPrepareBGM( void );


#if PM_DEBUG
    void DebugPrint_RequestQueue( void ) const;
    void DebugPrint_AllInfo( void ) const;
#endif
  };


} //namespace snd


#endif // __BGMMANAGER_H__ 




#if 0
// ݓo^Ă郊NGXg_ł, BGMޔ𐔂擾
PushState FIELD_SOUND_GetBGMPushCount_atAllRequestFinished( const FIELD_SOUND* fieldSound );

// ݓo^Ă郊NGXg_ł, ĐBGM擾
u32 FIELD_SOUND_GetPlayingBGM_atAllRequestFinished( const FIELD_SOUND* fieldSound );

// tF[hǂ (TRUE: tF[h)
BOOL FIELD_SOUND_IsBGMFade( const FIELD_SOUND* fieldSound );

// BGM̕ASďIǂ`FbN
BOOL FIELD_SOUND_CheckBGMPopFinished( const FIELD_SOUND* fieldSound );
//=================================================================================
// vC[{[
//
// {IɎgpȂłB
// @field_sound.h ɐ錾Ă֐gĂB
//=================================================================================
extern void FIELD_SOUND_ChangePlayerVolume( FIELD_SOUND* fieldSound, u8 volume, u8 fadeFrame );
#endif
