//============================================================================================
/**
 * @file		item_manager.cpp
 * @brief		ACef[^}l[W
 * @author	Hiroyuki Nakamura
 * @date		11.06.30
 *
 * class		itemman::ITEM_MANAGER::
 */
//============================================================================================
#include "item/item_manager.h"


namespace itemman {


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		pHeap				q[v
 * @param		cacheSize		LbVTCYij
 * @param		mode				ǂݍ݃[hiftHgMSG_LOAD_NULLj
 * @param		typeName		Õf[^[h`iftHgLOAD_PARTj
 * @param		typeInfo		̃f[^[h`iftHgLOAD_PARTj
 */
//--------------------------------------------------------------------------------------------
ITEM_MANAGER::ITEM_MANAGER(
	gfl::heap::HeapBase * pHeap, int cacheSize, MSG_LOAD_MODE mode,
	gfl::str::MsgData::LoadType typeName, gfl::str::MsgData::LoadType typeInfo )
{
	arcFile  = GFL_NEW( pHeap ) gfl::fs::ArcFile( ARCID_ITEM_DATA );
	itemData = GFL_NEW( pHeap ) item::ITEM_DATA[cacheSize];
	cacheMax = cacheSize;

	if( mode & MSG_LOAD_NAME ){
		mdName = item::ITEM_CreateItemNameMsgData( typeName, pHeap );
	}else{
		mdName = NULL;
	}
	if( mode & MSG_LOAD_INFO ){
		mdInfo = item::ITEM_CreateInfoMsgData( typeInfo, pHeap );
	}else{
		mdInfo = NULL;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
ITEM_MANAGER::~ITEM_MANAGER(void)
{
	if( mdName != NULL ){
		item::ITEM_DeleteItemNameMsgData( mdName );
	}
	if( mdInfo != NULL ){
		item::ITEM_DeleteInfoMsgData( mdInfo );
	}
	GFL_DELETE	[]itemData;
	GFL_DELETE	arcFile;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACef[^擾
 *
 * @param		itemID	ACeԍ
 * @param		dat			擾ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ITEM_MANAGER::GetData( int itemID, item::ITEM_DATA & dat )
{
	item::ITEM_DATA * buf;
	int	i;
	
	buf = NULL;

	for( i=0; i<cacheMax; i++ ){
		int prm = itemData[i].GetParam( item::ITEM_DATA::PRM_ID_ITEMNUMBER );
		// mۍς
		if( prm == itemID ){
			dat = itemData[i];
//			GFL_PRINT( "CACHE :\n" );
			return;
		}
		// 󂫂
		if( prm == ITEM_DUMMY_DATA ){
			buf = &itemData[i];
//			GFL_PRINT( "NEW :\n" );
			break;
		}
	}

	// 󂫂Ȃ
	if( buf == NULL ){
		// ԌÂf[^폜
		for( i=0; i<cacheMax-1; i++ ){
			itemData[i] = itemData[i+1];
		}
		buf = &itemData[cacheMax-1];
//		GFL_PRINT( "SORT :\n" );
	}

	// ǂݍ
	buf->Create( itemID, arcFile );
	dat = *buf;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACep[^擾
 *
 * @param		itemID	ACeԍ
 * @param		prmID		p[^ID
 *
 * @return	wp[^
 */
//--------------------------------------------------------------------------------------------
int ITEM_MANAGER::GetParam( int itemID, item::ITEM_DATA::ITEM_PRM_ID prmID )
{
	item::ITEM_DATA	dat;

	GetData( itemID, dat );
	return dat.GetParam( prmID );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACe擾iACef[^j
 *
 * @param		dat		ACef[^
 * @param		buf		i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ITEM_MANAGER::GetName( item::ITEM_DATA * dat, gfl::str::StrBuf * buf )
{
	dat->ITEM_GetItemName( mdName, buf );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACe擾iACeԍj
 *
 * @param		itemID	ACeԍ
 * @param		buf			i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ITEM_MANAGER::GetName( int itemID, gfl::str::StrBuf * buf )
{
	mdName->GetString( itemID, *buf );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACe擾iACef[^j
 *
 * @param		dat		ACef[^
 * @param		buf		i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ITEM_MANAGER::GetInfo( item::ITEM_DATA * dat, gfl::str::StrBuf * buf )
{
	dat->ITEM_GetInfo( mdInfo, buf );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ACe擾iACeԍj
 *
 * @param		itemID	ACeԍ
 * @param		buf			i[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ITEM_MANAGER::GetInfo( int itemID, gfl::str::StrBuf * buf )
{
	mdInfo->GetString( itemID, *buf );
}


}	// itemman
