//============================================================================================
/**
 * @file		item_manager.h
 * @brief		ACef[^}l[W
 * @author	Hiroyuki Nakamura
 * @date		11.06.30
 *
 * class		itemman::ITEM_MANAGER::
 */
//============================================================================================
#pragma	once

#include <gflib.h>
#include "item.h"


namespace itemman {

class ITEM_MANAGER {
public:
	// ֘Aǂݍݒ`
	typedef enum {
		MSG_LOAD_NULL = 0,		// ǂݍ܂Ȃ
		MSG_LOAD_NAME,				// Ô
		MSG_LOAD_INFO,				// ̂
		MSG_LOAD_NAMEINFO,		// OƐ
	}MSG_LOAD_MODE;

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		pHeap				q[v
	 * @param		cacheSize		LbVTCYij
	 * @param		mode				ǂݍ݃[hiftHgMSG_LOAD_NULLj
	 * @param		typeName		Õf[^[h`iftHgLOAD_PARTj
	 * @param		typeInfo		̃f[^[h`iftHgLOAD_PARTj
	 */
	//--------------------------------------------------------------------------------------------
	ITEM_MANAGER(
		gfl::heap::HeapBase * pHeap,
		int cacheSize,
		MSG_LOAD_MODE mode = MSG_LOAD_NULL,
		gfl::str::MsgData::LoadType typeName = gfl::str::MsgData::LOAD_PART,
		gfl::str::MsgData::LoadType typeInfo = gfl::str::MsgData::LOAD_PART );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~ITEM_MANAGER(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACef[^擾
	 *
	 * @param		itemID	ACeԍ
	 * @param		dat			擾ꏊ
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void GetData( int itemID, item::ITEM_DATA & dat );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACep[^擾
	 *
	 * @param		itemID	ACeԍ
	 * @param		prmID		p[^ID
	 *
	 * @return	wp[^
	 */
	//--------------------------------------------------------------------------------------------
	int GetParam( int itemID, item::ITEM_DATA::ITEM_PRM_ID prmID );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACe擾iACef[^j
	 *
	 * @param		dat		ACef[^
	 * @param		buf		i[ꏊ
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void GetName( item::ITEM_DATA * dat, gfl::str::StrBuf * buf );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACe擾iACeԍj
	 *
	 * @param		itemID	ACeԍ
	 * @param		buf			i[ꏊ
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void GetName( int itemID, gfl::str::StrBuf * buf );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACe擾iACef[^j
	 *
	 * @param		dat		ACef[^
	 * @param		buf		i[ꏊ
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void GetInfo( item::ITEM_DATA * dat, gfl::str::StrBuf * buf );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ACe擾iACeԍj
	 *
	 * @param		itemID	ACeԍ
	 * @param		buf			i[ꏊ
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void GetInfo( int itemID, gfl::str::StrBuf * buf );

private:
	gfl::fs::ArcFile * arcFile;		// A[JCut@C
	item::ITEM_DATA * itemData;		// ACef[^
	int cacheMax;									// LbVő吔

	gfl::str::MsgData * mdName;		// bZ[Wf[^FO
	gfl::str::MsgData * mdInfo;		// bZ[Wf[^F
};

}	// itemman
