//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		ParticleTest.cpp
 *	@brief  kujirał̃p[eBÑeXg
 *	@author	Koji Kawada
 *	@date		2011.06.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

// CTR_SDK

// NW4C

// gflib
#include <gflib.h>

// xy_project
#include "system/main.h"           // HEAP_DEFINE
#include "gamesystem/GameProc.h"

// test/kawada
#include "ParticleTest.h"


#if 0
ӎ
(1) ʊE[xOɂĂƁB
      ʂ̕`ăfvXobt@𖄂߂ĂB
      GbW}bvĂiGbW}bv̉Ԏ؂肵Ă炵̂ŁjB
#endif

#if 0
Ăs
(1) ʊE[x2DrawƎ~܂
#define TEST_KAWADA_PARTICLE_TEST_DEPTH    (1)  // ʊE[x
#define TEST_KAWADA_PARTICLE_TEST_PARTICLE (0)  // p[eBN
#define TEST_KAWADA_PARTICLE_TEST_BLOOM    (1)  // u[
#define TEST_KAWADA_PARTICLE_TEST_EDGE     (1)  // GbW
      m_scene->StereoDrawPostDepthOfFieldAO2ĂԂ
GpuWaitDone Timeout GPU HW STATE 0x17f03
Failed assertion at gfl_CommandListManager.cpp:1108
  0
      ƂG[Ŏ~܂B
      ǂ炩1ȂOKB
      A̓tB[hł͋NȂB
         }ɋNȂȂBRB 

(2)
#define TEST_KAWADA_PARTICLE_TEST_DEPTH    (1)  // ʊE[x
#define TEST_KAWADA_PARTICLE_TEST_PARTICLE (1)  // p[eBN
#define TEST_KAWADA_PARTICLE_TEST_BLOOM    (1)  // u[
#define TEST_KAWADA_PARTICLE_TEST_EDGE     (1)  // GbW




#endif

// ؂ւ
#define TEST_KAWADA_PARTICLE_TEST_DEPTH    (1)  // ʊE[x
#define TEST_KAWADA_PARTICLE_TEST_PARTICLE (1)  // p[eBN
#define TEST_KAWADA_PARTICLE_TEST_BLOOM    (1)  // u[
#define TEST_KAWADA_PARTICLE_TEST_EDGE     (1)  // GbW


namespace test {
namespace kawada {
namespace particle_test {


// \[X
enum
{
  RESOURCE_MODEL,
  RESOURCE_TEX,
  RESOURCE_EFFECT,
  RESOURCE_LIGHT,
  RESOURCE_SCENE_ENVIRONMENT_SETTING,
  RESOURCE_MAX
};

static const char* RESOURCE_FILES[RESOURCE_MAX] =
{
  //"rom:/""g3d_sample_data/Male.bcmdl",
  "rom:/""field/player.bcmdl",
  "rom:/""g3d_sample_data/Male.bctex",
  "rom:/""g3d_sample_data/ToyMobileEffect.bcres",
  "rom:/""g3d_sample_data/FragmentLight.bcenv",
  "rom:/""g3d_sample_data/SceneEnvironmentSetting.bcenv",
};

// V[ݒ
enum
{
  SCENE_CALCULATE_GROUP_ALL = 0,
  SCENE_CALCULATE_GROUP_MAX
};

enum
{
  SCENE_DRAW_GROUP_MODEL                         = 0,
  SCENE_DRAW_GROUP_EDGE_MAP                     ,
  SCENE_DRAW_GROUP_EDGE_POST                    ,
  SCENE_DRAW_GROUP_BLOOM_HIGH_LUMINANCE         ,
  SCENE_DRAW_GROUP_BLOOM_BOARD                  ,
  SCENE_DRAW_GROUP_SHADOW                       ,
  SCENE_DRAW_GROUP_PARTICLE                     ,

  SCENE_DRAW_GROUP_MAX
};

enum
{
  CAMERA_INDEX_MAIN,
  CAMERA_INDEX_BLOOM
};


//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result ParticleTestProc::InitFunc(gfl::proc::Manager* /*pManager*/)
{
  // Y`FbN
  DumpMemory("[Start]");

  // 
  {
    gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
    gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

    gfl::heap::HeapBase* local_heap_memory   = gfl::heap::Manager::CreateHeap(
        heap_memory,   HEAPID_TEST_KAWADA_HEAP,   heap_memory->GetTotalAllocatableSize(),   gfl::heap::HEAP_TYPE_EXP );
    gfl::heap::HeapBase* local_device_memory = gfl::heap::Manager::CreateHeap(
        device_memory, HEAPID_TEST_KAWADA_DEVICE, device_memory->GetTotalAllocatableSize(), gfl::heap::HEAP_TYPE_EXP );

    // AP[^
    m_heap_allocator    = GFL_NEW(local_heap_memory)   gfl::heap::NwAllocator(local_heap_memory);
    m_device_allocator  = GFL_NEW(local_device_memory) gfl::heap::NwAllocator(local_device_memory);
  }

  // ui
  m_device_manager = GFL_NEW(m_heap_allocator->GetHeapBase()) gfl::ui::CTR_DeviceManager(m_heap_allocator->GetHeapBase());


  // OtBbNXVXe
const gfl::grp::GraphicsSystemSetUp GraphicsSetUp = {
  gfl::grp::MODE_DOUBLE_BUFFER,                     // obt@O[h
  true,                                             // Eڂgp邩B
  true,                                             // ̎OnԂŏ邩B

  // fBXvCobt@
  {                                       
    // DisplayBuffer UPPER
    {
      gfl::grp::DISPLAY_UPPER,            // fBXvC̎ނłB
      400,                                // fBXvC̉łB
      240,                                // fBXvC̏cłB
      gfl::grp::TRANSFER_MODE_ANTIALIASE_NOT_USED,  // eBXvCobt@̓][hłB
      gfl::grp::MEMORY_AREA_VRAMB,        // mۃGAłB
      gfl::grp::RENDER_COLOR_FORMAT_RGB8,// J[tH[}bgł
      false,                              // ]ɂwɃtbv邩ǂ\܂B
      0,                                  // \sn_wWłB
      0                                   // \sn_xWłB
    },
    // DisplayBuffer LOWER
    {
      gfl::grp::DISPLAY_LOWER,            // fBXvC̎ނłB
      320,                                // fBXvC̉łB
      240,                                // fBXvC̏cłB
      gfl::grp::TRANSFER_MODE_ANTIALIASE_NOT_USED,  // eBXvCobt@̓][hłB
      gfl::grp::MEMORY_AREA_VRAMA,        // mۃGAłB
      gfl::grp::RENDER_COLOR_FORMAT_RGB8,// J[tH[}bgł
      false,                              // ]ɂwɃtbv邩ǂ\܂B
      0,                                  // \sn_wWłB
      0                                   // \sn_xWłB
    },
    // DisplayBuffer UPPER_RIGHT
    {
      gfl::grp::DISPLAY_UPPER_RIGHT,      // fBXvC̎ނłB
      400,                                // fBXvC̉łB
      240,                                // fBXvC̏cłB
      gfl::grp::TRANSFER_MODE_ANTIALIASE_NOT_USED,  // eBXvCobt@̓][hłB
      gfl::grp::MEMORY_AREA_VRAMB,        // mۃGAłB
      gfl::grp::RENDER_COLOR_FORMAT_RGB8,// J[tH[}bgł
      false,                              // ]ɂwɃtbv邩ǂ\܂B
      0,                                  // \sn_wWłB
      0                                   // \sn_xWłB
    },
  },

  // t[obt@
  {
    // FrameBuffer UPPER
    {
      gfl::grp::DISPLAY_UPPER,                      // ʗp
      512,                                // obt@̉łB
      256,                                // obt@̏cłB
      gfl::grp::RENDER_COLOR_FORMAT_RGBA8,          // J[obt@tH[}bg
      gfl::grp::RENDER_DEPTH_FORMAT_24_STENCIL8,    // [xobt@tH[}bg
      gfl::grp::MEMORY_AREA_VRAMA,                  // `Ώۂ̃J[obt@̔zuꏊłB
      gfl::grp::MEMORY_AREA_VRAMB,                  // `Ώۂ̃fvXobt@̔zuꏊłB
      gfl::grp::DISPLAY_NONE,                       // ̃t[obt@IWi
      0,
      0,
      400,
      240,
    },

    // FrameBuffer LOWER
    {
      gfl::grp::DISPLAY_LOWER,                      // ʗp
      320,                                // obt@̉łB
      240,                                // obt@̏cłB
      gfl::grp::RENDER_COLOR_FORMAT_RGBA8,          // J[obt@tH[}bg
      gfl::grp::RENDER_DEPTH_FORMAT_24_STENCIL8,    // [xobt@tH[}bg
      gfl::grp::MEMORY_AREA_NONE,                   // `Ώۂ̃J[obt@̔zuꏊłB
      gfl::grp::MEMORY_AREA_NONE,                   // `Ώۂ̃fvXobt@̔zuꏊłB
      gfl::grp::DISPLAY_UPPER,                      // UPPER̃t[obt@𗬗p
      0,
      0,
      320,
      240,
    },

    // FrameBuffer UPPER_RIGHT
    {
      gfl::grp::DISPLAY_UPPER_RIGHT,                // ʗp
      512,                                // obt@̉łB
      256,                                // obt@̏cłB
      gfl::grp::RENDER_COLOR_FORMAT_RGBA8,          // J[obt@tH[}bg
      gfl::grp::RENDER_DEPTH_FORMAT_24_STENCIL8,    // [xobt@tH[}bg
      gfl::grp::MEMORY_AREA_NONE,                   // `Ώۂ̃J[obt@̔zuꏊłB
      gfl::grp::MEMORY_AREA_NONE,                   // `Ώۂ̃fvXobt@̔zuꏊłB
      gfl::grp::DISPLAY_UPPER,                      // UPPER̃t[obt@𗬗p
      0,
      0,
      400,
      240,
    },
  },

  // R}hXgݒ
  {
    // MAIN
    {
      0x30000,                 // obt@TCYiR}hobt@̑TCYj
      256,                       // L[COR}h
    },

    // UPPER
    {
      0x60000,                 // obt@TCYiR}hobt@̑TCYj
      64,                      // L[COR}h
    },

    // LOWER
    {
      0x40000,                 // obt@TCYiR}hobt@̑TCYj
      32,                      // L[COR}h
    },
  },

  // Z[uR}hXgݒ
  {
    0xD0000,                 // obt@TCYiR}hobt@̑TCYj
    64,                      // L[COR}h
  },

  // NAJ[
  {
    // ClearColor UPPER
    {
      0.20f, 0.20f, 0.20f, 1.0f, 1.0f, 0
    },

    // ClearColor LOWER
    {
      0.20f, 0.20f, 0.20f, 1.0f, 1.0f, 0
    },
  },
  
};
  m_graphics_system = GFL_NEW(m_heap_allocator->GetHeapBase()) gfl::grp::GraphicsSystem( m_heap_allocator, m_device_allocator, &GraphicsSetUp );

  // g3d
  m_system = GFL_NEW(m_heap_allocator->GetHeapBase()) gfl::grp::g3d::System( m_heap_allocator, m_device_allocator );

  // DrawUtil 
  gfl::grp::util::DrawUtil::Initialize( m_graphics_system, m_heap_allocator, m_device_allocator );

  gfl::grp::g3d::Scene::Description scene_description;
  scene_description.scene_calculate_group_num = SCENE_CALCULATE_GROUP_MAX;
  scene_description.scene_draw_group_num      = SCENE_DRAW_GROUP_MAX;
  m_scene  = GFL_NEW(m_heap_allocator->GetHeapBase()) gfl::grp::g3d::Scene( m_device_allocator, &scene_description );

#if TEST_KAWADA_PARTICLE_TEST_EDGE
      // GbW
      {
        gfl::grp::RenderTarget::Description   rtDesc;
        gfl::grp::FrameBufferManager          *frame_buffer_manager = m_graphics_system->GetFrameBufferManager();
        gfl::grp::RenderTarget                *left_render_target = frame_buffer_manager->GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID(gfl::grp::DISPLAY_UPPER) );
  
        rtDesc.depth_address = left_render_target->GetDepthAddress();
        rtDesc.depth_area = gfl::grp::MEMORY_AREA_VRAMB;
        m_scene->CreateEdgeMapSystem( m_heap_allocator, m_device_allocator, SCENE_DRAW_GROUP_EDGE_MAP, &rtDesc );
      }
#endif

#if TEST_KAWADA_PARTICLE_TEST_DEPTH
      //ʊE[x
      m_scene->CreateDepthOfFieldSystem( m_heap_allocator, m_device_allocator, m_graphics_system );
#endif

  const u8 EDGE_COLOR[4] = { 0,0,0, 255 };

    {
#if TEST_KAWADA_PARTICLE_TEST_BLOOM
      // u[tB^
#if 0
      // ŒႱꂭ炢͕Kv
      static const u32 BLOOM_BOARD_NUM = 3;
      gfl::grp::g3d::BloomFilter::BloomBoardDescription bloom_board_description[BLOOM_BOARD_NUM] =
      {
        { 2, gfl::math::VEC2( 0.000f, 0.000f), 1.0f },
        { 2, gfl::math::VEC2( 0.002f, 0.002f), 0.5f },
        { 2, gfl::math::VEC2(-0.002f,-0.002f), 0.5f },
      };
#else
      // KEVAtB^
      // 3*3͕164,2,1
      // 5*5͕25636,24,16,6,4,1
      static const u32 BLOOM_BOARD_NUM = 9;
      static const f32 BLOOM_BAIRITSU = 2.0f;
      static const u32 BLOOM_SMALL_IMAGE_NUM = 2;//1;//2;
      gfl::grp::g3d::BloomFilter::BloomBoardDescription bloom_board_description[BLOOM_BOARD_NUM] =
      {
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2( 0.000f, 0.000f), 4.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2( 0.002f, 0.000f), 2.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2(-0.002f, 0.000f), 2.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2( 0.000f, 0.002f), 2.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2( 0.000f,-0.002f), 2.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2( 0.002f, 0.002f), 1.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2( 0.002f,-0.002f), 1.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2(-0.002f, 0.002f), 1.0f/16.0f *BLOOM_BAIRITSU },
        { BLOOM_SMALL_IMAGE_NUM, gfl::math::VEC2(-0.002f,-0.002f), 1.0f/16.0f *BLOOM_BAIRITSU },
      };
#endif
      gfl::grp::g3d::BloomFilter::Description bloom_filter_description;
      gfl::grp::g3d::BloomFilter::InitializeDescription(
        &bloom_filter_description,
        512,
        256,
        gfl::grp::g3d::Texture::FORMAT_RGBA8,
        gfl::grp::MEMORY_AREA_VRAMB,//gfl::grp::MEMORY_AREA_VRAMA,
        0,
        SCENE_DRAW_GROUP_BLOOM_HIGH_LUMINANCE,
        gfl::grp::ColorF32(0.3333f,0.3333f,0.3333f,1.0f),
        0.3f,
        BLOOM_SMALL_IMAGE_NUM,
        0,
        SCENE_DRAW_GROUP_BLOOM_BOARD,
        BLOOM_BOARD_NUM,
        bloom_board_description,
        0,
        CAMERA_INDEX_BLOOM,
        gfl::grp::MEMORY_AREA_VRAMB
      );
#endif

#if TEST_KAWADA_PARTICLE_TEST_EDGE || TEST_KAWADA_PARTICLE_TEST_BLOOM
      // |XgGtFNg
      gfl::grp::g3d::G3DPostEffectSystem::Description   desc;
#if TEST_KAWADA_PARTICLE_TEST_EDGE
      desc.edge_draw_group_id = SCENE_DRAW_GROUP_EDGE_POST;
      desc.edge_enable = true;
      desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::INSIDE_EDGE;
#endif
#if TEST_KAWADA_PARTICLE_TEST_BLOOM
      desc.bloom_filter_enable = true;
      desc.bloom_filter_description = &bloom_filter_description;
#endif

      m_scene->CreatePostEffectSystem( m_heap_allocator, m_device_allocator, &desc, m_graphics_system,  gfl::grp::MEMORY_AREA_VRAMA );

#if TEST_KAWADA_PARTICLE_TEST_EDGE
      m_scene->SetEdgeColor( 
          static_cast<f32>(EDGE_COLOR[0]) / 255.0f, 
          static_cast<f32>(EDGE_COLOR[1]) / 255.0f,
          static_cast<f32>(EDGE_COLOR[2]) / 255.0f );
      
      m_scene->EdgeMapTex1Enable( true );//@todo Œ
      m_scene->EdgeMapVColAEnable( true );//@todo Œ
#endif

#if TEST_KAWADA_PARTICLE_TEST_BLOOM
      // u[tB^lݒ
      m_scene->SetBloomHighLuminanceColorWeight( gfl::grp::ColorF32(0.3333f, 0.3333f, 0.3333f, 1.0f) );
      m_scene->SetBloomHighLuminanceMinValue( 0.3f );
#endif
#endif  // #if TEST_KAWADA_PARTICLE_TEST_EDGE || TEST_KAWADA_PARTICLE_TEST_BLOOM
    }

  // J
  m_camera = GFL_NEW(m_device_allocator->GetHeapBase()) gfl::debug::DebugG3dStereoCamera();
  m_camera->Create(
      m_device_allocator,
      gfl::math::VEC3(0.0f, 0.0f, 45.0f),
      gfl::math::VEC3(0.0f, 0.0f, 0.0f)
  );
  m_camera->SetAspect(400.0f/240.0f);
  m_scene->AddSceneNode( m_camera );
  m_scene->AssignCameraIndex( m_camera, CAMERA_INDEX_MAIN );

  // \[X
  m_resource_array = GFL_NEW(m_heap_allocator->GetHeapBase()) gfl::grp::g3d::Resource[RESOURCE_MAX];
  for( s32 i=0; i<RESOURCE_MAX; ++i )
  {
    if( i == RESOURCE_EFFECT )
    {
      m_resource_array[i].LoadAndSetup(m_device_allocator, RESOURCE_FILES[i], NULL, gfl::grp::g3d::Resource::COMMON_RESOURCE_PARTICLE_DEFAULT_SHADER_BIT);
    }
    else
    {
      m_resource_array[i].LoadAndSetup(m_device_allocator, RESOURCE_FILES[i]);
    }
  }
  m_resource_array[RESOURCE_MODEL].Setup(m_device_allocator, &m_resource_array[RESOURCE_TEX] );

  for( s32 i=0; i<RESOURCE_MAX; ++i )
  {
    if( i == RESOURCE_EFFECT )
    {
      // Ȃ
    }
    else
    {
      m_scene->BuildSceneUsingResource( m_device_allocator, m_device_allocator, &(m_resource_array[i]) );
    }
  }

#if TEST_KAWADA_PARTICLE_TEST_PARTICLE
  // p[eBN
  m_particle = GFL_NEW(m_heap_allocator->GetHeapBase()) gfl::grp::g3d::G3DPTCParticle;
  m_particle->Create( m_heap_allocator, m_device_allocator, &m_resource_array[RESOURCE_EFFECT] );
  m_scene->AddParticleToSceneCalculateGroup( m_particle, SCENE_CALCULATE_GROUP_ALL );
  m_scene->RemoveParticleFromAllSceneDrawGroup( m_particle );
  m_scene->AddParticleToSceneDrawGroup( m_particle, SCENE_DRAW_GROUP_PARTICLE );
#endif

#if TEST_KAWADA_PARTICLE_TEST_EDGE
  // f
  gfl::grp::g3d::Model* model = m_scene->GetOwnModel( m_resource_array[RESOURCE_MODEL].GetId(), 0 );
  for( s32 i=0; i<model->GetMaterialCount(); ++i )
  {
    model->SetMaterialLightSetIndex(i, 0);
  }
  m_scene->SwitchEdgeMapModel( model, true );
#endif

  // V[
  m_scene->Initialize();
  m_scene->SetSceneEnvironmentUsingOwnObject();

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result ParticleTestProc::UpdateFunc(gfl::proc::Manager* /*pManager*/)
{
  do
  {
    b32 b_camera_control = false;

    gfl::ui::Button*       button    = m_device_manager->GetButton(0);
    gfl::ui::VectorDevice* cross_key = m_device_manager->GetCrossKey(0);
    gfl::ui::VectorDevice* stick     = m_device_manager->GetStick(0);
    
    // ui
    m_device_manager->Main();

    // J삩ȊȎ삩
    if( button->IsHold( gfl::ui::BUTTON_R ) )
    {
      b_camera_control = true;
    }

    // 
    if( !b_camera_control )
    {
    }

    // J
    if( b_camera_control )
    {
      m_camera->Control(m_device_manager);
    }

    // V[XV܂B
    m_scene->Calculate(); 

    // _ɈˑXVRenderQueue̍\zs
    m_scene->SubmitView(m_camera, true,  true,  SCENE_DRAW_GROUP_MODEL);
#if TEST_KAWADA_PARTICLE_TEST_EDGE 
    m_scene->SubmitViewOfEdge(m_camera);
#endif
#if TEST_KAWADA_PARTICLE_TEST_BLOOM
    m_scene->SubmitViewOfBloom();
#endif
#if TEST_KAWADA_PARTICLE_TEST_PARTICLE
    m_scene->SubmitView(m_camera, false, false, SCENE_DRAW_GROUP_PARTICLE);
#endif

    // `
    m_graphics_system->StartRendering();
    
    gfl::grp::RenderTarget* lower_render_target       = m_graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_LOWER ) );
    gfl::grp::RenderTarget* upper_render_target       = m_graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
    gfl::grp::RenderTarget* upper_right_render_target = m_graphics_system->GetFrameBufferManager()->\
        GetRenderTarget( m_graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER_RIGHT ) );

    m_scene->Draw(
        m_graphics_system, 
        m_camera,
        lower_render_target,
        SCENE_DRAW_GROUP_MODEL
    );

#if TEST_KAWADA_PARTICLE_TEST_EDGE 
        m_scene->StereoEdgeMapDraw(m_graphics_system, m_camera);
#endif

    m_scene->CommandSaveStereoDraw(
        m_graphics_system,
        m_camera,
        upper_render_target,
        upper_right_render_target,
        SCENE_DRAW_GROUP_MODEL
    );

#if TEST_KAWADA_PARTICLE_TEST_EDGE || TEST_KAWADA_PARTICLE_TEST_BLOOM
      m_scene->StereoPostEffectDraw(m_graphics_system, m_camera);
#endif

#if TEST_KAWADA_PARTICLE_TEST_DEPTH
      {
        // 
        {
          static f32      focusLength = 320.0f;
          //ȉAݒ֐͖t[ĂԕKv͖łB
          m_scene->SetDofType( gfl::grp::g3d::DofType::Back );
          m_scene->SetFocusLength( focusLength );
          m_scene->SetFocusRange( 0,  0.0f, 0.2f );
          m_scene->SetFocusRange( 1, 20.0f, 0.4f );
          m_scene->SetFocusRange( 2, 35.0f, 0.6f );
          m_scene->SetFocusRange( 3, 50.0f, 0.8f );
          //`֐
          m_scene->StereoDrawPostDepthOfField( m_graphics_system, m_camera );
        }

        // O
        {
          static f32      focusLength2 = 110.0f;
          //ȉAݒ֐͖t[ĂԕKv͖łB
          m_scene->SetDofType( gfl::grp::g3d::DofType::Front );
          m_scene->SetFocusLength( focusLength2 );
          m_scene->SetFocusRange( 0,  0.0f, 0.6f );
          m_scene->SetFocusRange( 1, -6.0f, 0.9f );
          m_scene->SetFocusRange( 2, -12.0f, 1.0f );
          m_scene->SetFocusRange( 3, -18.0f, 1.0f );
          //`֐
          m_scene->StereoDrawPostDepthOfField( m_graphics_system, m_camera );
        }
      }
#endif

#if TEST_KAWADA_PARTICLE_TEST_PARTICLE
    m_scene->CommandSaveStereoDraw(
        m_graphics_system,
        m_camera,
        upper_render_target,
        upper_right_render_target,
        SCENE_DRAW_GROUP_PARTICLE
    );
#endif

    m_graphics_system->EndRendering();

    // `XV
    m_graphics_system->SwapBuffer();

    gfl::grp::GraphicsSystem::WaitVSync(gfl::grp::DISPLAY_BOTH_MAX);
   
    // obt@Xbv
    m_graphics_system->VSyncAfter();

    // ui
    if( button->IsTrigger( gfl::ui::BUTTON_START ) )
    {
      break;
    }
  
    return gfl::proc::RES_CONTINUE;
  }
  while(0);

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result ParticleTestProc::EndFunc(gfl::proc::Manager* /*pManager*/)
{
  // g3d
  m_scene->RemoveAllSceneNodes();
  GFL_DELETE m_particle;
  m_scene->DestroyOwnObject();
  GFL_DELETE_ARRAY m_resource_array;
  GFL_DELETE m_camera;
  GFL_DELETE m_scene;
  GFL_DELETE m_system;

  // DrawUtil 
  gfl::grp::util::DrawUtil::Terminate();

  // OtBbNXVXe
  GFL_DELETE m_graphics_system;

  // ui
  GFL_DELETE m_device_manager;

  // 
  {
    gfl::heap::HeapBase* local_heap_memory   = m_heap_allocator->GetHeapBase();
    gfl::heap::HeapBase* local_device_memory = m_device_allocator->GetHeapBase();

    // AP[^
    GFL_DELETE  m_device_allocator;
    GFL_DELETE  m_heap_allocator;
    
    gfl::heap::Manager::DeleteHeap(local_device_memory);
    gfl::heap::Manager::DeleteHeap(local_heap_memory);
  }

  // Y`FbN
  DumpMemory("[End]");

  return gfl::proc::RES_FINISH;
}

// Y`FbN
void ParticleTestProc::DumpMemory(const char* message)  // s͂Ȃł
{
  // 
  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  // Y`FbN
  GFL_PRINT("%s\n", message);
  GFL_PRINT("heap_memory\n");
  heap_memory->Dump();
  GFL_PRINT("\n");
  GFL_PRINT("device_memory\n");
  device_memory->Dump();
  GFL_PRINT("\n");
}

}  // namespace particle_test
}  // namespace kawada
}  // namespace test

