//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldMoveModelEffect.cpp
 *	@brief  샂fGtFNg
 *	@author	tomoya takahashi
 *	@date		2011.06.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "FieldMoveModelEffect.h"

#include "FieldMoveModelEffect_EncKusa00.h"

#include "arc/arc_def.h"
#include "arc/mmodel_effect.gaix"



namespace field{
  namespace mmodel{



//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
    const u32 MoveModelEffectManager::LoadResourceIndex[RES_MAX] = {
      GARC_mmodel_effect_enkusa_yure_BCMDL,
      GARC_mmodel_effect_enkusa_yure_BCMDLA,
      GARC_mmodel_effect_enkusa_yure_BCSKLA,
    };


//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
    //----------------------------------------------------------------------------
    /**
     *	@brief  [N̏
     *
     *	@param	p_wk        [N
     *	@param	p_manager   }l[W
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectBase::InitializeWork( Work* p_wk, MoveModelEffectManager* p_manager )
    {
      gfl::std::MemClear( p_wk, sizeof(Work) );
      p_wk->pManager = p_manager;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  ̐ݒ
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectBase::SetUpModel( Work* p_wk, MoveModelBase* p_model, const MoveModelEffectBase* cpFunc )
    {
      if( p_wk->flag ){
        GFL_ASSERT(0);
        ClearModel( p_wk );
      }
      
      p_wk->pModelBase = p_model;
      p_wk->cpFunc     = cpFunc;
      p_wk->seq        = 0;
      p_wk->flag       = true;
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  ̃NA
     *
     *	@param	p_wk  [N
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectBase::ClearModel( Work* p_wk )
    {
      if( p_wk->flag ){
        if( p_wk->seq > SEQ_INIT ){
          p_wk->cpFunc->DeleteFunc( p_wk->m_Buffer, p_wk->pManager, p_wk->pModelBase );
        }
        p_wk->flag = false;
      }
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  s
     *
     *	@param	p_wk 
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectBase::UpdateModel( Work* p_wk, gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_device )
    {
      if( !p_wk->flag ){
        return ;
      }
      
      switch( p_wk->seq ){
      case SEQ_INIT:
        GFL_ASSERT_STOP( p_wk->cpFunc->GetWorkSize() < BUFFER_MAX );
        
        p_wk->cpFunc->InitFunc( p_wk->m_Buffer, p_wk->pManager, p_wk->pModelBase, p_heap, p_device );
        ++ p_wk->seq;
        break;

      case SEQ_UPDATE:
        if( p_wk->cpFunc->UpdateFunc( p_wk->m_Buffer, p_wk->pManager, p_wk->pModelBase ) )
        {
          ++ p_wk->seq;
        }
        break;
        
      case SEQ_DELETE:
        ClearModel( p_wk );
        break;
      }
    }


    //----------------------------------------------------------------------------
    /**
     *	@brief  tO̎擾
     *
     *	@return gpǂH
     */
    //-----------------------------------------------------------------------------
    bool MoveModelEffectBase::GetUseFlag( const Work* cp_wk )
    {
      return cp_wk->flag;
    }
    





    //----------------------------------------------------------------------------
    /**
     *	@brief  RXgN^
     */
    //-----------------------------------------------------------------------------
    MoveModelEffectManager::MoveModelEffectManager( void ) :
      m_pResourceArray(NULL),
      m_pWorkArray(NULL),
      m_WorkMax(0)
    {
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  fXgN^
     */
    //-----------------------------------------------------------------------------
    MoveModelEffectManager::~MoveModelEffectManager()
    {
      this->Finalize();
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  
     *
     *	@param	p_heap      q[v
     *	@param	p_device    foCX
     *	@param  p_graphics  OtBbNX
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectManager::Initialize( gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_device, Graphics* p_graphics, u32 workmax )
    {
      m_pGraphics = p_graphics;
      m_pHeap = p_heap;
      m_pDevice = p_device;

      // \[Xǂݍ
      this->LoadResource();
      
      // ֐̐
      m_pArray[TYPE_ENCKUSA00] = GFL_NEW( p_heap ) EffectEncKusa();
  

      

      // [Nm
      m_pWorkArray = static_cast<MoveModelEffectBase::Work*>(GflHeapAllocMemory( p_heap, sizeof(MoveModelEffectBase::Work) * workmax ));
      m_WorkMax = workmax;
  

      // [N̏
      for( u32 i=0; i<workmax; ++i ){
        MoveModelEffectBase::InitializeWork( &m_pWorkArray[i], this );
      }
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  j
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectManager::Finalize( void )
    {
      if(m_pWorkArray){
        //ғĂS[Nj
        for( u32 i=0; i<m_WorkMax; ++i ){
          this->DeleteEffect( i );
        }
        GflHeapFreeMemory( m_pWorkArray );
        m_pWorkArray = NULL;

        // ֐̔j
        for( u32 i=0; i<TYPE_MAX; ++i ){
          GFL_DELETE m_pArray[i];
        }

        // \[Xj
        this->ReleaseResource();
      }
    }


    //----------------------------------------------------------------------------
    /**
     *	@brief  XV
     *
     *	@param	[N
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectManager::Update( void )
    {
      for( u32 i=0; i<m_WorkMax; ++i ){
        if( MoveModelEffectBase::GetUseFlag( &m_pWorkArray[i] ) ){
          MoveModelEffectBase::UpdateModel( &m_pWorkArray[i], m_pHeap, m_pDevice );
        }
      }
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  GtFNg̐
     *
     *	@param	effect_type   GtFNg^Cv
     *	@param  p_model       f
     *
     *	@return GtFNg[N
     */
    //-----------------------------------------------------------------------------
    u32 MoveModelEffectManager::CreateEffect( Type effect_type, MoveModelBase* p_model )
    {
      u32 index;
      MoveModelEffectBase::Work* p_wk = this->GetClearWork( &index );
      
      
      if( effect_type < TYPE_MAX ){
        // GtFNg̐
        MoveModelEffectBase::SetUpModel( p_wk, p_model, m_pArray[effect_type] );
      }
      else
      {
        GFL_ASSERT( 0 );
        // GtFNg̐
        MoveModelEffectBase::SetUpModel( p_wk, p_model, m_pArray[0] );
      }

      return index;
    }


    //----------------------------------------------------------------------------
    /**
     *	@brief  GtFNg̔j    iIɔjBji
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectManager::DeleteEffect( u32 index )
    {
      if( MoveModelEffectBase::GetUseFlag( &m_pWorkArray[index] ) ){
        MoveModelEffectBase::ClearModel( &m_pWorkArray[index] );
      }
    }


    //----------------------------------------------------------------------------
    /**
     *	@brief  NA[N̎擾
     */
    //-----------------------------------------------------------------------------
    MoveModelEffectBase::Work* MoveModelEffectManager::GetClearWork(u32* p_index)
    {
      for( u32 i=0; i<m_WorkMax; ++i ){
        if( !MoveModelEffectBase::GetUseFlag( &m_pWorkArray[i] ) ){
          *p_index = i;
          return &m_pWorkArray[i];
        }
      }

      GFL_ASSERT_STOP(0);
      this->DeleteEffect( 0 );
      *p_index = 0;
      return &m_pWorkArray[0];
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  \[Xǂݍ
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectManager::LoadResource( void )
    {
      bool result;
      
      m_pResourceArray = GFL_NEW(m_pHeap) gfl::grp::g3d::Resource[ RES_MAX ];

      m_pArcFile = GFL_NEW( m_pHeap ) gfl::fs::ArcFile( ARCID_MMODEL_EFFECT );
      

      for( u32 i=0; i<RES_MAX; ++i ){
        result = m_pResourceArray[i].LoadAndSetup( m_pDevice, m_pArcFile, LoadResourceIndex[i] );
        if( !result ) {
          GFL_PRINT( "MoveModelEffectManager error %d\n", m_pResourceArray[i].GetResult() );
        }
      }
    }

    //----------------------------------------------------------------------------
    /**
     *	@brief  \[Xj
     */
    //-----------------------------------------------------------------------------
    void MoveModelEffectManager::ReleaseResource( void )
    {
      GFL_DELETE_ARRAY m_pResourceArray;
      GFL_DELETE m_pArcFile;
    }


  } // namespace mmodel
}  // namespace field
