//=================================================================================================
/**
 * @file EventAppCall.cpp
 * @brief AvP[ṼvZXĂяoCxg
 * @author obata_toshihiro
 * @date 2011.06.29
 */
//=================================================================================================
#include <gflib.h>
#include <system/main.h>
#include <gamesystem/GameEvent.h> 
#include <app/pokemon_status/app_poke_status_StatusProcess.h>
#include "EventAppCall.h"

namespace field { 




  //--------------------------------------------------------------
  // RXgN^
  //--------------------------------------------------------------
  EventAppCall::EventAppCall( gfl::heap::HeapBase* heap, GameEvent* parent ) : 
    gamesystem::GameEvent( heap, parent ),
    m_seq( 0 ),
    m_heap( NULL ),
    m_device_heap( NULL ) 
  {
  }


  //--------------------------------------------------------------
  // fXgN^
  //--------------------------------------------------------------
  EventAppCall::~EventAppCall()
  {
  }





  //--------------------------------------------------------------
  // Cxg𓮂Ă悢ǂ̔֐ z֐
  //--------------------------------------------------------------
  bool EventAppCall::BootChk( gamesystem::GameManager* game_manager )
  {
    GFL_UNUSED( game_manager );
    return true;
  }



  //--------------------------------------------------------------
  // bootchktruȅꍇɂĂяo鏉֐ z֐
  //--------------------------------------------------------------
  void EventAppCall::InitFunc( gamesystem::GameManager* game_manager )
  {
    GFL_UNUSED( game_manager );
  }



  //--------------------------------------------------------------
  // Ăяo֐ z֐
  //--------------------------------------------------------------
  gamesystem::GMEVENT_RESULT EventAppCall::MainFunc( gamesystem::GameManager* game_manager )
  {
    switch( m_seq ) {
    case 0:
      gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_WHITE_CAPTURE, 60, true );
      {
        EventFieldClose* event;
        event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventFieldClose>( game_manager->GetGameEventManager(), this );
        event->SetFadeFlag( false ); // tF[hȂ
        //event->SetFadeFlag( true ); // tF[h
      }
      ++m_seq;
      break;

    case 1:
      {
        gfl::heap::HeapBase* parent_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
        gfl::heap::HeapBase* parent_device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
        size_t app_heap_size = parent_heap->GetTotalAllocatableSize();
        size_t dev_heap_size = parent_device_heap->GetTotalAllocatableSize();
        m_heap = gfl::heap::Manager::CreateHeap( parent_heap, HEAPID_STATUS, app_heap_size, gfl::heap::HEAP_TYPE_EXP );
        m_device_heap = gfl::heap::Manager::CreateHeap( parent_device_heap, HEAPID_STATUS_DEVICE, dev_heap_size, gfl::heap::HEAP_TYPE_EXP );
      }
      ++m_seq;
      break;

    case 2:
      {
        gamesystem::GameProcManager* proc_manager = game_manager->GetProcManager();
        app::poke_status::StatusProcess::Settings settings;
        settings.heap = m_heap;
        settings.device_heap = m_device_heap;
        settings.graphics_system = game_manager->GetGraphicsSystem();
        settings.ui_device_manager = game_manager->GetUiDeviceManager();
        settings.poke_party = game_manager->GetGameData()->GetPlayerParty();
        settings.initial_pokemon_index = 0;
        app::poke_status::StatusProcess* status_process = GFL_NEW( proc_manager->GetHeap() ) app::poke_status::StatusProcess( settings );
        status_process->SetGameProcManager( proc_manager );
        proc_manager->CallProc( status_process ); 
        GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventProcessCall>( game_manager->GetGameEventManager(), this ); 
      }
      ++m_seq;
      break;

    case 3:
      gfl::heap::Manager::DeleteHeap( m_heap );
      gfl::heap::Manager::DeleteHeap( m_device_heap );
      ++m_seq;
      break;

    case 4:
      GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventFieldOpen>( game_manager->GetGameEventManager( ), this );
      ++m_seq;
      break;

    case 5:
      return gamesystem::GMEVENT_RES_FINISH;

    default:
      GFL_ASSERT(0);
      break;
    }

    return gamesystem::GMEVENT_RES_CONTINUE;
  }




  //--------------------------------------------------------------
  // Ăяo֐ z֐
  //--------------------------------------------------------------
  void EventAppCall::EndFunc( gamesystem::GameManager* game_manager )
  {
    GFL_UNUSED( game_manager );
  }



} // namespace field 
