//======================================================================
/**
 * @file	btlv_core_debug.h
 * @brief	og` fobO
 * @author	ariizumi
 * @data	11/06/29
 */
//======================================================================
#include <gflib.h>

#include "btlv_core.h"

namespace btl
{

extern void DebugWin_UpdateFocusRange( void *userWork );



void BattleViewSystem::InitDebugWin(void)
{
  gfl::debug::DebugWinGroup *topGroup = gfl::debug::DebugWin_AddGroup( L"Battle" );

  gfl::debug::DebugWinGroup *focusGroup = gfl::debug::DebugWin_AddGroup( L"ʊE[x" , topGroup );

  gfl::debug::DebugWinItemValueFloat<f32> *item;
  gfl::debug::DebugWinItemValueInt<bool> *itemBool;

  gfl::debug::DebugWin_AddItemValueBool( focusGroup , L"L/" , &mFocusEnable );
  itemBool = gfl::debug::DebugWin_AddItemValueBool( focusGroup , L"w/O" , &mFocusIsBack );
  itemBool->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"œ_" , &mFocusLenght , 0 , 10000.0f , 10.0f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂP@" , &mFocusRange[0] , 0 , 10000.0f , 10.0f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂxP" , &mFocusLevel[0] , 0 , 1.0f , 0.1f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂQ@" , &mFocusRange[1] , 0 , 10000.0f , 10.0f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂxQ" , &mFocusLevel[1] , 0 , 1.0f , 0.1f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂR@" , &mFocusRange[2] , 0 , 10000.0f , 10.0f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂxR" , &mFocusLevel[2] , 0 , 1.0f , 0.1f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂS@" , &mFocusRange[3] , 0 , 10000.0f , 10.0f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  item = gfl::debug::DebugWin_AddItemValueFloat( focusGroup , L"ڂxS" , &mFocusLevel[3] , 0 , 1.0f , 0.1f );
  item->SetChangedValueFunc( DebugWin_UpdateFocusRange , this );
  

  mFocusEnable = true;
  mFocusIsBack = true;
  mFocusLenght = 750.0f;
  mFocusRange[0] =   0.0f;
  mFocusRange[1] = 400.0f;
  mFocusRange[2] = 700.0f;
  mFocusRange[3] =1000.0f;
  mFocusLevel[0] =0.5f;
  mFocusLevel[1] =0.8f;
  mFocusLevel[2] =0.9f;
  mFocusLevel[3] =1.0f;
}

void BattleViewSystem::ExitDebugWin(void)
{
  gfl::debug::DebugWin_RemoveGroupByName( L"Battle" );  
}

void DebugWin_UpdateFocusRange( void *userWork )
{
  BattleViewSystem *core = static_cast<BattleViewSystem*>(userWork);
  
  if( core->mFocusIsBack )
  {
    core->GetScene()->SetDofType( gfl::grp::g3d::DofType::Back );
  }
  else
  {
    core->GetScene()->SetDofType( gfl::grp::g3d::DofType::Front );
  }

  core->GetScene()->SetFocusLength( core->mFocusLenght );
  for( int i =0;i<4;i++ )
  {
    core->GetScene()->SetFocusRange( i,core->mFocusRange[i],core->mFocusLevel[i]);
  }
}


}//namespace btl

