//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldGroundEffect.cpp
 *	@brief  tB[hnʃGtFNg
 *	@author	tomoya takahashi
 *	@date		2011.06.28
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "FieldGroundEffect.h"

#include "system/gfl_use.h"

#include "arc/arc_def.h"

namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------


  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   *
   *	@param	p_graphics  OtBbNXVXe
   *	@param  p_heap      q[v
   *	@param  p_device    foCXq[v
   */
  //-----------------------------------------------------------------------------
  GroundEffect::GroundEffect( Graphics* p_graphics, gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_device ) : 
    m_State(STATE_WAIT)
  {
    // V[NX擾
    m_pScene = p_graphics->GetScene();
    
    // m
    m_pParticleResourceArray = GFL_NEW(p_heap) gfl::grp::g3d::Resource[PARTICLE_MAX];
    m_pParticleArray = GFL_NEW(p_heap) gfl::grp::g3d::G3DPTCParticle[PARTICLE_MAX];
    m_pTextureResource = GFL_NEW(p_heap) gfl::grp::g3d::Resource;

    gfl::fs::ArcFile* p_arc = GFL_NEW(p_heap) gfl::fs::ArcFile( ARCID_FIELD_GROUND_EFFECT );
    
    // eNX`\[Xǂݍ݁B
    m_pTextureResource->Load( p_device, p_arc, RES_TEX_ID);

    gfl::grp::g3d::Resource::Description resource_description;
    u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
    common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_PARTICLE_DEFAULT_SHADER_BIT;

    u32 data_size;

    data_size = p_arc->GetDataSize(RES_PARTICLE_ID);
    m_pBuff[0] = GflHeapAllocMemoryAlign( p_device->GetHeapBase(), data_size, 128 );
    p_arc->LoadData( RES_PARTICLE_ID, m_pBuff[0] );
    for( u32 i=1; i<PARTICLE_MAX; ++i ){
      m_pBuff[i] = GflHeapAllocMemoryAlign( p_device->GetHeapBase(), data_size, 128 );
      gfl::std::MemCopy( m_pBuff[0], m_pBuff[i], data_size );
    }

    // p[eBN\[Xǂݍ @p[eBNIuWFNg
    for( u32 i=0; i<PARTICLE_MAX; ++i ){

      m_pParticleResourceArray[i].AttachBuffer( p_device, m_pBuff[i] );

      m_pParticleResourceArray[i].Setup( p_device, m_pTextureResource, common_resource_flag );

      m_pParticleArray[i].Create( p_device, p_device, &m_pParticleResourceArray[i] );

      m_pScene->AddParticleToSceneCalculateGroup( &(m_pParticleArray[i]), 0 );
      m_pScene->RemoveParticleFromSceneDrawGroup( &(m_pParticleArray[i]), 0 );
      m_pScene->AddParticleToSceneDrawGroup( &(m_pParticleArray[i]), SCENE_DRAW_GROUP_INDEX_PARTICLE );

    }


    GFL_DELETE p_arc;

  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  GroundEffect::~GroundEffect()
  {
    for( u32 i=0; i<PARTICLE_MAX; ++i ){
      m_pScene->RemoveSceneNode( &(m_pParticleArray[i]) );

      m_pParticleResourceArray[i].DetachBuffer();

      GFL_DELETE m_pBuff[i];
    }

    GFL_DELETE_ARRAY m_pParticleArray;
    GFL_DELETE_ARRAY m_pParticleResourceArray;
    GFL_DELETE m_pTextureResource;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Abvf[g
   */
  //-----------------------------------------------------------------------------
  void GroundEffect::Update( const gfl::math::VEC3& pos )
  {
    switch( m_State ){
    case STATE_WAIT:
      Wait();
      break;
    case STATE_COUNTUPA:
      AnimeA(pos);
      break;
    case STATE_COUNTUPB:
      AnimeB(pos);
      break;
    case STATE_COUNTUPC:
      AnimeC(pos);
      break;
    }
  }



  //----------------------------------------------------------------------------
  /**
   *	@brief  G~b^[̃GtFNgs~߂B
   */
  //-----------------------------------------------------------------------------
  void GroundEffect::Wait( void )
  {
    for( u32 i=0; i<PARTICLE_MAX; ++i ){
      m_pParticleArray[i].SetAllEmitterEmissionRatio(0.0f);
    }
    ++m_Count;

    if( m_Count > 128 ){
      this->SetState( STATE_COUNTUPA );
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ɉGtFNgoB
   */
  //-----------------------------------------------------------------------------
  void GroundEffect::AnimeA( const gfl::math::VEC3& pos )
  {
    switch( m_Seq ){
    // 
    case 0:
      {
        gfl::math::VEC3 emiter_pos = pos;
        emiter_pos.x -= 32.0f + static_cast<f32>(system::GflUse::GetPublicRand(32));
        emiter_pos.z -= static_cast<f32>(system::GflUse::GetPublicRand(64));
        for( u32 i=0; i<PARTICLE_MAX; ++i ){
          emiter_pos.x -= 16.0f + static_cast<f32>(system::GflUse::GetPublicRand(32)); 
          emiter_pos.z -= 16.0f + static_cast<f32>(system::GflUse::GetPublicRand(32));

          m_pParticleArray[i].SetTranslate( emiter_pos );
          m_pParticleArray[i].SetAllEmitterEmissionRatio(1.0f);
        }

        ++m_Seq;
      }
      break;

    //̂ގԂǗ
    case 1:
      ++m_Count;
      if( m_Count > WIND_COUNT ){
        this->SetState( STATE_COUNTUPB );
      }
      break;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ^񒆂ɉGtFNgoB
   */
  //-----------------------------------------------------------------------------
  void GroundEffect::AnimeB( const gfl::math::VEC3& pos )
  {
    switch( m_Seq ){
    // 
    case 0:
      {
        gfl::math::VEC3 emiter_pos = pos;
        emiter_pos.x += static_cast<f32>(system::GflUse::GetPublicRand(32));
        emiter_pos.z -= static_cast<f32>(system::GflUse::GetPublicRand(64));
        for( u32 i=0; i<PARTICLE_MAX; ++i ){
          emiter_pos.x -= 16.0f + static_cast<f32>(system::GflUse::GetPublicRand(32)); 
          emiter_pos.z -= 16.0f + static_cast<f32>(system::GflUse::GetPublicRand(32));

          m_pParticleArray[i].SetTranslate( emiter_pos );
          m_pParticleArray[i].SetAllEmitterEmissionRatio(1.0f);
        }

        ++m_Seq;
      }
      break;

    //̂ގԂǗ
    case 1:
      ++m_Count;
      if( m_Count > WIND_COUNT ){
        this->SetState( STATE_COUNTUPC );
      }
      break;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  EɉGtFNgoB
   */
  //-----------------------------------------------------------------------------
  void GroundEffect::AnimeC( const gfl::math::VEC3& pos )
  {
    switch( m_Seq ){
    // 
    case 0:
      {
        gfl::math::VEC3 emiter_pos = pos;
        emiter_pos.x += 64.0f + static_cast<f32>(system::GflUse::GetPublicRand(32));
        emiter_pos.z -= static_cast<f32>(system::GflUse::GetPublicRand(64));
        for( u32 i=0; i<PARTICLE_MAX; ++i ){
          emiter_pos.x -= 16.0f + static_cast<f32>(system::GflUse::GetPublicRand(32)); 
          emiter_pos.z -= 16.0f + static_cast<f32>(system::GflUse::GetPublicRand(32));

          m_pParticleArray[i].SetTranslate( emiter_pos );
          m_pParticleArray[i].SetAllEmitterEmissionRatio(1.0f);
        }

        ++m_Seq;
      }
      break;

    //̂ގԂǗ
    case 1:
      ++m_Count;
      if( m_Count > WIND_COUNT ){
        this->SetState( STATE_WAIT );
      }
      break;
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  Xe[gݒ
   *
   *	@param	State   Xe[g
   */
  //-----------------------------------------------------------------------------
  void GroundEffect::SetState( u32 State )
  {
    m_State = State;
    m_Count = 0;
    m_Seq   = 0;
  }


} // namespace field
