//=================================================================================================
/**
 * @file PokemonSoundSystem.h
 * @brief |PTEhNX
 * @author obata_toshihiro
 * @date 2011.06.28
 */
//=================================================================================================
#ifndef __POKEMONSOUNDSYSTEM_H__
#define __POKEMONSOUNDSYSTEM_H__
#include <gflib.h>


namespace snd {

  class SoundLevelManager;


  class PokemonSoundSystem : public gfl::base::Singleton<PokemonSoundSystem>
  {
    GFL_FORBID_COPY_AND_ASSIGN( PokemonSoundSystem );


    public: 

    // BGMtF[h̑x
    enum BgmFadeSpeed {
      BGM_FADE_NONE,       // 
      BGM_FADE_VERY_FAST,  // ƂĂ
      BGM_FADE_FAST,       // 
      BGM_FADE_MIDDLE,     // 
      BGM_FADE_SLOW,       // x
      BGM_FADE_NUM,
    };

    // BGM{[
    enum BgmVolumeLevel {
      BGM_VOLUME_LOW,     // 
      BGM_VOLUME_NORMAL,  // ʏ
      BGM_VOLUME_HIGH,    // 傫
      BGM_VOLUME_NUM,
    };


    //---------------------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param heap         CX^X̐Ɏgpq[v
     * @param device_heap  CX^X̐ɎgpfoCXq[v
     */
    //---------------------------------------------------------------------------------------------
    PokemonSoundSystem( gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap );

    //---------------------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //---------------------------------------------------------------------------------------------
    ~PokemonSoundSystem();

    //---------------------------------------------------------------------------------------------
    /**
     * @brief t[̍XV
     */
    //---------------------------------------------------------------------------------------------
    void Update( void );



    // BGM
    void PlayBGM( u32 sound_item_id, BgmFadeSpeed fade_in_speed );
    void StopBGM( BgmFadeSpeed fade_out_speed );
    void PauseBGM( BgmFadeSpeed fade_out_speed );
    void PauseReleaseBGM( BgmFadeSpeed fade_in_speed );
    void ChangeBGMVolume( BgmVolumeLevel volume_level, u32 change_frame );
    void ChangeBGMPitch( f32 value );
    void ChangeBGMPan( f32 value );
    void ChangeBGMSurroundPan( f32 value );
    void ChangeBGMTempoRatio( f32 value );
    bool PushBGM( void );
    bool PopBGM( void );


    // SE
    void PlaySE( u32 sound_item_id );
    void PlaySEVolume( u32 sound_item_id, f32 volume );
    void StopAllSE( void );




    private:

    // TEhnh̃CfbNX
    enum SoundHandleIndex { 
      SOUND_HANDLE_BGM_LV1,
      SOUND_HANDLE_BGM_LV2,
      SOUND_HANDLE_BGM_LV3,
      SOUND_HANDLE_SE,
      SOUND_HANDLE_NUM,
    };


    static const u32 BGM_FADE_FRAME[ BGM_FADE_NUM ];
    static const u32 BGM_VOLUME[ BGM_VOLUME_NUM ];


    gfl::snd::SoundSystem* m_sound_system;
    SoundLevelManager* m_bgm_level_manager; 


    void CreateSoundSystem( gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap );
    void CreateBGMLevelManager( gfl::heap::HeapBase* heap );

    void DeleteSoundSystem( void );
    void DeleteBGMLevelManager( void );




#if PM_DEBUG 
    public:
    gfl::snd::SoundSystem* GetSoundSystem( void );
    SoundLevelManager* GetBGMLevelManager( void );
#endif

  };



} // namespace snd


#endif // __POKEMONSOUNDSYSTEM_H__
