//======================================================================
/**
 * @file	btlv_particle.h
 * @brief	og` p[eBN
 * @author	ariizumi
 * @data	11/06/28
 */
//======================================================================
#pragma once

#include "btlv_types.h"
#include "btlv_particle.h"

namespace btl
{


typedef nw::ut::LinkList<BtlvParticle,offsetof(BtlvParticle,mNode)> ParticleList;

class BtlvParticleSys
{
GFL_FORBID_COPY_AND_ASSIGN(BtlvParticleSys);

public:
  BtlvParticleSys( BattleViewSystem *core );
  
  void Update(void);
  
  BtlvParticle* CreateParticle( const ParticleInitParam &initParam );
  void DeleteParticle( BtlvParticle* particle );
  
  bool IsFinishAll(void){return mList.empty();}
  
private:

  BattleViewSystem *mBtlvCore;
  ParticleList mList;

};

} //namespace btl
