//======================================================================
/**
 * @file	btlv_particle.h
 * @brief	og` p[eBN
 * @author	ariizumi
 * @data	11/06/28
 */
//======================================================================
#include <gflib.h>
#include "btlv_core.h"
#include "btlv_particle_sys.h"


namespace btl
{

BtlvParticleSys::BtlvParticleSys( BattleViewSystem *core )
:mBtlvCore(core)
{
  
}

void BtlvParticleSys::Update(void)
{
  for (ParticleList::Iterator it = mList.begin(); it != mList.end();)
  {
    ParticleList::Iterator currIt = it++;
    BtlvParticle *node = &(*currIt);
    node->Update();
    
    if( node->IsFinish() )
    {
      DeleteParticle(node);
    }
  }
}
  
BtlvParticle* BtlvParticleSys::CreateParticle( const ParticleInitParam &initParam )
{
  gfl::heap::HeapBase *heapMem = mBtlvCore->GetHeapMem();
  
  BtlvParticle *particle = GFL_NEW(heapMem)BtlvParticle(initParam,mBtlvCore);
  
  mList.push_back( particle );

  return particle;
}

void BtlvParticleSys::DeleteParticle( BtlvParticle* particle )
{
  mList.erase( particle );
  GFL_DELETE particle;
}

}
//namespace btl
